import { createElement, Fragment, Component } from '@wordpress/element'
import { Fill } from '@wordpress/components'
import DisplayCondition from './options/DisplayCondition'
import CustomizerOptionsManager from './options/CustomizerOptionsManager'

import { onDocumentLoaded } from 'noorgfx-options'

import ctEvents from 'ct-events'

import PanelsManager from './header/PanelsManager'

ctEvents.on('noorgfx:options:before-option', (args) => {
	if (!args.option) {
		return
	}

	if (args.option.type === 'ct-header-builder') {
		let prevHeaderBuilder = args.content

		args.content = (
			<Fragment>
				{prevHeaderBuilder}

				<Fill name="PlacementsBuilderPanelsManager">
					<PanelsManager />
				</Fill>
			</Fragment>
		)
	}
})

ctEvents.on('noorgfx:options:register', (opts) => {
	opts['noorgfx-display-condition'] = DisplayCondition
	opts['noorgfx-customizer-options-manager'] = CustomizerOptionsManager
})
