import { createElement } from '@wordpress/element'
import { __ } from 'ct-i18n'

import { InspectorControls } from '@wordpress/block-editor'
import { OptionsPanel } from 'noorgfx-options'
import NoorgfxToolsPanel from '../../../components/ToolsPanel'
import { useTaxonomyLayers } from '../../query/edit/layers/useTaxonomiesLayers'

import {
	__experimentalToggleGroupControl as ToggleGroupControl,
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
} from '@wordpress/components'

const TermsInspectorControls = ({
	context,
	attributes,
	attributes: { post_type },
	setAttributes,
}) => {
	const { taxonomiesGroup } = useTaxonomyLayers({
		attributes,
		setAttributes,
	})

	return (
		<InspectorControls>
			<NoorgfxToolsPanel
				className="ct-query-parameters-component"
				attributes={attributes}
				setAttributes={setAttributes}
				resetAll={() => {
					setAttributes({
						level: 'all',
						hide_empty: 'yes',
						offset: 0,
						orderby: 'none',
						order: 'desc',

						include_term_ids: {},
						exclude_term_ids: {},
					})
				}}
				items={[
					{
						label: __('General', 'noorgfx-component'),
						items: [
							{
								label: __('Offset', 'noorgfx-component'),

								hasValue: () => {
									return attributes.offset !== 0
								},

								reset: () => {
									setAttributes({
										offset: 0,
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												offset: {
													type: 'ct-number',
													label: __(
														'Offset',
														'noorgfx-component'
													),
													value: '',
													min: 0,
													max: 500,
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Order by', 'noorgfx-component'),

								hasValue: () => {
									return attributes.orderby !== 'none'
								},

								reset: () => {
									setAttributes({
										orderby: 'none',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												orderby: {
													type: 'ct-select',
													label: __(
														'Order by',
														'noorgfx-component'
													),
													value: '',
													choices: [
														{
															key: 'id',
															value: __(
																'ID',
																'noorgfx-component'
															),
														},

														{
															key: 'name',
															value: __(
																'Name',
																'noorgfx-component'
															),
														},

														{
															key: 'count',
															value: __(
																'Count',
																'noorgfx-component'
															),
														},

														{
															key: 'rand',
															value: __(
																'Random',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Order', 'noorgfx-component'),

								hasValue: () => {
									return attributes.order !== 'desc'
								},

								reset: () => {
									setAttributes({
										order: 'desc',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												order: {
													type: 'ct-select',
													label: __(
														'Order',
														'noorgfx-component'
													),
													value: '',
													choices: [
														{
															key: 'DESC',
															value: __(
																'Descending',
																'noorgfx-component'
															),
														},

														{
															key: 'ASC',
															value: __(
																'Ascending',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Level', 'noorgfx-component'),

								hasValue: () => {
									return attributes.level !== 'all'
								},

								reset: () => {
									setAttributes({
										level: 'all',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												level: {
													type: 'ct-select',
													label: __(
														'Level',
														'noorgfx-component'
													),
													value: '',
													choices: [
														{
															key: 'all',
															value: __(
																'All Taxonomies',
																'noorgfx-component'
															),
														},

														{
															key: 'parent',
															value: __(
																'Only Parent Taxonomies',
																'noorgfx-component'
															),
														},

														{
															key: 'relevant',
															value: __(
																'Relevant Taxonomies',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __(
									'Taxonomies Visibility',
									'noorgfx-component'
								),

								hasValue: () => {
									return attributes.hide_empty === 'no'
								},

								reset: () => {
									setAttributes({
										hide_empty: 'yes',
									})
								},

								render: () => {
									return (
										<ToggleGroupControl
											label={__(
												'Hide Empty Taxonomies',
												'noorgfx-component'
											)}
											value={attributes.hide_empty}
											isBlock
											onChange={(newValue) => {
												setAttributes({
													hide_empty: newValue,
												})
											}}>
											<ToggleGroupControlOption
												value="no"
												label={__(
													'No',
													'noorgfx-component'
												)}
											/>
											<ToggleGroupControlOption
												value="yes"
												label={__(
													'Yes',
													'noorgfx-component'
												)}
											/>
										</ToggleGroupControl>
									)
								},
							},
						],
					},

					...(taxonomiesGroup ? [taxonomiesGroup] : []),
				]}
				label={__('Parameters', 'noorgfx-component')}
			/>
		</InspectorControls>
	)
}

export default TermsInspectorControls
