<?php
/*
Plugin Name: ابزارک های هسته قالب زیبانو
Description: ابزارک های هسته قالب زیبانو
Version: 1.0.1
License: GPLv2 or later
Author: راست چین
Author URI: https://www.rtl-theme.com/author/masoud_afkani
Text Domain: noorgfx-component
Domain Path: /languages/
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function woocommerce_elementor_product_carousel_include_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-woocommerce-elementor-product-carousel-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'woocommerce_elementor_product_carousel_include_widget');

function woocommerce_elementor_product_carousel_register_widget() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \WooCommerce_Elementor_Product_Carousel_Widget());
}
add_action('elementor/widgets/widgets_registered', 'woocommerce_elementor_product_carousel_register_widget');

function woocommerce_elementor_product_carousel_enqueue_scripts() {
    wp_enqueue_style('slick', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1.8.1');
    wp_enqueue_style('slick-theme', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css', array(), '1.8.1');
    wp_enqueue_script('slick', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery'), '1.8.1', true);
    wp_enqueue_style('woocommerce-elementor-product-carousel', plugins_url('assets/css/style.css', __FILE__));
    wp_enqueue_script('woocommerce-elementor-product-carousel', plugins_url('assets/js/script.js', __FILE__), array('jquery', 'slick'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'woocommerce_elementor_product_carousel_enqueue_scripts');

function woocommerce_elementor_category_carousel_include_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-woocommerce-elementor-category-carousel-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'woocommerce_elementor_category_carousel_include_widget');

function woocommerce_elementor_category_carousel_register_widget() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \WooCommerce_Elementor_Category_Carousel_Widget());
}
add_action('elementor/widgets/widgets_registered', 'woocommerce_elementor_category_carousel_register_widget');

function wordpress_elementor_post_carousel_include_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-wordpress-elementor-post-carousel-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'wordpress_elementor_post_carousel_include_widget');

function wordpress_elementor_post_carousel_register_widget() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \WordPress_Elementor_Post_Carousel_Widget());
}
add_action('elementor/widgets/widgets_registered', 'wordpress_elementor_post_carousel_register_widget');

function image_hover_effect_include_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-image-hover-effect-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'image_hover_effect_include_widget');

function image_hover_effect_register_widget() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Image_Hover_Effect_Widget());
}
add_action('elementor/widgets/widgets_registered', 'image_hover_effect_register_widget');

function register_woocommerce_elementor_product_gallery_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-woocommerce-elementor-product-gallery-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'register_woocommerce_elementor_product_gallery_widget');

function woocommerce_elementor_product_gallery_widget_enqueue_scripts() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \WooCommerce_Elementor_Product_Gallery_Widget());
}
add_action('elementor/widgets/widgets_registered', 'woocommerce_elementor_product_gallery_widget_enqueue_scripts');

function wordpress_elementor_post_list_include_widget() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-wordpress-elementor-post-list-widget.php';
}
add_action('elementor/widgets/widgets_registered', 'wordpress_elementor_post_list_include_widget');

function wordpress_elementor_post_list_register_widget() {
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \WordPress_Elementor_Post_List_Widget());
}
add_action('elementor/widgets/widgets_registered', 'wordpress_elementor_post_list_register_widget'); 
