<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class WordPress_Elementor_Post_Carousel_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'wordpress_post_carousel';
    }

    public function get_title() {
        return __('چرخ فلک نوشته ها', 'wordpress-elementor-post-carousel');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }
    public function get_categories() {
        return ['nour-widgets'];
    }


    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'wordpress-elementor-post-carousel'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('ستون ها', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('تعداد نوشته ها', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => __('دسته بندی', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_post_categories(),
                'multiple' => true,
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => __('نمایش خلاصه', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'wordpress-elementor-post-carousel'),
                'label_off' => __('خیر', 'wordpress-elementor-post-carousel'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __('طول خلاصه', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 20,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );
$this->add_control(
    'navigation_dots',
    [
        'label' => __('نمایش ناوبری و نقطه ها', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'both',
        'options' => [
            'none' => __('هیچ', 'wordpress-elementor-post-carousel'),
            'navigation' => __('ناوبری', 'wordpress-elementor-post-carousel'),
            'dots' => __('نقطه ها', 'wordpress-elementor-post-carousel'),
            'both' => __('ناوبری و نقطه ها', 'wordpress-elementor-post-carousel'),
        ],
    ]
);
$this->add_control(
    'show_read_more',
    [
        'label' => __('نمایش دکمه ادامه مطلب', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('بله', 'wordpress-elementor-post-carousel'),
        'label_off' => __('خیر', 'wordpress-elementor-post-carousel'),
        'default' => 'yes',
    ]
);

$this->add_control(
    'read_more_text',
    [
        'label' => __('متن دکمه ادامه مطلب', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('ادامه مطلب', 'wordpress-elementor-post-carousel'),
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);
$this->add_control(
    'show_category',
    [
        'label' => __('نمایش دسته بندی', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('بله', 'wordpress-elementor-post-carousel'),
        'label_off' => __('خیر', 'wordpress-elementor-post-carousel'),
        'default' => 'yes',
    ]
);

$this->add_control(
    'show_date',
    [
        'label' => __('نمایش تاریخ انتشار', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('بله', 'wordpress-elementor-post-carousel'),
        'label_off' => __('خیر', 'wordpress-elementor-post-carousel'),
        'default' => 'yes',
    ]
);

$this->add_control(
    'show_author',
    [
        'label' => __('نمایش نویسنده', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('بله', 'wordpress-elementor-post-carousel'),
        'label_off' => __('خیر', 'wordpress-elementor-post-carousel'),
        'default' => 'yes',
    ]
);
        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'wordpress-elementor-post-carousel'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __('شعاع مرزی تصویر', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vertical_spacing',
            [
                'label' => __('فاصله عمودی', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-title' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .post-carousel-category' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .post-carousel-excerpt' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
$this->add_responsive_control(
    'card_spacing',
    [
        'label' => __('فاصله بین کارت ها', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
            'em' => [
                'min' => 0,
                'max' => 10,
            ],
            '%' => [
                'min' => 0,
                'max' => 20,
            ],
        ],
        'default' => [
            'unit' => 'px',
            'size' => 15,
        ],
        'selectors' => [
            '{{WRAPPER}} .post-carousel-item' => 'margin: {{SIZE}}{{UNIT}};',
        ],
    ]
);
        $this->add_control(
            'card_background_color',
            [
                'label' => __('رنگ زمینه کارت', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_border_radius',
            [
                'label' => __('شعاع مرزی کارت', 'wordpress-elementor-post-carousel'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'label' => __('حاشیه کارت', 'wordpress-elementor-post-carousel'),
                'selector' => '{{WRAPPER}} .post-carousel-item',
            ]
        );
$this->add_responsive_control(
    'card_padding',
    [
        'label' => __('فاصله داخلی', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
            '{{WRAPPER}} .post-carousel-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'read_more_style_heading',
    [
        'label' => __('استایل دکمه ادامه مطلب', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_group_control(
    \Elementor\Group_Control_Typography::get_type(),
    [
        'name' => 'read_more_typography',
        'label' => __('تایپوگرافی', 'wordpress-elementor-post-carousel'),
        'selector' => '{{WRAPPER}} .post-carousel-read-more',
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_control(
    'read_more_color',
    [
        'label' => __('رنگ متن', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .post-carousel-read-more' => 'color: {{VALUE}};',
        ],
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_control(
    'read_more_background_color',
    [
        'label' => __('رنگ پس زمینه', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .post-carousel-read-more' => 'background-color: {{VALUE}};',
        ],
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_group_control(
    \Elementor\Group_Control_Border::get_type(),
    [
        'name' => 'read_more_border',
        'label' => __('حاشیه', 'wordpress-elementor-post-carousel'),
        'selector' => '{{WRAPPER}} .post-carousel-read-more',
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_control(
    'read_more_border_radius',
    [
        'label' => __('شعاع مرزی', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .post-carousel-read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);

$this->add_control(
    'meta_style_heading',
    [
        'label' => __('استایل متا', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->add_group_control(
    \Elementor\Group_Control_Typography::get_type(),
    [
        'name' => 'meta_typography',
        'label' => __('تایپوگرافی', 'wordpress-elementor-post-carousel'),
        'selector' => '{{WRAPPER}} .post-carousel-meta',
    ]
);

$this->add_control(
    'meta_color',
    [
        'label' => __('رنگ متن', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .post-carousel-meta' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'avatar_size',
    [
        'label' => __('اندازه آواتار', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
            'px' => [
                'min' => 20,
                'max' => 60,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'px',
            'size' => 30,
        ],
        'selectors' => [
            '{{WRAPPER}} .post-carousel-author img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
        'condition' => [
            'show_author' => 'yes',
        ],
    ]
);
$this->add_responsive_control(
    'read_more_padding',
    [
        'label' => __('فاصله داخلی', 'wordpress-elementor-post-carousel'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
            '{{WRAPPER}} .post-carousel-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
            'show_read_more' => 'yes',
        ],
    ]
);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $columns = [
            'desktop' => $settings['columns'] ?? '3',
            'tablet' => $settings['columns_tablet'] ?? $settings['columns'] ?? '2',
            'mobile' => $settings['columns_mobile'] ?? $settings['columns'] ?? '1',
        ];

        $args = [
            'post_type' => 'post',
            'posts_per_page' => $settings['post_count'] ?? 6,
        ];

        if (!empty($settings['category'])) {
            $args['category__in'] = $settings['category'];
        }

        $posts = new WP_Query($args);
		$navigation_dots = $settings['navigation_dots'] ?? 'both';
if ($posts->have_posts()) {
    echo '<div class="wordpress-post-carousel" data-columns="' . esc_attr(json_encode($columns)) . '" data-navigation-dots="' . esc_attr($navigation_dots) . '">';

    while ($posts->have_posts()) {
        $posts->the_post();
        ?>
        <div class="post-carousel-item">
            <div class="post-carousel-image"><?php the_post_thumbnail('medium'); ?></div>
            <a href="<?php the_permalink(); ?>"><h3 class="post-carousel-title"><?php the_title(); ?></h3></a>
            <div class="post-carousel-meta">
                <?php if ($settings['show_excerpt'] === 'yes') : ?>
                    <div class="post-carousel-excerpt"><?php echo wp_trim_words(get_the_excerpt(), $settings['excerpt_length'], '...'); ?></div>
                <?php endif; ?>
            </div>
            <div class="post-carousel-footer">
                <?php if ($settings['show_read_more'] === 'yes') : ?>
                    <a href="<?php the_permalink(); ?>" class="post-carousel-read-more">
                        <?php echo esc_html($settings['read_more_text']); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="post-carousel-category-date">
                <?php if ($settings['show_category'] === 'yes') : ?>
                    <span class="post-carousel-category"><?php the_category(', '); ?></span>
                <?php endif; ?>
                <?php if ($settings['show_date'] === 'yes') : ?>
                    <span class="post-carousel-date"><?php echo get_the_date(); ?></span>
                <?php endif; ?>
                <?php if ($settings['show_author'] === 'yes') : ?>
                    <div class="post-carousel-author">
                        <?php echo get_avatar(get_the_author_meta('ID')); ?>
                        <span><?php the_author(); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }

    echo '</div>';
} else {
    echo __('نوشته ای یافت نشد', 'wordpress-elementor-post-carousel');
}

wp_reset_postdata();

    }

    private function get_post_categories() {
        $categories = get_categories();
        $options = [];

        foreach ($categories as $category) {
            $options[$category->term_id] = $category->name;
        }

        return $options;
    }
}