<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class WooCommerce_Elementor_Product_Gallery_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'woocommerce_product_gallery';
    }

    public function get_title() {
        return __('گالری محصولات', 'woocommerce-elementor-product-gallery');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['nour-widgets'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'woocommerce-elementor-product-gallery'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('ستون ها', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
            ]
        );

        $this->add_control(
            'product_source',
            [
                'label' => __('منبع محصولات', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'category' => __('دسته ها', 'woocommerce-elementor-product-gallery'),
                    'best_selling' => __('پرفروشترین ها', 'woocommerce-elementor-product-gallery'),
                    'latest' => __('جدیدترین ها', 'woocommerce-elementor-product-gallery'),
                ],
            ]
        );

        $this->add_control(
            'product_category',
            [
                'label' => __('دسته محصولات', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_product_categories(),
                'multiple' => true,
                'condition' => [
                    'product_source' => 'category',
                ],
            ]
        );

        $this->add_control(
            'product_count',
            [
                'label' => __('تعداد محصولات', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 10,
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('شعاع لبه', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __('عرض حاشیه', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item img' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_style',
            [
                'label' => __('سبک حاشیه', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('بدون حاشیه', 'woocommerce-elementor-product-gallery'),
                    'solid' => __('ساده', 'woocommerce-elementor-product-gallery'),
                    'dotted' => __('نقطه چین', 'woocommerce-elementor-product-gallery'),
                    'dashed' => __('خط چین', 'woocommerce-elementor-product-gallery'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item img' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => __('رنگ حاشیه', 'woocommerce-elementor-product-gallery'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-item img' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $columns = $settings['columns'] ?? '4';
        $columns_tablet = $settings['columns_tablet'] ?? '3';
        $columns_mobile = $settings['columns_mobile'] ?? '2';

        $args = [
            'post_type' => 'product',
            'posts_per_page' => $settings['product_count'] ?? 10,
        ];

        switch ($settings['product_source']) {
            case 'category':
                if (!empty($settings['product_category'])) {
                    $args['tax_query'] = [
                        [
                            'taxonomy' => 'product_cat',
                            'field' => 'term_id',
                            'terms' => $settings['product_category'],
                        ],
                    ];
                }
                break;
            case 'best_selling':
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
                break;
            case 'latest':
                $args['orderby'] = 'date';
                $args['order'] = 'DESC';
                break;
        }

        $products = new WP_Query($args);

        if ($products->have_posts()) {
                        echo '<div class="woocommerce-product-gallery-widget columns-' . esc_attr($columns) . ' columns-tablet-' . esc_attr($columns_tablet) . ' columns-mobile-' . esc_attr($columns_mobile) . '" data-columns-desktop="' . esc_attr($columns) . '" data-columns-tablet="' . esc_attr($columns_tablet) . '" data-columns-mobile="' . esc_attr($columns_mobile) . '">';
            while ($products->have_posts()) {
                $products->the_post();
                echo '<div class="product-item">';
                echo '<a href="' . get_the_permalink() . '">';
                echo get_the_post_thumbnail(get_the_ID(), 'large');
                echo '</a>';
                echo '</div>';
            }
            echo '</div>';
        } else {
            echo __('محصولی یافت نشد', 'woocommerce-elementor-product-gallery');
        }

        wp_reset_postdata();
    }

    private function get_product_categories() {
        $categories = get_terms('product_cat');
        $options = [];

        foreach ($categories as $category) {
            $options[$category->term_id] = $category->name;
        }

        return $options;
    }
}