<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class WooCommerce_Elementor_Product_Carousel_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'woocommerce_product_carousel';
    }

    public function get_title() {
        return __('چرخ فلک محصولات', 'woocommerce-elementor-product-carousel');
    }

    public function get_icon() {
        return 'eicon-carousel';
    }

    public function get_categories() {
        return ['nour-widgets']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'woocommerce-elementor-product-carousel'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('ستون ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );

        $this->add_control(
            'product_source',
            [
                'label' => __('منبع محصولات', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'category' => __('دسته ها', 'woocommerce-elementor-product-carousel'),
                    'best_selling' => __('پرفروشترین ها', 'woocommerce-elementor-product-carousel'),
                    'latest' => __('جدیدترین ها', 'woocommerce-elementor-product-carousel'),
                ],
            ]
        );

        $this->add_control(
            'product_category',
            [
                'label' => __('دسته محصولات', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_product_categories(),
                'multiple' => true,
                'condition' => [
                    'product_source' => 'category',
                ],
            ]
        );

        $this->add_control(
            'product_display_type',
            [
                'label' => __('نوع نمایش', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'type-1',
                'options' => [
                    'type-1' => __('نوع یک', 'woocommerce-elementor-product-carousel'),
                    'type-2' => __('نوع دو', 'woocommerce-elementor-product-carousel'),
                    'type-3' => __('نوع سه', 'woocommerce-elementor-product-carousel'),
                ],
                'description' => __('این گزینه می بایست با تنظیمات قالب یکی باشد <br> سفارشی سازی > آرشیو محصولات > تنظیمات فروشگاه', 'woocommerce-elementor-product-carousel'),
            ]
        );

        $this->add_control(
            'product_count',
            [
                'label' => __('تعداد محصولات', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 10,
            ]
        );

        $this->add_control(
            'navigation_dots',
            [
                'label' => __('نمایش ناوبری و نقطه ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'none' => __('هیچ', 'woocommerce-elementor-product-carousel'),
                    'navigation' => __('ناوبری', 'woocommerce-elementor-product-carousel'),
                    'dots' => __('نقطه ها', 'woocommerce-elementor-product-carousel'),
                    'both' => __('ناوبری و نقطه ها', 'woocommerce-elementor-product-carousel'),
                ],
            ]
        );

        $this->add_control(
            'product_order',
            [
                'label' => __('ترتیب محصولات', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('سعودی', 'woocommerce-elementor-product-carousel'),
                    'DESC' => __('نزولی', 'woocommerce-elementor-product-carousel'),
                ],
            ]
        );

        $this->end_controls_section();
    }

protected function render() {
        $settings = $this->get_settings_for_display();

        $columns = [
            'desktop' => $settings['columns'] ?? '4',
            'tablet' => $settings['columns_tablet'] ?? $settings['columns'] ?? '3',
            'mobile' => $settings['columns_mobile'] ?? $settings['columns'] ?? '2',
        ];

        $args = [
            'post_type' => 'product',
            'posts_per_page' => $settings['product_count'] ?? 10,
            'order' => $settings['product_order'] ?? 'DESC', 
        ];

        switch ($settings['product_source']) {
            case 'category':
                if (!empty($settings['product_category'])) {
                    $args['tax_query'] = [
                        [
                            'taxonomy' => 'product_cat',
                            'field' => 'term_id',
                            'terms' => $settings['product_category'],
                        ],
                    ];
                }
                break;
            case 'best_selling':
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
                break;
            case 'latest':
                $args['orderby'] = 'date';
                $args['order'] = $settings['product_order'] ?? 'DESC'; 
                break;
        }

        $products = new WP_Query($args);

        if ($products->have_posts()) {
            $product_display_type = $settings['product_display_type'] ?? 'type-1';
            $navigation_dots = $settings['navigation_dots'] ?? 'both';

            echo '<div class="woocommerce-product-carousel" data-products="' . esc_attr($product_display_type) . '" data-columns="' . esc_attr(json_encode($columns)) . '" data-navigation-dots="' . esc_attr($navigation_dots) . '">';
            
            while ($products->have_posts()) {
                $products->the_post();
                wc_get_template_part('content', 'product');
            }
            echo '</div>';
        } else {
            echo __('محصولی یافت نشد', 'woocommerce-elementor-product-carousel');
        }

        wp_reset_postdata();
    }

    private function get_product_categories() {
        $categories = get_terms('product_cat');
        $options = [];

        foreach ($categories as $category) {
            $options[$category->term_id] = $category->name;
        }

        return $options;
    }
}