<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class WooCommerce_Elementor_Category_Carousel_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'woocommerce_category_carousel';
    }

    public function get_title() {
        return __('دسته محصولات', 'woocommerce-elementor-product-carousel');
    }

    public function get_icon() {
        return 'eicon-carousel';
    }

    public function get_categories() {
        return ['nour-widgets']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'woocommerce-elementor-product-carousel'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('ستون ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',				
                    '9' => '9',	
                    '10' => '10',						
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('شعاع مرزی حاشیه', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category-item img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots',
            [
                'label' => __('نمایش ناوبری و نقطه ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'none' => __('هیچ', 'woocommerce-elementor-product-carousel'),
                    'navigation' => __('ناوبری', 'woocommerce-elementor-product-carousel'),
                    'dots' => __('نقطه ها', 'woocommerce-elementor-product-carousel'),
                    'both' => __('ناوبری و نقطه ها', 'woocommerce-elementor-product-carousel'),
                ],
            ]
        );

        $this->add_control(
            'item_spacing',
            [
                'label' => __('فاصله بین ستون ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category-item' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_count',
            [
                'label' => __('تعداد نمایش دسته ها', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 10,
            ]
        );

        $this->add_control(
            'image_width',
            [
                'label' => __('عرض تصویر', 'woocommerce-elementor-product-carousel'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category-item img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $columns = [
            'desktop' => $settings['columns'] ?? '4',
            'tablet' => $settings['columns_tablet'] ?? $settings['columns'] ?? '3',
            'mobile' => $settings['columns_mobile'] ?? $settings['columns'] ?? '2',
        ];

        $categories = get_terms('product_cat', [
            'hide_empty' => false,
            'number' => $settings['item_count'] ?? 10,
        ]);

        if (!empty($categories)) {
            $navigation_dots = $settings['navigation_dots'] ?? 'both';
            echo '<div class="woocommerce-category-carousel" data-columns="' . esc_attr(json_encode($columns)) . '" data-navigation-dots="' . esc_attr($navigation_dots) . '">';
            foreach ($categories as $category) {
                $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                $image = wp_get_attachment_url($thumbnail_id);
                $title = $category->name;

                echo '<div class="category-item">';
                if ($image) {
                    echo '<img src="' . esc_url($image) . '" alt="' . esc_attr($title) . '">';
                }
                echo '<div class="category-title">' . esc_html($title) . '</div>';
                echo '</div>';
            }
            echo '</div>';
        } else {
            echo __('دسته ای یافت نشد', 'woocommerce-elementor-product-carousel');
        }
    }
}