(function($) {
    'use strict';

    function initCarousel($scope) {
        var $carousel = $scope.find('.woocommerce-product-carousel');

        if ($carousel.length > 0) {
            var columns = JSON.parse($carousel.attr('data-columns'));
            var navigationDots = $carousel.attr('data-navigation-dots');

            var showDots = false;
            var showArrows = false;

            if (navigationDots === 'both') {
                showDots = true;
                showArrows = true;
            } else if (navigationDots === 'navigation') {
                showArrows = true;
            } else if (navigationDots === 'dots') {
                showDots = true;
            }

            if (!$carousel.hasClass('slick-initialized')) {
                $carousel.slick({
                    dots: showDots,
                    arrows: showArrows,
                    infinite: true,
                    speed: 300,
                    slidesToShow: parseInt(columns.desktop) || 4,
                    slidesToScroll: 1,
                    rtl: true,
                    responsive: [
                        {
                            breakpoint: 1024,
                            settings: {
                                slidesToShow: parseInt(columns.tablet) || 3,
                            }
                        },
                        {
                            breakpoint: 480,
                            settings: {
                                slidesToShow: parseInt(columns.mobile) || 1,
                            }
                        }
                    ]
                });
            }
        }
    }

    $(document).ready(function() {
        $('.woocommerce-product-carousel').each(function() {
            initCarousel($(this).parent());
        });
        if (typeof elementor !== 'undefined' && typeof elementorFrontend !== 'undefined') {
            elementorFrontend.hooks.addAction('frontend/element_ready/global', function($scope) {
                initCarousel($scope);
            });

            elementorFrontend.hooks.addAction('frontend/element_ready/woocommerce_product_carousel.default', function($scope) {
                initCarousel($scope);
            });
            elementor.channels.editor.on('change:device_mode', function() {
                $('.woocommerce-product-carousel').slick('unslick');
                $('.woocommerce-product-carousel').each(function() {
                    initCarousel($(this).parent());
                });
            });
        }
    });

  function initCategoryCarousel($scope) {
        var $carousel = $scope.find('.woocommerce-category-carousel');

        if ($carousel.length > 0) {
            var columns = JSON.parse($carousel.attr('data-columns'));
            var navigationDots = $carousel.attr('data-navigation-dots');

            var showDots = false;
            var showArrows = false;

            if (navigationDots === 'both') {
                showDots = true;
                showArrows = true;
            } else if (navigationDots === 'navigation') {
                showArrows = true;
            } else if (navigationDots === 'dots') {
                showDots = true;
            }

            if (!$carousel.hasClass('slick-initialized')) {
                $carousel.slick({
                    dots: showDots,
                    arrows: showArrows,
                    infinite: true,
					loop: true,
                    speed: 300,
                    slidesToShow: parseInt(columns.desktop) || 4,
                    slidesToScroll: 1,
                    rtl: true,
                    responsive: [
                        {
                            breakpoint: 1024,
                            settings: {
                                slidesToShow: parseInt(columns.tablet) || 3,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: parseInt(columns.mobile) || 2,
                            }
                        },
                        {
                            breakpoint: 480,
                            settings: {
                                slidesToShow: parseInt(columns.mobile) || 1,
                            }
                        }
                    ]
                });
            }
        }
    }

    $(document).ready(function() {
        $('.woocommerce-category-carousel').each(function() {
            initCategoryCarousel($(this).parent());
        });
        if (typeof elementor !== 'undefined' && typeof elementorFrontend !== 'undefined') {
            elementorFrontend.hooks.addAction('frontend/element_ready/global', function($scope) {
                initCategoryCarousel($scope);
            });

            elementorFrontend.hooks.addAction('frontend/element_ready/woocommerce_category_carousel.default', function($scope) {
                initCategoryCarousel($scope);
            });
            elementor.channels.editor.on('change:device_mode', function() {
                $('.woocommerce-category-carousel').slick('unslick');
                $('.woocommerce-category-carousel').each(function() {
                    initCategoryCarousel($(this).parent());
                });
            });
        }
    });
 function initPostCarousel($scope) {
    var $carousel = $scope.find('.wordpress-post-carousel');

    if ($carousel.length > 0) {
        var columns = JSON.parse($carousel.attr('data-columns'));
        var navigationDots = $carousel.attr('data-navigation-dots');

        var showDots = false;
        var showArrows = false;

        if (navigationDots === 'both') {
            showDots = true;
            showArrows = true;
        } else if (navigationDots === 'navigation') {
            showArrows = true;
        } else if (navigationDots === 'dots') {
            showDots = true;
        }

        if (!$carousel.hasClass('slick-initialized')) {
            $carousel.slick({
                dots: showDots,
                arrows: showArrows,
                infinite: true,
                speed: 300,
                slidesToShow: parseInt(columns.desktop) || 3,
                slidesToScroll: 1,
                rtl: true,
                responsive: [
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: parseInt(columns.tablet) || 2,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: parseInt(columns.mobile) || 1,
                        }
                    }
                ]
            });
        }
    }
}

    $(document).ready(function() {
        $('.wordpress-post-carousel').each(function() {
            initPostCarousel($(this).parent());
        });
        if (typeof elementor !== 'undefined' && typeof elementorFrontend !== 'undefined') {
            elementorFrontend.hooks.addAction('frontend/element_ready/wordpress_post_carousel.default', function($scope) {
                initPostCarousel($scope);
            });
            elementor.channels.editor.on('change:device_mode', function() {
                $('.wordpress-post-carousel').slick('unslick');
                $('.wordpress-post-carousel').each(function() {
                    initPostCarousel($(this).parent());
                });
            });
        }
    });
})(jQuery);

 (function ($) {
    $(document).ready(function () {
        $('.woocommerce-product-gallery-widget').each(function () {
            var $this = $(this);
            var columnsDesktop = $this.data('columns-desktop');
            var columnsTablet = $this.data('columns-tablet');
            var columnsMobile = $this.data('columns-mobile');

            $this.css('--columns-desktop', columnsDesktop);
            $this.css('--columns-tablet', columnsTablet);
            $this.css('--columns-mobile', columnsMobile);
        });
    });
})(jQuery); 