import {
	createElement,
	Component,
	useEffect,
	useState,
} from '@wordpress/element'
import { __ } from 'ct-i18n'
import { Switch, Select } from 'noorgfx-options'
import cls from 'classnames'

import { OptionsPanel } from 'noorgfx-options'

import nanoid from 'nanoid'

const MultipleLocationsSelect = ({ value, onChange, option: { choices } }) => {
	return (
		<div className="ct-controls-group">
			{value.map((l, index) => (
				<section key={l.__id}>
					<button
						type="button"
						className="ct-remove-condition-location"
						onClick={(e) => {
							e.preventDefault()
							onChange(
								value.filter(({ __id }) => l.__id !== __id)
							)
						}}>
						×
					</button>
					<OptionsPanel
						onChange={(optionId, optionValue) => {
							onChange(
								value.map((localL) =>
									localL.__id === l.__id
										? {
												...localL,
												[optionId]: optionValue,
										  }
										: localL
								)
							)
						}}
						options={{
							location: {
								label: false,
								type: 'noorgfx-hooks-select',
								search: true,
								value: '',
								design: 'none',
								defaultToFirstItem: false,
								choices,
								placeholder: __(
									'Select location',
									'noorgfx-component'
								),
							},

							priority: {
								label: false,
								type: 'ct-number',
								value: 10,
								min: 1,
								max: 100,
								design: 'none',
								attr: { 'data-width': 'full' },
							},

							condition: {
								type: 'ct-condition',
								condition: {
									location: 'custom_hook',
								},
								options: {
									custom_location: {
										label: __(
											'Custom Hook',
											'noorgfx-component'
										),
										type: 'text',
										value: '',
									},
								},
							},

							other_condition: {
								type: 'ct-condition',
								condition: {
									location:
										'noorgfx:single:content:paragraphs-number',
								},
								options: {
									paragraphs_count: {
										label: __(
											'After Block Number',
											'noorgfx-component'
										),
										type: 'ct-number',
										value: '3',
										design: 'inline',
										attr: {
											'data-width': 'full'
										},
									},
								},
							},

							other_condition_wh: {
								type: 'ct-condition',
								condition: {
									location:
										'noorgfx:single:content:headings-number',
								},
								options: {
									headings_count: {
										label: __(
											'Before Heading Number',
											'noorgfx-component'
										),
										type: 'ct-number',
										value: '3',
										design: 'inline',
										attr: {
											'data-width': 'full'
										},
									},
								},
							},

							other_condition_cards: {
								type: 'ct-condition',
								condition: {
									location: 'noorgfx:loop:card:cards-number',
								},
								options: {
									cards_count: {
										label: __(
											'After Card Number',
											'noorgfx-component'
										),
										type: 'ct-number',
										value: '3',
										design: 'inline',
										attr: {
											'data-width': 'full'
										},
									},

									repeat_for_every_card: {
										label: __(
											'Repeat',
											'noorgfx-component'
										),
										type: 'ct-switch',
										value: 'no',
										design: 'inline',
										wrapperAttr: {
											'data-location': 'block',
										},
									},
								},
							},
						}}
						value={l}
						hasRevertButton={false}
					/>
				</section>
			))}
			<button
				className="button"
				onClick={(e) => {
					e.preventDefault()

					onChange([
						...value,
						{
							__id: nanoid(),
							location: '',
							priority: 10,
							custom_location: '',
							paragraphs_count: '5',
						},
					])
				}}>
				{__('Add New Location', 'noorgfx-component')}
			</button>
		</div>
	)

	return (
		<Select
			onChangeFor={onChangeFor}
			onChange={(value) => {
				onChange(value)

				/*
				setTimeout(() => {
					onChangeFor(
						'priority',
						noorgfx_premium_admin.all_hooks.find(
							({ hook }) => hook === value
						).priority || 10
					)
				}, 1000)
                */
			}}
			{...props}
		/>
	)
}

export default MultipleLocationsSelect
