<?php

namespace Noorgfx;

class Premium {
	public $content_blocks = null;
	public $premium_header = null;
	public $premium_footer = null;
	public $code_editor = null;
	public $recently_viewed_products = null;

	public function __construct() {
		add_action(
			'init',
			function () {
				$this->load_premium_translations();
			}
		);

		$this->code_editor = new CodeEditor();

		require NOORGFX_PATH . '/framework/premium/helpers/helpers.php';
		require NOORGFX_PATH . '/framework/premium/helpers/content-blocks.php';

		$this->content_blocks = new ContentBlocks();
		new ContentBlocksLayer();
		new CopyOptions();

		new MaintenanceMode();

		$this->premium_header = new PremiumHeader();
		$this->premium_footer = new PremiumFooter();

		new Local_Gravatars_Init();

		new CloneCPT();
		new CaptchaToolsIntegration();

		new MediaVideo();
		// attachment metadata: now only works in pro version
		new VideoImportExport();

		new TaxonomySearch();

		$this->recently_viewed_products = new RecentlyViewedProducts();

		new SocialsExtra();

		new PerformanceTypography();

		new ImportExport();

		add_filter(
			'plugin_row_meta',
			function ($plugin_meta, $plugin_file, $plugin_data, $status) {
				if (! isset($plugin_data['slug'])) {
					return $plugin_meta;
				}

				if ($plugin_data['slug'] === 'noorgfx-component') {
					unset($plugin_meta[2]);
				}

				return $plugin_meta;
			},
			10,4
		);

		add_filter('noorgfx_extensions_paths', function ($p) {
			$p[] = NOORGFX_PATH . 'framework/premium/extensions';
			return $p;
		});

		$this->mount_integrations();

		add_action(
			'customize_preview_init',
			function () {
				if (! function_exists('get_plugin_data')) {
					require_once(ABSPATH . 'wp-admin/includes/plugin.php');
				}

				$data = get_plugin_data(NOORGFX__FILE__);

				wp_enqueue_script(
					'noorgfx-pro-customizer',
					NOORGFX_URL . 'framework/premium/static/bundle/sync.js',
					['ct-customizer'],
					$data['Version'],
					true
				);
			}
		);

		add_action(
			'admin_enqueue_scripts',
			function () {
				if (! function_exists('get_plugin_data')) {
					require_once(ABSPATH . 'wp-admin/includes/plugin.php');
				}

				global $wp_customize;

				$data = get_plugin_data(NOORGFX__FILE__);

				$deps = ['ct-options-scripts'];

				$current_screen = get_current_screen();

				if ($current_screen && $current_screen->id === 'customize') {
					$deps = ['ct-customizer-controls'];
				}

				wp_enqueue_script(
					'noorgfx-premium-admin-scripts',
					NOORGFX_URL . 'framework/premium/static/bundle/options.js',
					$deps,
					$data['Version'],
					true
				);

				$hooks_manager = new HooksManager();

				$localize = array_merge(
					[
						'all_hooks' => $hooks_manager->get_all_hooks(),
						'ajax_url' => admin_url('admin-ajax.php'),
						'rest_url' => get_rest_url(),
						'content_blocks' => blc_get_content_blocks(),
						'admin_url' => get_dashboard_url()
					],
					$this->code_editor->get_admin_localizations(),
					$this->premium_footer->get_admin_localizations(),
				);

				wp_localize_script(
					'noorgfx-premium-admin-scripts',
					'noorgfx_premium_admin',
					$localize
				);

				wp_enqueue_style(
					'noorgfx-premium-styles',
					NOORGFX_URL . 'framework/premium/static/bundle/options.min.css',
					[],
					$data['Version']
				);
			},
			50
		);

		add_filter('noorgfx:general:ct-scripts-localizations', function ($data) {
			$data['dynamic_styles_selectors'][] = [
				'selector' => '.ct-media-container[data-media-id], .ct-dynamic-media[data-media-id]',
				'url' => noorgfx_cdn_url(
					NOORGFX_URL . 'framework/premium/static/bundle/video-lazy.min.css'
				)
			];

			return $data;
		});

		add_action('wp_enqueue_scripts', function () {
			if (! function_exists('get_plugin_data')) {
				require_once(ABSPATH . 'wp-admin/includes/plugin.php');
			}

			$data = get_plugin_data(NOORGFX__FILE__);

			if (! isset($_GET['noorgfx_preview_hooks'])) {
				return;
			}

			wp_enqueue_script(
				'noorgfx-pro-scripts',
				NOORGFX_URL . 'framework/premium/static/bundle/frontend.js',
				['ct-scripts'],
				$data['Version'],
				true
			);
		});
	}

	public function load_premium_translations() {
		/**
		 * Load Noorgfx textdomain.
		 *
		 * Load gettext translate for noorgfx-component text domain.
		 * This needs to happen only for Pro version because version from
		 * wp.org will pick up its language automatically.
		 */
		load_plugin_textdomain(
			'noorgfx-component',
			false,
			dirname(NOORGFX_PLUGIN_BASE) . '/languages'
		);

		if (! class_exists('WP_Translation_Controller')) {
			return;
		}

		$locale = determine_locale();

		$i18n_controller = \WP_Translation_Controller::get_instance();

		$preferred_format = apply_filters(
			'translation_file_format',
			'php',
			'noorgfx-component'
		);

		if (! in_array($preferred_format, array('php', 'mo'), true)) {
			$preferred_format = 'php';
		}

		$mofile = 'noorgfx-component' . '-' . $locale;

		$file_extension = 'mo';

		if ($preferred_format === 'php') {
			// $file_extension = 'l10n.php';
		}

		$mofile = $mofile . '.' . $file_extension;

		$file_path = NOORGFX_PATH . 'languages/' . $mofile;

		if (! file_exists($file_path)) {
			return;
		}

		$res = $i18n_controller->load_file(
			$file_path,
			'noorgfx-component',
			$locale
		);
	}

	private function mount_integrations() {
		add_action('plugins_loaded', function () {
			if (class_exists('Elementor\Plugin')) {
				new PluginIntegrations\Elementor();
			}
		});
	}
}
