<?php

namespace Noorgfx;

class SocialsExtra {
	public function __construct() {
		add_filter(
			'noorgfx:socials:options:icon',
			function($opts) {
				foreach ($opts as $id => $network) {
					$opts[$id]['options'] = [
						'icon_source' => [
							'label' => __( 'Icon Source', 'noorgfx-component' ),
							'type' => 'ct-radio',
							'value' => 'default',
							'view' => 'text',
							'design' => 'block',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'default' => __( 'Default', 'noorgfx-component' ),
								'custom' => __( 'Custom', 'noorgfx-component' ),
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['icon_source' => 'custom'],
							'options' => [
								'icon' => [
									'type' => 'icon-picker',
									'label' => __('Icon', 'noorgfx-component'),
									'design' => 'inline',
									'value' => [
										'icon' => 'blc blc-email'
									]
								]
							]
						],

						'url_source' => [
							'label' => __( 'URL Source', 'noorgfx-component' ),
							'type' => 'ct-radio',
							'value' => 'default',
							'view' => 'text',
							'design' => 'block',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'default' => __( 'Default', 'noorgfx-component' ),
								'custom' => __( 'Custom', 'noorgfx-component' ),
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['url_source' => 'custom'],
							'options' => [
								'custom_url' => [
									'type' => 'text',
									'label' => __('Custom URL', 'noorgfx-component'),
									'design' => 'block',
									'value' => ''
								]
							]
						],
					];
				}

				return $opts;
			}
		);
    }
}
