<?php

$top_level_common_options = noorgfx_get_options(
	dirname(__FILE__) . '/common.php',
	[
		'sync_id' => $sync_id
	],
	false
);

$dropdown_options = noorgfx_get_options(
	dirname(__FILE__) . '/common.php',
	[
		'sync_id' => $sync_id,
		'prefix' => 'dropdown'
	],
	false
);

$general_options = [
	$top_level_common_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'language_type/custom_icon' => true ],
			'options' => [
				'custom_icon' => [
					'type' => 'icon-picker',
					'label' => __('Icon', 'noorgfx-component'),
					'design' => 'inline',
					'divider' => 'top',
					'value' => [
						'icon' => 'blc blc-globe',
					],
					'sync' => [
						'id' => $sync_id
					]
				],

				'ls_icon_size' => [
					'label' => __( 'Icon Size', 'noorgfx-component' ),
					'type' => 'ct-slider',
					'min' => 5,
					'max' => 50,
					'value' => 15,
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],
			],
		],
	]
];

$bottom_options = [
	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => __( 'Dropdown Options', 'noorgfx-component' ),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			$dropdown_options,

			'ls_dropdown_offset' => [
				'label' => __( 'Dropdown Top Offset', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'value' => 15,
				'min' => 0,
				'max' => 50,
				'divider' => 'top',
			],

			'ls_dropdown_items_spacing' => [
				'label' => __( 'Items Vertical Spacing', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'value' => 15,
				'min' => 5,
				'max' => 30,
			],

			'ls_dropdown_arrow' => [
				'label' => __( 'Dropdown Arrow', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top',
				'sync' => [
					'id' => $sync_id
				]
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [
			'ls_dropdown_font' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx-component' ),
				'value' => noorgfx_typography_default_values(),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'ls_dropdown_font_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'divider' => 'bottom',

				'value' => [
					'default' => [
						'color' => '#ffffff',
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx-component' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'ls_dropdown_background' => [
				'label' => __( 'Background Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'divider' => 'bottom',

				'value' => [
					'default' => [
						'color' => '#29333C',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],
				],
			],

			'ls_dropdown_divider' => [
				'label' => __( 'Items Divider', 'noorgfx-component' ),
				'type' => 'ct-border',
				'design' => 'inline',
				'divider' => 'bottom',
				'value' => [
					'width' => 1,
					'style' => 'dashed',
					'color' => [
						'color' => 'rgba(255, 255, 255, 0.1)',
					],
				]
			],

			'ls_dropdown_shadow' => [
				'label' => __( 'Shadow', 'noorgfx-component' ),
				'type' => 'ct-box-shadow',
				'design' => 'inline',
				// 'responsive' => true,
				'divider' => 'bottom',
				'value' => noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 10,
					'blur' => 20,
					'spread' => 0,
					'inset' => false,
					'color' => [
						'color' => 'rgba(41, 51, 61, 0.1)',
					],
				])
			],

			'ls_dropdown_radius' => [
				'label' => __( 'Border Radius', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'value' => noorgfx_spacing_value(),
				'inputAttr' => [
					'placeholder' => '2'
				],
				'min' => 0,
			],

		],
	],
];

$design_options = [
	'ls_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Font', 'noorgfx-component' ),
		'value' => noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n6',
			'text-transform' => 'uppercase',
		])
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-labeled-group',
		'label' => __( 'Font Color', 'noorgfx-component' ),
		'responsive' => true,
		'choices' => [
			[
				'id' => 'ls_label_color',
				'label' => __('Default State', 'noorgfx-component')
			],

			[
				'id' => 'transparent_ls_label_color',
				'label' => __('Transparent State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_transparent_header' => 'yes',
				],
			],

			[
				'id' => 'sticky_ls_label_color',
				'label' => __('Sticky State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_sticky_header' => 'yes',
				],
			],
		],
		'options' => [

			'ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => 'var(--theme-text-color)',
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'transparent_ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
					],
				],
			],

			'sticky_ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
					],
				],
			],

		],
	],


	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'language_type/custom_icon' => true ],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icon Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'ls_custom_icon_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_ls_custom_icon_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_ls_custom_icon_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'ls_custom_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)'
							],
						],
					],

					'transparent_ls_custom_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

					'sticky_ls_custom_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

		],
	],


	'ls_margin' => [
		'label' => __( 'Margin', 'noorgfx-component' ),
		'type' => 'ct-spacing',
		'divider' => 'top',
		'value' => noorgfx_spacing_value(),
		'responsive' => true
	],

];
