<?php

if (isset($prefix)) {
	$prefix .= '_';
} else {
	$prefix = '';
}

$options = [
	$prefix . 'language_type' => [
		'label' => __( 'Display Type', 'noorgfx-component' ),
		'type' => 'ct-checkboxes',
		'design' => 'block',
		'view' => 'text',
		'divider' => 'top',
		'value' => [
			'icon' => true,
			'label' => true,
		],

		'choices' => noorgfx_ordered_keys([
			'icon' => __( 'Flag', 'noorgfx-component' ),
			'label' => __( 'Label', 'noorgfx-component' ),
		]),

		'sync' => [
			'id' => $sync_id
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			$prefix . 'language_type/label' => true
		],
		'options' => [
			$prefix . 'language_label' => [
				'label' => __( 'Label Style', 'noorgfx-component' ),
				'type' => 'ct-radio',
				'value' => 'long',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'choices' => [
					'long' => __( 'Long', 'noorgfx-component' ),
					'short' => __( 'Short', 'noorgfx-component' ),
				],
				'sync' => [
					'id' => $sync_id
				]
			],

			$prefix . 'language_label_position' => [
				'type' => 'ct-radio',
				'label' => __( 'Label Position', 'noorgfx-component' ),
				'value' => 'right',
				'view' => 'text',
				'divider' => 'top',
				'design' => 'block',
				'responsive' => [ 'tablet' => 'skip' ],
				'choices' => [
					'left' => __( 'Left', 'noorgfx-component' ),
					'right' => __( 'Right', 'noorgfx-component' ),
					'bottom' => __( 'Bottom', 'noorgfx-component' ),
				],
			],
		],
	],

];