<?php

$class = 'ct-contact-info';

$visibility = noorgfx_default_akg(
	'visibility',
	$atts,
	[
		'tablet' => true,
		'mobile' => true,
	]
);

if ($panel_type === 'footer') {
	$visibility = noorgfx_default_akg(
		'footer_contacts_visibility',
		$atts,
		[
			'desktop' => true,
			'tablet' => true,
			'mobile' => true
		]
	);
}

$class = trim($class . ' ' . noorgfx_visibility_classes($visibility));

$contact_items = noorgfx_default_akg(
	'contact_items',
	$atts,
	[
		[
			'id' => 'address',
			'enabled' => true,
			'title' => __('Address:', 'noorgfx-component'),
			'content' => 'خیابان یکم پلاک دوم',
			'link' => '',
		],

		[
			'id' => 'phone',
			'enabled' => true,
			'title' => __('Phone:', 'noorgfx-component'),
			'content' => '021-12345678',
			'link' => 'tel:021-12345678',
		],

		[
			'id' => 'mobile',
			'enabled' => true,
			'title' => __('Mobile:', 'noorgfx-component'),
			'content' => '021-12345678',
			'link' => 'tel:021-12345678',
		],
	]
);

$text = noorgfx_translate_dynamic(
	noorgfx_default_akg('header_button_text', $atts, __('Download', 'noorgfx-component')),
	$panel_type . ':' . $section_id . ':button:header_button_text'
);

foreach ($contact_items as $item_index => $single_item) {
	if (isset($single_item['title'])) {
		$contact_items[$item_index]['title'] = noorgfx_translate_dynamic(
			$single_item['title'],
			$panel_type . ':' . $section_id . ':contacts:contact_items:' . $single_item['id'] . ':title'
		);
	}

	if (isset($single_item['content'])) {
		$contact_items[$item_index]['content'] = noorgfx_translate_dynamic(
			$single_item['content'],
			$panel_type . ':' . $section_id . ':contacts:contact_items:' . $single_item['id'] . ':content'
		);
	}

	if (isset($single_item['link'])) {
		$contact_items[$item_index]['link'] = noorgfx_translate_dynamic(
			$single_item['link'],
			$panel_type . ':' . $section_id . ':contacts:contact_items:' . $single_item['id'] . ':link'
		);
	}
}

echo noorgfx_html_tag(
	'div',
	array_merge([
		'class' => $class
	], $attr),
	blc_get_contacts_output([
		'data' => $contact_items,
		'link_target' => noorgfx_default_akg('link_target', $atts, 'no'),
		'link_nofollow' => noorgfx_default_akg('link_nofollow', $atts, 'no'),
		'link_icons' => noorgfx_default_akg('link_icons', $atts, 'no'),
		'type' => noorgfx_akg('contacts_icon_shape', $atts, 'rounded'),
		'fill' => noorgfx_akg('contacts_icon_fill_type', $atts, 'outline')
	])
);

