<?php

$options = [

	'media_video_source' => [
		'label' => __( 'Video Source', 'noorgfx-component' ),
		'type' => 'ct-radio',
		'value' => 'upload',
		'view' => 'text',
		'design' => 'block',
		'setting' => [ 'transport' => 'postMessage' ],
		'choices' => [
			'upload' => __( 'Upload', 'noorgfx-component' ),
			'youtube' => __( 'YouTube', 'noorgfx-component' ),
			'vimeo' => __( 'Vimeo', 'noorgfx-component' ),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'media_video_source' => 'upload' ],
		'options' => [

			'media_video_upload' => [
				'label' => __( 'Upload Video', 'noorgfx-component' ),
				'type' => 'ct-file-uploader',
				'value' => '',
                'mediaType' => 'video',
                'desc' => __( 'Upload an MP4 file into the media library.', 'noorgfx-component' ),
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'media_video_source' => 'youtube' ],
		'options' => [

			'media_video_youtube_url' => [
				'type' => 'text',
				'label' => __( 'YouTube Url', 'noorgfx-component' ),
				'design' => 'block',
				'desc' => __( 'Enter a valid YouTube media URL.', 'noorgfx-component' ),
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'media_video_source' => 'vimeo' ],
		'options' => [

			'media_video_vimeo_url' => [
				'type' => 'text',
				'label' => __( 'Vimeo Url', 'noorgfx-component' ),
				'design' => 'block',
				'desc' => __( 'Enter a valid Vimeo media URL.', 'noorgfx-component' ),
			],

		],
	],

	'media_video_event' => [
		'label' => __( 'Playback Trigger', 'noorgfx-component' ),
		'desc' => __( 'Select when the video thumbnail should start playing - on click, on hover, or as soon as the page loads.', 'noorgfx-component' ),
		'type' => 'ct-radio',
		'value' => blc_theme_functions()->noorgfx_get_theme_mod('media_video_autoplay', 'no') === 'yes' ? 'autoplay' : 'click',
		'view' => 'text',
		'design' => 'block',
		'divider' => 'top',
		'setting' => [ 'transport' => 'postMessage' ],
		'choices' => [
			'click' => __( 'Click', 'noorgfx-component' ),
			'hover' => __( 'Hover', 'noorgfx-component' ),
			'autoplay' => __( 'Autoplay', 'noorgfx-component' ),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'media_video_event' => 'hover' ],
		'options' => [

			'media_video_hover_revert' => [
				'type'  => 'ct-switch',
				'label' => __( 'Pause on Hover Out', 'noorgfx-component' ),
				'value' => 'yes',
				'divider' => 'top',
				'desc' => __( 'Automatically pauses the video when the user stops hovering.', 'noorgfx-component' ),
			],

		],
	],

	// 'media_video_autoplay' => [
	// 	'type'  => 'ct-switch',
	// 	'label' => __( 'Autoplay Video', 'noorgfx-component' ),
	// 	'value' => 'no',
	// 	'divider' => 'top',
	// 	'desc' => __( 'Automatically start video playback after the gallery is loaded.', 'noorgfx-component' ),
	// ],

	'media_video_loop' => [
		'type'  => 'ct-switch',
		'label' => __( 'Loop Video', 'noorgfx-component' ),
		'value' => 'no',
		'divider' => 'top',
		'desc' => __( 'Start video again after it ends.', 'noorgfx-component' ),
	],

	'media_video_player' => [
		'type'  => 'ct-switch',
		'label' => __( 'Simplified Player', 'noorgfx-component' ),
		'value' => 'no',
		'divider' => 'top',
		'desc' => __( 'Display a minimalistic view of the video player.', 'noorgfx-component' ),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'media_video_player' => 'yes' ],
		'options' => [

			'media_video_size' => [
				'label' => __( 'Video Size', 'noorgfx-component' ),
				'type' => 'ct-radio',
				'value' => 'contain',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'contain' => __( 'Contain', 'noorgfx-component' ),
					'cover' => __( 'Cover', 'noorgfx-component' ),
				],
				'desc' => blc_safe_sprintf(
					// translators: placeholder here means the actual URL.
					__( "Choose how the video will fill its container. More info about this can be found %shere%s.", 'noorgfx-component' ),
					blc_safe_sprintf(
						'<a href="%s" target="_blank">',
						'#'
					),
					'</a>'
				),
			],

		],
	],	
];

