<?php

namespace Noorgfx;

class ContentBlocksAdminUi {
	private $shortcode = 'noorgfx-content-block';
	private $post_type = 'ct_content_block';

	public function __construct() {
		add_filter('noorgfx:editor:post_meta_options', function ($options, $post_type) {
			if ($post_type !== $this->post_type) {
				return $options;
			}

			global $post;

			$post_id = $post->ID;

			$current_screen = get_current_screen();

			if (
				$current_screen
				&&
				$current_screen->action === 'add'
				&&
				isset($_GET['trid'])
				&&
				intval($_GET['trid']) > 0
			) {
				$post_id = \SitePress::get_original_element_id_by_trid(
					$_GET['trid']
				);
			}

			$template_type = get_post_meta($post_id, 'template_type', true);

			return noorgfx_akg(
				'options',
				blc_theme_functions()->noorgfx_get_variables_from_file(
					dirname(
						__FILE__
					) . '/options/' . $template_type . '.php',
					['options' => []]
				)
			);
		}, 10, 2);

		add_filter(
			'noorgfx:editor:post_types_for_rest_field',
			function ($post_types) {
				$post_types[] = $this->post_type;
				return $post_types;
			}
		);

		add_filter('removable_query_args', function ($qs) {
			$qs[] = 'ct_enabled_hooks';
			$qs[] = 'ct_disabled_hooks';

			return $qs;
		});

		add_action('wp_ajax_noorgfx_content_noorgfx_create', function () {
			$capability = blc_get_capabilities()->get_wp_capability_by(
				'custom_post_type',
				[
					'post_type' => $this->post_type
				]
			);

			if (! current_user_can($capability)) {
				wp_send_json_error();
			}

			if (! isset($_REQUEST['name'])) {
				wp_send_json_error();
			}

			if (! isset($_REQUEST['type'])) {
				wp_send_json_error();
			}

			$post = [];

			$post['post_title'] = $_REQUEST['name'];
			$post['post_status'] = 'publish';
			$post['post_type'] = $this->post_type;

			$post_id = wp_insert_post($post);

			if (! $post_id) {
				wp_send_json_error();
			}

			update_post_meta($post_id, 'template_type', $_REQUEST['type']);

			if ($_REQUEST['type'] === 'maintenance') {
				$post = get_post($post_id);

				$post->post_content = '<!-- wp:group {"style":{"dimensions":{"minHeight":"100vh"},"spacing":{}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"center"}} -->
				<div class="wp-block-group" style="min-height:100vh"><!-- wp:heading {"textAlign":"center"} -->
				<h2 class="wp-block-heading has-text-align-center" id="site-under-construction">Site Under Construction</h2>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}},"fontSize":"medium"} -->
				<p class="has-text-align-center has-medium-font-size" style="margin-bottom:var(--wp--preset--spacing--40)">Our website is currently undergoing scheduled maintenance.<br>Thank you for your understanding.</p>
				<!-- /wp:paragraph -->

				<!-- wp:social-links {"iconColor":"palette-color-3","iconColorValue":"var(\u002d\u002dtheme-palette-color-3, #365951)","showLabels":true,"size":"has-small-icon-size","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"horizontal","justifyContent":"center"}} -->
				<ul class="wp-block-social-links has-small-icon-size has-visible-labels has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"facebook"} /-->

				<!-- wp:social-link {"url":"#","service":"twitter"} /-->

				<!-- wp:social-link {"url":"#","service":"linkedin"} /-->

				<!-- wp:social-link {"url":"#","service":"mail"} /--></ul>
				<!-- /wp:social-links --></div>
				<!-- /wp:group -->';

				wp_update_post($post);
			}

			if (
				isset($_GET['predefined_hook'])
				&&
				is_string($_GET['predefined_hook'])
			) {
				$predefined_values = explode(
					'::',
					sanitize_text_field($_GET['predefined_hook'])
				);

				$default_hook = $predefined_values[0];
				$default_priority = 10;

				if (count($predefined_values) > 1) {
					$default_priority = intval($predefined_values[1]);
				}

				$value = [
					'location' => $default_hook,
					'priority' => $default_priority
				];

				update_post_meta($post_id, 'noorgfx_post_meta_options', $value);
			}

			wp_send_json_success([
				'name' => $_REQUEST['name'],
				'url' => get_edit_post_link($post_id, '&')
			]);
		});

		add_filter('bulk_actions-edit-ct_content_block', function ($bulk_actions) {
			$bulk_actions['ct_enable'] = __('Enable', 'noorgfx-component');
			$bulk_actions['ct_disable'] = __('Disable', 'noorgfx-component');

			return $bulk_actions;
		});

		add_filter(
			'handle_bulk_actions-edit-ct_content_block',
			function ($redirect_to, $doaction, $post_ids) {
				if ($doaction === 'ct_enable') {
					foreach ($post_ids as $post_id) {
						$atts = noorgfx_get_post_options($post_id);
						$atts['is_hook_enabled'] = 'yes';
						update_post_meta($post_id, 'noorgfx_post_meta_options', $atts);
					}

					$redirect_to = add_query_arg(
						'ct_enabled_hooks',
						count($post_ids),
						$redirect_to
					);
				}

				if ($doaction === 'ct_disable') {
					foreach ($post_ids as $post_id) {
						$atts = noorgfx_get_post_options($post_id);
						$atts['is_hook_enabled'] = 'no';
						update_post_meta($post_id, 'noorgfx_post_meta_options', $atts);
					}

					$redirect_to = add_query_arg(
						'ct_disabled_hooks',
						count($post_ids),
						$redirect_to
					);
				}

				return $redirect_to;
			},
			10, 3
		);

		add_action('admin_notices', function () {
			if (! empty($_REQUEST['ct_enabled_hooks'])) {
				$count = intval($_REQUEST['ct_enabled_hooks']);

				echo noorgfx_html_tag(
					'div',
					[
						'id' => 'message',
						'class' => 'updated notice is-dismissible'
					],
					noorgfx_html_tag(
						'p',
						[],
						blc_safe_sprintf(
							_n(
								'Enabled %s content block.',
								'Enabled %s content blocks.',
								$count,
								'noorgfx-component'
							),
							$count
						)
					)
				);
			}

			if (! empty($_REQUEST['ct_disabled_hooks'])) {
				$count = intval($_REQUEST['ct_disabled_hooks']);

				echo noorgfx_html_tag(
					'div',
					[
						'id' => 'message',
						'class' => 'updated notice is-dismissible'
					],
					noorgfx_html_tag(
						'p',
						[],
						blc_safe_sprintf(
							_n(
								'Disabled %s content block.',
								'Disabled %s content blocks.',
								$count,
								'noorgfx-component'
							),
							$count
						)
					)
				);
			}

		});

		add_action(
			'restrict_manage_posts',
			function () {
				if (
					! isset($_GET['post_type'])
					||
					$_GET['post_type'] !== 'ct_content_block'
				) {
					return;
				}

				$values = [
					__('Custom Content/Hooks', 'noorgfx-component') => 'hook',
					__('Popup', 'noorgfx-component') => 'popup',
					__('404 Page', 'noorgfx-component') => '404',
					__('Header', 'noorgfx-component') => 'header',
					__('Footer', 'noorgfx-component') => 'footer',
					__('Archive', 'noorgfx-component') => 'archive',
					__('Single', 'noorgfx-component') => 'single',
					__('Nothing Found', 'noorgfx-component') => 'nothing_found',
					__('Maintenance', 'noorgfx-component') => 'maintenance',
				];

				echo '<select name="block_type">';

				echo '<option value="">' . __('All types', 'noorgfx-component') . '</option>';

				$current_v = isset($_GET['block_type']) ? $_GET['block_type'] : '';

				foreach ($values as $label => $value) {
					if ($value === '404') {
						echo '<optgroup label="Templates">';
					}

					printf(
						'<option value="%s"%s>%s</option>',
						$value,
						$value === $current_v ? ' selected="selected"' : '',
						$label
					);

					if ($value === 'single') {
						echo '</optgroup>';
					}
				}

				echo '</select>';
			}
		);

		add_action('pre_get_posts', function ($query) {
			if (
				! is_admin()
				||
				! $query->is_main_query()
				||
				! isset($query->query['post_type'])
				||
				$query->query['post_type'] !== 'ct_content_block'
				||
				! isset($_REQUEST['block_type'])
			) {
				return $query;
			}

			$screen = get_current_screen();

			if ($screen->id !== 'edit-ct_content_block' ) {
				return $query;
			}

			$slug = sanitize_text_field($_REQUEST['block_type']);

			if ($slug === 'all') {
				return $query;
			}

			if (empty($slug)) {
				return $query;
			}

			$query->query_vars['meta_query'] = [
				[
					'key' => 'template_type',
					'value' => $slug
				]
			];

			return $query;
		});

		add_filter('manage_ct_content_block_posts_columns', function ($columns) {
			$columns['template_type'] = __('Type', 'noorgfx-component');
			$columns['location'] = __('Location/Trigger', 'noorgfx-component');
			$columns['conditions'] = __('Conditions', 'noorgfx-component');
			$columns['shortcode'] = __('Output', 'noorgfx-component');
			$columns['actions'] = __('Enable/Disable', 'noorgfx-component');

			return $columns;
		});

		add_action(
			'manage_ct_content_block_posts_custom_column',
			function ($column, $post_id) {
				$template_type = get_post_meta($post_id, 'template_type', '');

				if (is_array($template_type) && isset($template_type[0])) {
					$template_type = $template_type[0];
				}

				$atts = noorgfx_get_post_options($post_id);

				if ($column === 'location') {
					if ($template_type === 'popup') {
						$popup_trigger_condition = noorgfx_akg(
							'popup_trigger_condition',
							$atts,
							'default'
						);

						$humanized_triggers = [
							'default' => __('None', 'noorgfx-component'),
							'scroll' => __('On scroll', 'noorgfx-component'),
							'element_reveal' => __('On scroll to element', 'noorgfx-component'),
							'element_click' => __('On click to element', 'noorgfx-component'),
							'page_load' => __('On page load', 'noorgfx-component'),
							'after_inactivity' => __('After inactivity', 'noorgfx-component'),
							'after_x_time' => __('After x time', 'noorgfx-component'),
							'after_x_pages' => __('After x pages', 'noorgfx-component'),
							'exit_intent' => __('On page exit intent', 'noorgfx-component'),
						];

						$humanized_direction = [
							'down' => __('Down', 'noorgfx-component'),
							'up' => __('Up', 'noorgfx-component')
						];

						$once_text = '';

						if (
							$popup_trigger_condition !== 'default'
							&&
							noorgfx_akg('popup_trigger_once', $atts, 'no') === 'yes'
						) {
							$once_text = ', once';
						}

						if (isset($humanized_triggers[$popup_trigger_condition])) {
							echo $humanized_triggers[$popup_trigger_condition];

							if ($popup_trigger_condition === 'element_reveal') {
								$scroll_to_element = noorgfx_akg(
									'scroll_to_element',
									$atts,
									''
								);

								if (! empty($scroll_to_element)) {
									echo ' (' . $scroll_to_element . $once_text . ')';
								}
							}

							if ($popup_trigger_condition === 'element_click') {
								$click_to_element = noorgfx_akg(
									'click_to_element',
									$atts,
									''
								);

								if (! empty($click_to_element)) {
									echo ' (' . $click_to_element . $once_text . ')';
								}
							}

							if (
								$popup_trigger_condition === 'page_load'
								||
								$popup_trigger_condition === 'exit_intent'
							) {
								if (! empty($once_text)) {
									echo ' (' . trim(str_replace(',', '', $once_text)) . ')';
								}
							}

							if ($popup_trigger_condition === 'after_inactivity') {
								echo ' (' . noorgfx_akg(
									'inactivity_value',
									$atts,
									'10'
								) . 's' . $once_text . ')';
							}

							if ($popup_trigger_condition === 'after_x_time') {
								echo ' (' . noorgfx_akg(
									'x_time_value',
									$atts,
									'10'
								) . 's' . $once_text . ')';
							}

							if ($popup_trigger_condition === 'after_x_pages') {
								echo ' (' . noorgfx_akg(
									'x_pages_value',
									$atts,
									'3'
								) . $once_text . ')';
							}

							if ($popup_trigger_condition === 'scroll') {
								echo ' (' . $humanized_direction[noorgfx_akg(
									'scroll_direction',
									$atts,
									'down'
								)] . ' ' . noorgfx_akg(
									'scroll_value',
									$atts,
									'200px'
								) . $once_text . ')';
							}
						}
					}

					if ($template_type === 'hook') {
						$locations = array_merge([
							[
								'location' => noorgfx_default_akg('location', $atts, ''),
								'priority' => noorgfx_default_akg('priority', $atts, '10'),
								'custom_location' => noorgfx_default_akg('custom_location', $atts, ''),
								'paragraphs_count' => noorgfx_default_akg('paragraphs_count', $atts, '5'),
								'headings_count' => noorgfx_default_akg('headings_count', $atts, '5'),
							]
						], noorgfx_default_akg('additional_locations', $atts, []));

						$hooks_manager = new HooksManager();

						echo implode(
							'<br>',
							$hooks_manager->humanize_locations($locations)
						);
					}
				}

				if ($column === 'conditions') {
					$default_conditions = [];

					if (
						$template_type === 'maintenance'
						||
						$template_type === 'nothing_found'
					) {
						$default_conditions = [
							[
								'type' => 'include',
								'rule' => 'everywhere',
							]
						];
					}

					$conditions = noorgfx_default_akg(
						'conditions',
						$atts,
						$default_conditions
					);

					$conditions_manager = new ConditionsManager();

					echo implode(
						'<br>',
						$conditions_manager->humanize_conditions($conditions)
					);
				}

				if ($column === 'shortcode') {
					if (is_array($template_type) && isset($template_type[0])) {
						$template_type = $template_type[0];
					}

					if ($template_type === 'hook' || $template_type === 'popup') {
						$shortcode_column_value = '[' . $this->shortcode . ' id="' . $post_id . '"]';

						if ($template_type === 'popup') {
							$shortcode_column_value = '#ct-popup-' . $post_id;
						}

						echo noorgfx_html_tag(
							'input',
							[
								'class' => 'noorgfx-shortcode',
								'type' => 'text',
								'readonly' => '',
								'onfocus' => 'this.select()',
								'value' => htmlspecialchars($shortcode_column_value)
							],
							false
						);
					}
				}

				if ($column === 'template_type') {
					$template_type = get_post_meta($post_id, 'template_type', '');

					if (is_array($template_type) && isset($template_type[0])) {
						echo str_replace('_', ' ', ucfirst($template_type[0]));
					}
				}

				if ($column === 'actions') {
					$switch_class = 'ct-content-block-switch ct-option-switch';

					$atts = noorgfx_get_post_options($post_id);

					if (noorgfx_akg('is_hook_enabled', $atts, 'yes') === 'yes') {
						$switch_class .= ' ct-active';
					}

					$attr = [
						'class' => $switch_class,
						'data-post-id' => $post_id
					];

					echo '<div ' . noorgfx_attr_to_html($attr) . '><span></div>';
				}
			}, 10, 2
		);

		add_action('wp_ajax_noorgfx_content_noorgfx_toggle', function () {
			$capability = blc_get_capabilities()->get_wp_capability_by(
				'custom_post_type',
				[
					'post_type' => $this->post_type
				]
			);

			if (! current_user_can($capability)) {
				wp_send_json_error();
			}

			if (! isset($_REQUEST['post_id'])) {
				wp_send_json_error();
			}

			if (! isset($_REQUEST['enabled'])) {
				wp_send_json_error();
			}

			$post_id = intval($_REQUEST['post_id']);
			$enabled = $_REQUEST['enabled'];

			if ($enabled !== 'yes' && $enabled !== 'no') {
				wp_send_json_error();
			}

			if (! $post_id) {
				wp_send_json_error();
			}

			$atts = noorgfx_get_post_options($post_id);
			$atts['is_hook_enabled'] = $enabled;
			update_post_meta($post_id, 'noorgfx_post_meta_options', $atts);

			wp_send_json_success([]);
		});

		add_action(
			'admin_bar_menu',
			function ($wp_admin_bar) {
				if (is_admin()) {
					return;
				}

				$capability = blc_get_capabilities()->get_wp_capability_by(
					'custom_post_type',
					[
						'post_type' => $this->post_type
					]
				);

				if (! current_user_can($capability)) {
					return;
				}

				if (! apply_filters(
					'noorgfx:content-blocks:has-actions-debugger',
					true
				)) {
					return;
				}

				if (! function_exists('is_woocommerce')) {
					$wp_admin_bar->add_menu([
						'title' => isset($_GET['noorgfx_preview_hooks']) ? (
							__('Hide Hooks', 'noorgfx-component')
						) : __('Show Hooks', 'noorgfx-component'),
						'id' => 'noorgfx_preview_hooks',
						'href' => isset($_GET['noorgfx_preview_hooks']) ? (
							remove_query_arg('noorgfx_preview_hooks')
						) : add_query_arg('noorgfx_preview_hooks', 'theme')
					]);

					return;
				}

				$wp_admin_bar->add_menu([
					'title' => __('Hooks Locations', 'noorgfx-component'),
					'id' => 'noorgfx_preview_hooks',
				]);

				$components = [];

				if (isset($_GET['noorgfx_preview_hooks'])) {
					$current_value = $_GET['noorgfx_preview_hooks'];

					if (! empty($current_value)) {
						$components = explode(':', $current_value);
					}
				}

				$theme_components = $components;
				$woo_components = $components;

				if (in_array('theme', $components)) {
					$theme_components = array_filter($theme_components, function ($el) {
						return $el !== 'theme';
					});
				} else {
					$theme_components[] = 'theme';
				}

				$theme_url = count($theme_components) > 0 ? add_query_arg(
					'noorgfx_preview_hooks',
					implode(':', $theme_components)
				) : remove_query_arg('noorgfx_preview_hooks');

				if (in_array('woo', $components)) {
					$woo_components = array_filter($woo_components, function ($el) {
						return $el !== 'woo';
					});
				} else {
					$woo_components[] = 'woo';
				}

				$woo_url = count($woo_components) > 0 ? add_query_arg(
					'noorgfx_preview_hooks',
					implode(':', $woo_components)
				) : remove_query_arg('noorgfx_preview_hooks');

				$wp_admin_bar->add_menu([
					'title' => in_array('theme', $components) ? (
						__('Hide Theme Hooks', 'noorgfx-component')
					) : __('Show Theme Hooks', 'noorgfx-component'),
					'parent' => 'noorgfx_preview_hooks',
					'id' => 'noorgfx_preview_hooks_theme',
					'href' => $theme_url
				]);

				$wp_admin_bar->add_menu([
					'title' => in_array('woo', $components) ? (
						__('Hide WooCommerce Hooks', 'noorgfx-component')
					) : __('Show WooCommerce Hooks', 'noorgfx-component'),
					'id' => 'noorgfx_preview_hooks_woo',
					'parent' => 'noorgfx_preview_hooks',
					'href' => $woo_url
				]);
			},
			2000
		);

		add_action('noorgfx:content-blocks:display-hooks', function () {
			$this->maybe_display_hooks_preview();
		});
	}

	public function maybe_display_hooks_preview() {
		if (
			! isset($_GET['noorgfx_preview_hooks'])
			&&
			(
				! wp_doing_ajax()
				||
				empty($_SERVER['HTTP_REFERER'])
				||
				strpos(
					$_SERVER['HTTP_REFERER'],
					'noorgfx_preview_hooks'
				) === false
			)
		) {
			return;
		}

		$hooks_manager = new HooksManager();

		$components = [];

		if (isset($_GET['noorgfx_preview_hooks'])) {
			$current_value = $_GET['noorgfx_preview_hooks'];

			if (strlen($current_value) > 0) {
				$components = explode(':', $current_value);
			}
		} else {
			if (! empty($_SERVER['HTTP_REFERER'])) {
				parse_str(
					parse_url($_SERVER['HTTP_REFERER'])['query'],
					$query_string
				);

				if (
					isset($query_string['noorgfx_preview_hooks'])
					&&
					strlen($query_string['noorgfx_preview_hooks']) > 0
				) {
					$components = explode(
						':',
						$query_string['noorgfx_preview_hooks']
					);
				}
			}
		}

		foreach ($hooks_manager->get_all_hooks() as $hook) {
			if (isset($hook['visual']) && ! $hook['visual']) {
				continue;
			}

			if ($hook['type'] !== 'action') {
				continue;
			}

			if (strpos($hook['group'], __('WooCommerce', 'noorgfx-component')) !== false) {
				if (! in_array('woo', $components)) {
					continue;
				}
			} else {
				if (! in_array('theme', $components)) {
					continue;
				}
			}

			$priority = 10;

			if (isset($hook['priority'])) {
				$priority = $hook['priority'];
			}

			add_action(
				$hook['hook'],
				function () use ($hook, $priority) {
					$class = 'noorgfx-hook-indicator';

					if (isset($hook['group']) && $hook['group'] === __('WooCommerce', 'noorgfx-component')) {
						$class .= ' noorgfx-woo-indicator';
					}

					if (! isset($hook['attr'])) {
						$hook['attr'] = ['class' => $class];
					} else {
						$old = $hook['attr'];
						$hook['attr'] = [];

						$hook['attr']['class'] = 'noorgfx-hook-indicator';

						$hook['attr'] = array_merge(
							$hook['attr'],
							$old
						);
					}

					echo '<div ' . noorgfx_attr_to_html($hook['attr']) . '>';
					echo $hook['hook'];
					echo '<span data-hook="' . $hook['hook'] . '::' . $priority . '"></span>';
					echo '</div>';
				},
				$priority
			);
		}

		if (function_exists('WC')) {
			add_filter(
				'woocommerce_add_to_cart_form_action',
				function ($url) use ($components) {
					return add_query_arg(
						'noorgfx_preview_hooks',
						implode(':', $components),
						$url
					);
				}
			);
		}
	}
}
