<?php

$all_pages = get_posts([
	'post_type' => 'page',
	'numberposts' => -1
]);

$pages_choices = [
	'' => __('Select a page', 'noorgfx-component')
];

foreach ($all_pages as $page) {
	$pages_choices[$page->ID] = $page->post_title;
}

$options = [
	'label' => __('Wishlist', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		'product_wishlist_display_for' => [
			'label' => __('Show Wishlist Page To', 'noorgfx-component'),
			'type' => 'ct-radio',
			'value' => 'logged_users',
			'view' => 'text',
			'design' => 'block',
			'choices' => [
				'logged_users' => __( 'Logged Users', 'noorgfx-component' ),
				'all_users' => __( 'All Users', 'noorgfx-component' ),
			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'product_wishlist_display_for' => 'all_users' ],
			'options' => [

				'woocommerce_wish_list_page' => [
					'label' => __('Wishlist Page', 'noorgfx-component'),
					'type' => 'ct-select',
					'value' => '',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'desc' => __('The page you select here will display the wish list for your logged out users.', 'noorgfx-component'),
					'choices' => noorgfx_ordered_keys($pages_choices)
				]

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-divider',
		],

		'has_variations_wishlist' => [
			'label' => __( 'Specific Product Variation ', 'noorgfx-component' ),
			'type' => 'ct-switch',
			'value' => 'no',
			'desc' => __( 'This option will allow you to add a speciffic product variation to wishlist.', 'noorgfx-component' ),
		],

		'wishlist_image_ratio' => [
			'label' => __('Image Ratio', 'noorgfx-component'),
			'type' => 'ct-ratio',
			'view' => 'inline',
			'value' => '1/1',
			'divider' => 'top:full'
		],

		'wishlist_image_size' => [
			'label' => __('Image Size', 'noorgfx-component'),
			'type' => 'ct-select',
			'value' => 'woocommerce_thumbnail',
			'view' => 'text',
			'design' => 'inline',
			'divider' => 'top',
			'choices' => noorgfx_ordered_keys(
				noorgfx_get_all_image_sizes()
			),
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'product_wishlist_display_for' => 'all_users',
				'woocommerce_wish_list_page:truthy' => 'yes'
			],
			'options' => [
				noorgfx_get_options('single-elements/post-share-box', [
					'display_style' => 'switch',
					'prefix' => 'wish_list',
					'sync_prefix' => 'single_page',
					'has_share_box_type' => false,
					'has_share_box_location1' => false,
					'has_bottom_share_box_spacing' => false,
					'has_share_items_border' => false,
					'has_forced_icons_spacing' => true
				])
			],
		],

	],
];
