<?php

$options = [
	'label' => __('Stock Scarcity', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'product_stock_scarcity_min' => [
					'label' => __('Stock Threshold', 'noorgfx-component'),
					'type' => 'ct-number',
					'min' => 0,
					'value' => 50,
					'design' => 'inline',
					'sync' => [
						'id' => 'woo_single_layout_skip',
					],
					'desc' => __('Show the stock scarcity module when product stock is below this number.', 'noorgfx-component'),
				],

				'product_stock_scarcity_title' => [
					'label' => __( 'Message', 'noorgfx-component' ),
					'type' => 'wp-editor',
					'value' => __('🚨 Hurry up! Only {items} units left in stock!', 'noorgfx-component'),
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'quicktags' => false,
					'mediaButtons' => false,
					'tinymce' => [
						'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
					],
					'sync' => [
						'id' => 'woo_single_layout_skip',
					],
				],

				'stock_scarcity_bar_height' => [
					'label' => __( 'Bar Height', 'noorgfx-component' ),
					'type' => 'ct-slider',
					'min' => 1,
					'max' => 20,
					'value' => 5,
					'responsive' => true,
					'divider' => 'top:full',
					'setting' => [ 'transport' => 'postMessage' ],
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'stock_scarcity_bar_color' => [
					'label' => __( 'Bar Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'active' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'active_2' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-border-color)'
						],

						[
							'title' => __( 'Active', 'noorgfx-component' ),
							'id' => 'active',
							'inherit' => 'var(--theme-palette-color-1)'
						],

						[
							'title' => __( 'Active', 'noorgfx-component' ),
							'id' => 'active_2',
							'inherit' => 'self:active'
						],
					],
				],

			],
		],
		
	],
];