<?php

$options = [
	'label' => __('Free Shipping Bar', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'woo_shipping_progress_in_cart' => [
					'label' => __( 'Show In Cart Page', 'noorgfx-component' ),
					'type' => 'ct-switch',
					'value' => 'no',
				],

				'woo_shipping_progress_in_checkout' => [
					'label' => __( 'Show In Checkout Page', 'noorgfx-component' ),
					'type' => 'ct-switch',
					'value' => 'no',
				],

				'woo_shipping_progress_in_mini_cart' => [
					'label' => __( 'Show In Mini Cart', 'noorgfx-component' ),
					'type' => 'ct-switch',
					'value' => 'no',

				],

				'woo_count_method' => [
					'label' => __('Calculation Method', 'noorgfx-component'),
					'type' => 'ct-radio',
					'value' => 'custom',
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'choices' => [
						'custom' => __('Custom', 'noorgfx-component'),
						'woo' => __('WooCommerce', 'noorgfx-component'),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woo_count_method' => 'custom' ],
					'options' => [

						'woo_custom_count_criteria' => [
							'label' => __('Count Criteria', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'price',
							'view' => 'text',
							'design' => 'block',
							// 'divider' => 'top',
							'choices' => [
								'price' => __('Price', 'noorgfx-component'),
								'items' => __('Items', 'noorgfx-component'),
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_custom_count_criteria' => 'price' ],
							'options' => [
								'woo_count_progress_amount' => [
									'label' => __('Goal Amount', 'noorgfx-component'),
									'type' => 'ct-number',
									'design' => 'inline',
									'value' => 100,
									'blockDecimal' => false,
									'decimalPlaces' => 2,
									'min' => 1,
									'desc' => __('Amount the client has to reach in order to get free shipping.', 'noorgfx-component'),
								],
							]
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_custom_count_criteria' => 'items' ],
							'options' => [
								'woo_count_progress_items' => [
									'label' => __('Goal Items', 'noorgfx-component'),
									'type' => 'ct-number',
									'design' => 'inline',
									'value' => 2,
									'desc' => __('Amount of items the client has to buy in order to get free shipping.', 'noorgfx-component'),
								],
							]
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woo_count_method' => 'woo' ],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-notification',
							'attr' => [ 'data-type' => 'option-description' ],
							'text' => __( 'The calculation method will be based on WooCommerce zones.', 'noorgfx-component' ),
						],
					]
				],

				'woo_shipping_count_non_physical' => [
					'label' => __('Count Non-Physical Products', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'divider' => 'top:full',
					'desc' => __('Include or exclude virtual and downloadable products in calculating the shipping progress.', 'noorgfx-component'),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'woo_count_method' => 'woo',
							'woo_custom_count_criteria' => 'price'
						]
					],
					'options' => [

						'woo_count_with_discount' => [
							'label' => __('Discount Calculation', 'noorgfx-component'),
							'type' => 'ct-switch',
							'value' => 'yes',
							'divider' => 'top',
							'desc' => __('Include or exclude the discount code when calculating the shipping progress.', 'noorgfx-component'),
						],
						
						'free_not_enought_message' => [
							'label' => __( 'Default Message', 'noorgfx-component' ),
							'type' => 'wp-editor',
							'value' => __('Add {price} more to get free shipping!', 'noorgfx-component'),
							'setting' => [ 'transport' => 'postMessage' ],
							'quicktags' => false,
							'mediaButtons' => false,
							'divider' => 'top:full',
							'tinymce' => [
								'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
							],
							'desc' => __( 'You can use dynamic code tags such as {price} inside this option.', 'noorgfx-component' ),
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'all' => [
							'woo_count_method' => 'custom',
							'woo_custom_count_criteria' => 'items'
						]
					],
					'options' => [
						'free_not_enought_items_message' => [
							'label' => __( 'Default Message', 'noorgfx-component' ),
							'type' => 'wp-editor',
							'value' => __('Add {items} more items to get free shipping!', 'noorgfx-component'),
							'setting' => [ 'transport' => 'postMessage' ],
							'quicktags' => false,
							'mediaButtons' => false,
							'divider' => 'top:full',
							'tinymce' => [
								'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
							],
							'desc' => __( 'You can use dynamic code tags such as {items} inside this option.', 'noorgfx-component' ),
						],
					]
				],

				'free_enought_message' => [
					'label' => __( 'Success Message', 'noorgfx-component' ),
					'type' => 'wp-editor',
					'value' => __('Congratulations! You got free shipping 🎉', 'noorgfx-component'),
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'quicktags' => false,
					'mediaButtons' => false,
					'tinymce' => [
						'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
					],
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'shipping_progress_bar_color' => [
					'label' => __( 'Bar Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'active' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'active_2' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-border-color)'
						],

						[
							'title' => __( 'Active', 'noorgfx-component' ),
							'id' => 'active',
							'inherit' => 'var(--theme-palette-color-1)'
						],

						[
							'title' => __( 'Active', 'noorgfx-component' ),
							'id' => 'active_2',
							'inherit' => 'self:active'
						],
					],
				],

			],
		],
		
	],
];