<?php


$quick_view_additional_actions = apply_filters(
	'noorgfx_quick_view_options:after',
	[
		// ['id' => '...', 'label' => '...']
	]
);

$quick_view_additional_actions_options_before = [];
$quick_view_additional_actions_options_after = [];

if (! empty($quick_view_additional_actions)) {
	$quick_view_additional_actions_options_before = [
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			// 'variation' => 'simple',
			'label' => __( 'Additional Actions', 'noorgfx-component' ),
		],
	];

	$quick_view_additional_actions_options_after = [
		'quick_view_additional_actions_type' => [
			'label' => __('Buttons Type', 'noorgfx-component'),
			'type' => 'ct-radio',
			'value' => 'link',
			'view' => 'text',
			'design' => 'block',
			'divider' => 'top',
			'choices' => [
				'link' => __('Link', 'noorgfx-component'),
				'button' => __('Button', 'noorgfx-component'),
			]
		],

		'has_quick_view_label_visibility' => [
			'label' => __('Label Visibility', 'noorgfx-component'),
			'type' => 'ct-visibility',
			'design' => 'block',
			'allow_empty' => true,
			'value' => noorgfx_default_responsive_value([
				'desktop' => true,
				'tablet' => true,
				'mobile' => true,
			]),

			'choices' => noorgfx_ordered_keys([
				'desktop' => __('Desktop', 'noorgfx-component'),
				'tablet' => __('Tablet', 'noorgfx-component'),
				'mobile' => __('Mobile', 'noorgfx-component'),
			]),
		],
	];
}

$options = [
	'label' => __( 'Quick View', 'noorgfx-component' ),
	'type' => 'ct-panel',
	'value' => 'no',
	'sync' => noorgfx_sync_whole_page([
		'loader_selector' => '.woo-listing-top, #woo-filters-panel' // Replace
	]),
	'inner-options' => [
		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				[
					'woocommerce_quick_view_trigger' => [
						'label' => __( 'Modal Trigger', 'noorgfx-component' ),
						'type' => 'ct-radio',
						'value' => 'button',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'button' => __( 'Button', 'noorgfx-component' ),
							'image' => __( 'Image', 'noorgfx-component' ),
							'card' => __( 'Card', 'noorgfx-component' ),
						],

						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '[data-products] > li'
						]),
					],

					'woocommerce_quick_view_width' => [
						'label' => __( 'Modal Width', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'min' => 500,
						'max' => 1500,
						'value' => 1050,
						'responsive' => true,
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'woocommerce_quickview_navigation' => [
						'label' => __( 'Product Navigation', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'bottom:full',
						'setting' => [ 'transport' => 'postMessage' ],
						'sync' => 'live',
						'desc' => __( 'Display next/previous buttons that will help to easily navigate through products.', 'noorgfx-component' ),
					],

					'woocommerce_quickview_gallery_ratio' => [
						'label' => __('Image Ratio', 'noorgfx-component'),
						'type' => 'ct-ratio',
						'view' => 'inline',
						'value' => '3/4',
						// 'divider' => 'bottom:full',
						'sync' => 'live'
					],
				],

				$quick_view_additional_actions_options_before,

				apply_filters(
					'noorgfx_quick_view_options:after',
					[]
				),

				$quick_view_additional_actions_options_after
			]
		],
		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'quickViewProductTitleFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Title Font', 'noorgfx-component' ),
					'value' => noorgfx_typography_default_values([
						// 'size' => '30px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'quick_view_title_color' => [
					'label' => __( 'Title Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'bottom:full',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-heading-1-color, var(--theme-headings-color))'
						],
					],
				],

				'quickViewProductPriceFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Price Font', 'noorgfx-component' ),
					'value' => noorgfx_typography_default_values([
						// 'size' => '30px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'quick_view_price_color' => [
					'label' => __( 'Price Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'bottom:full',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],
					],
				],

				'quick_view_description_color' => [
					'label' => __( 'Description Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],
					],
				],


				noorgfx_rand_md5() => [
					'type' => 'ct-title',
					'label' => __('Add To Cart Button', 'noorgfx-component'),
				],

				'quick_view_add_to_cart_text' => [
					'label' => __('Button Font Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
							'inherit' => 'var(--theme-button-text-initial-color)',
						],

						[
							'title' => __('Hover', 'noorgfx-component'),
							'id' => 'hover',
							'inherit' => 'var(--theme-button-text-hover-color)',
						],
					],
				],

				'quick_view_add_to_cart_background' => [
					'label' => __('Button Background Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
							'inherit' => 'var(--theme-button-background-initial-color)'
						],

						[
							'title' => __('Hover', 'noorgfx-component'),
							'id' => 'hover',
							'inherit' => 'var(--theme-button-background-hover-color)'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'values_source' => 'global',
					'condition' => ['has_ajax_add_to_cart' => 'yes'],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'variation' => 'small-divider',
							'label' => __('View Cart Button', 'noorgfx-component'),
						],

						'quick_view_view_cart_button_text' => [
							'label' => __('Button Font Color', 'noorgfx-component'),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __('Initial', 'noorgfx-component'),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)',
								],

								[
									'title' => __('Hover', 'noorgfx-component'),
									'id' => 'hover',
									'inherit' => 'var(--theme-text-color)',
								],
							],
						],

						'quick_view_view_cart_button_background' => [
							'label' => __('Button Background Color', 'noorgfx-component'),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __('Initial', 'noorgfx-component'),
									'id' => 'default',
									'inherit' => 'rgba(224,229,235,0.6)'
								],

								[
									'title' => __('Hover', 'noorgfx-component'),
									'id' => 'hover',
									'inherit' => 'rgba(224,229,235,1)'
								],
							],
						],

					],
				],


				noorgfx_rand_md5() => [
					'type' => 'ct-title',
					'variation' => 'small-divider',
					'label' => __('Product Page Button', 'noorgfx-component'),
				],

				'quick_view_product_page_button_text' => [
					'label' => __('Button Font Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',
					'value' => [
						'default' => [
							'color' => 'var(--theme-text-color)',
						],

						'hover' => [
							'color' => 'var(--theme-text-color)',
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
						],

						[
							'title' => __('Hover', 'noorgfx-component'),
							'id' => 'hover',
						],
					],
				],

				'quick_view_product_page_button_background' => [
					'label' => __('Button Background Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',
					'value' => [
						'default' => [
							'color' => 'rgba(224,229,235,0.6)',
						],

						'hover' => [
							'color' => 'rgba(224,229,235,1)',
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
						],

						[
							'title' => __('Hover', 'noorgfx-component'),
							'id' => 'hover',
						],
					],
				],


				'quick_view_background' => [
					'label' => __( 'Modal Background', 'noorgfx-component' ),
					'type'  => 'ct-background',
					'design' => 'inline',
					'divider' => 'top:full',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)'
							],
						],
					])
				],

				'quick_view_backdrop' => [
					'label' => __( 'Modal Backdrop', 'noorgfx-component' ),
					'type'  => 'ct-background',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'rgba(18, 21, 25, 0.8)'
							],
						],
					])
				],

				'quick_view_shadow' => [
					'label' => __( 'Modal Shadow', 'noorgfx-component' ),
					'type' => 'ct-box-shadow',
					'design' => 'inline',
					'sync' => 'live',
					'value' => noorgfx_box_shadow_value([
						'enable' => true,
						'h_offset' => 0,
						'v_offset' => 50,
						'blur' => 100,
						'spread' => 0,
						'inset' => false,
						'color' => [
							'color' => 'rgba(18, 21, 25, 0.5)',
						],
					])
				],

				'quick_view_radius' => [
					'label' => __( 'Modal Border Radius', 'noorgfx-component' ),
					'type' => 'ct-spacing',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_spacing_value(),
					'inputAttr' => [
						'placeholder' => '7'
					],
					'min' => 0,
				],
			]
		]
	]
];
