<?php

if (! $entry->product_id) {
	return;
}

$product = wc_get_product($entry->product_id);

$status = $product->get_status();

if (
	$status === 'trash'
	||
	(
		$status === 'private'
		&&
		! current_user_can('read_private_products')
	)
) {
	return;
}

$columns = [];


$columns[] = noorgfx_html_tag(
	'td',
	[
		'class' => 'waitlist-product-thumbnail'
	],
	noorgfx_render_view(
		dirname(__FILE__) . '/product-thumbnail.php',
		[
			'product' => $product,
		]
	)
);

$columns[] = noorgfx_html_tag(
	'td',
	[
		'class' => 'waitlist-product-name'
	],
	noorgfx_render_view(
		dirname(__FILE__) . '/product-name.php',
		[
			'product' => $product,
		]
	)
);

$columns[] = noorgfx_html_tag(
	'td',
	[
		'class' => 'waitlist-product-status'
	],
	__('Out of Stock', 'noorgfx-component')
);

$columns[] = noorgfx_html_tag(
	'td',
	[
		'class' => 'waitlist-subscription-status'
	],
	$entry->confirmed ? __('Yes', 'noorgfx-component') : __('No', 'noorgfx-component')
);

$columns[] = noorgfx_html_tag(
	'td',
	[
		'class' => 'waitlist-product-actions'
	],
	noorgfx_html_tag(
		'div',
		[

		],
		noorgfx_html_tag(
			'button',
			[
				'class' => 'button unsubscribe',
				'type' => 'submit',
				'data-token' => $entry->unsubscribe_token,
				'data-id' => $entry->subscription_id,
			],
			__('Unsubscribe', 'noorgfx-component')
		)
	)
);

echo noorgfx_html_tag(
	'tr',
	[
		'class' => 'ct-woocommerce-waitlist-table-row',
	],

	implode('', $columns)
);