<?php

$container_max_width = blc_theme_functions()->noorgfx_get_theme_mod('waitlist_container_max_width', 100);

if ($container_max_width !== 100) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.ct-product-waitlist',
		'variableName' => 'container-max-width',
		'value' => $container_max_width,
		'unit' => '%'
	]);
}

noorgfx_output_font_css([
	'font_value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'waitlist_title_font',
		noorgfx_typography_default_values([
			'size' => '16px',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-waitlist-title'
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('waitlist_title_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-waitlist-title',
			'variable' => 'theme-heading-color'
		],
	],
]);

noorgfx_output_font_css([
	'font_value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'waitlist_message_font',
		noorgfx_typography_default_values([
			'size' => '15px',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-waitlist-message'
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('waitlist_message_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-product-waitlist p',
			'variable' => 'theme-text-color'
		],
	],
]);

noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-product-waitlist',
	'variableName' => 'container-border',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('waitlist_form_border'),
	'skip_none' => true,
	'default' => [
		'width' => 2,
		'style' => 'solid',
		'color' => [
			'color' => 'var(--theme-border-color)',
		],
	],
	'responsive' => true,
]);

noorgfx_output_background_css([
	'selector' => '.ct-product-waitlist',
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'waitlist_form_background',
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
				],
			],
		])
	),
	'responsive' => true,
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-product-waitlist',
	'property' => 'container-padding',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'waitlist_form_padding',
		noorgfx_spacing_value()
	),
	'empty_value' => 30
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-product-waitlist',
	'property' => 'container-border-radius',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'waitlist_form_border_radius',
		noorgfx_spacing_value()
	),
	'empty_value' => 7
]);