<?php

$options = [
	'label' => __( 'Filters Canvas', 'noorgfx-component' ),
	'type' => 'ct-panel',
	'switch' => true,
	'value' => 'no',
	'sync' => [
		[
			'id' => 'shortcuts_container_layers'
		],

		noorgfx_sync_whole_page([
			'loader_selector' => '.woo-listing-top, #woo-filters-panel'
		])
	],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'woocommerce_filter_type' => [
					'label' => false,
					'type' => 'ct-image-picker',
					'value' => 'type-1',
					'choices' => [
						'type-1' => [
							'src' => noorgfx_image_picker_url('woo-filters-type-1.svg'),
							'title' => __('Type 1', 'noorgfx-component'),
						],

						'type-2' => [
							'src' => noorgfx_image_picker_url('woo-filters-type-2.svg'),
							'title' => __('Type 2', 'noorgfx-component'),
						],
					],
				],

				'woocommerce_filter_icon_type' => [
					'label' => __( 'Trigger Icon Type', 'noorgfx-component' ),
					'type' => 'ct-image-picker',
					'value' => 'type-1',
					'divider' => 'top:full',
					'attr' => [
						'data-type' => 'background',
						'data-columns' => '4',
					],
					'sync' => noorgfx_sync_whole_page([
						'loader_selector' => '.ct-toggle-filter-panel'
					]),
					'choices' => [
						'type-1' => [
							'src'   => noorgfx_image_picker_file( 'filter-1' ),
							'title' => __( 'Type 1', 'noorgfx-component' ),
						],

						'type-2' => [
							'src'   => noorgfx_image_picker_file( 'filter-2' ),
							'title' => __( 'Type 2', 'noorgfx-component' ),
						],

						'type-3' => [
							'src'   => noorgfx_image_picker_file( 'filter-3' ),
							'title' => __( 'Type 3', 'noorgfx-component' ),
						],

						'type-4' => [
							'src'   => noorgfx_image_picker_file( 'filter-4' ),
							'title' => __( 'Type 4', 'noorgfx-component' ),
						],
					],
				],

				'woocommerce_filter_visibility' => [
					'label' => __( 'Trigger Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'divider' => 'top',
					'allow_empty' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'woocommerce_filter_visibility/desktop' => true,
							'woocommerce_filter_visibility/tablet' => true,
							'woocommerce_filter_visibility/mobile' => true,
						]
					],
					'options' => [
						'woocommerce_filter_label' => [
							'label' => __( 'Trigger Label', 'noorgfx-component' ),
							'type' => 'text',
							'divider' => 'top',
							'design' => 'block',
							'value' => __( 'Filter', 'noorgfx-component' ),
							'sync' => 'live',
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woocommerce_filter_type' => 'type-1' ],
					'options' => [

						'filter_panel_position' => [
							'label' => __('Panel Reveal', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'right',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top:full',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'left' => __( 'Left Side', 'noorgfx-component' ),
								'right' => __( 'Right Side', 'noorgfx-component' ),
							],
						],

						'filter_panel_width' => [
							'label' => __( 'Panel Width', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'value' => [
								'desktop' => '500px',
								'tablet' => '65vw',
								'mobile' => '90vw',
							],
							'units' => noorgfx_units_config([
								[ 'unit' => 'px', 'min' => 0, 'max' => 1000 ],
							]),
							'divider' => 'top',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'filter_panel_content_vertical_alignment' => [
							'type' => 'ct-radio',
							'label' => __( 'Vertical Alignment', 'noorgfx-component' ),
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'attr' => [ 'data-type' => 'vertical-alignment' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => 'flex-start',
							'choices' => [
								'flex-start' => '',
								'center' => '',
								'flex-end' => '',
							],
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woocommerce_filter_type' => 'type-2' ],
					'options' => [

						'filter_panel_height_type' => [
							'label' => __('Panel Height', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'auto',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top:full',
							'sync' => noorgfx_sync_whole_page([
								'loader_selector' => '#woo-filters-panel'
							]),
							'choices' => [
								'auto' => __( 'Auto', 'noorgfx-component' ),
								'custom' => __( 'Custom', 'noorgfx-component' ),
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'filter_panel_height_type' => 'custom' ],
							'options' => [

								'filter_panel_height' => [
									'label' => __( 'Custom Height', 'noorgfx-component' ),
									'type' => 'ct-slider',
									'value' => [
										'desktop' => '250px',
										'tablet' => '250px',
										'mobile' => '250px',
									],
									'units' => noorgfx_units_config([
										[ 'unit' => 'px', 'min' => 0, 'max' => 1000 ],
									]),
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],
						],

						'filter_panel_columns' => [
							'label' => __('Panel Columns', 'noorgfx-component'),
							'type' => 'ct-number',
							'value' => [
								'desktop' => 4,
								'tablet' => 2,
								'mobile' => 1
							],
							'min' => 1,
							'max' => 6,
							'design' => 'block',
							'divider' => 'top',
							'attr' => ['data-position' => 'right'],
							'sync' => 'live',
							'responsive' => true,
						],

						'filter_panel_behaviour' => [
							'label' => __('Panel Default State', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'no',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'choices' => [
								'no' => __( 'Closed', 'noorgfx-component' ),
								'yes' => __( 'Opened', 'noorgfx-component' ),
							],
							'sync' => noorgfx_sync_whole_page([
								'loader_selector' => '.woo-listing-top, #woo-filters-panel'
							]),
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'filter_panel_behaviour' => 'yes' ],
							'options' => [

								'filter_panel_visibility' => [
									'label' => __( 'Panel Visibility', 'noorgfx-component' ),
									'type' => 'ct-visibility',
									'design' => 'block',
									'divider' => 'top',
									'allow_empty' => true,
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => noorgfx_default_responsive_value([
										'desktop' => true,
										'tablet' => true,
										'mobile' => true,
									]),

									'choices' => noorgfx_ordered_keys([
										'desktop' => __( 'Desktop', 'noorgfx-component' ),
										'tablet' => __( 'Tablet', 'noorgfx-component' ),
										'mobile' => __( 'Mobile', 'noorgfx-component' ),
									]),
								],

							],
						],
					]
				],
			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woocommerce_filter_type' => 'type-1' ],
					'options' => [

						'filter_panel_background' => [
							'label' => __( 'Panel Background', 'noorgfx-component' ),
							'type'  => 'ct-background',
							'design' => 'block:right',
							'responsive' => true,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_background_default_value([
								'backgroundColor' => [
									'default' => [
										'color' => 'var(--theme-palette-color-8)'
									],
								],
							])
						],

						'filter_panel_backgrop' => [
							'label' => __( 'Panel Backdrop', 'noorgfx-component' ),
							'type'  => 'ct-background',
							'design' => 'block:right',
							'responsive' => true,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_background_default_value([
								'backgroundColor' => [
									'default' => [
										'color' => 'rgba(18, 21, 25, 0.6)'
									],
								],
							])
						],

						'filter_panel_shadow' => [
							'label' => __( 'Panel Shadow', 'noorgfx-component' ),
							'type' => 'ct-box-shadow',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'value' => noorgfx_box_shadow_value([
								'enable' => true,
								'h_offset' => 0,
								'v_offset' => 0,
								'blur' => 70,
								'spread' => 0,
								'inset' => false,
								'color' => [
									'color' => 'rgba(0, 0, 0, 0.35)',
								],
							])
						],

						'filter_panel_close_button_type' => [
							'label' => __('Close Button Type', 'noorgfx-component'),
							'type' => 'ct-select',
							'value' => 'type-1',
							'view' => 'text',
							'design' => 'inline',
							'divider' => 'top:full',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => noorgfx_ordered_keys(
								[
									'type-1' => __( 'Simple', 'noorgfx-component' ),
									'type-2' => __( 'Border', 'noorgfx-component' ),
									'type-3' => __( 'Background', 'noorgfx-component' ),
								]
							),
						],

						'filter_panel_close_button_color' => [
							'label' => __( 'Icon Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'rgba(0, 0, 0, 0.5)',
								],

								'hover' => [
									'color' => 'rgba(0, 0, 0, 0.8)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'filter_panel_close_button_type' => 'type-2' ],
							'options' => [

								'filter_panel_close_button_border_color' => [
									'label' => __( 'Border Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx-component' ),
											'id' => 'default',
											'inherit' => 'rgba(0, 0, 0, 0.5)'
										],

										[
											'title' => __( 'Hover', 'noorgfx-component' ),
											'id' => 'hover',
											'inherit' => 'rgba(0, 0, 0, 0.5)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'filter_panel_close_button_type' => 'type-3' ],
							'options' => [

								'filter_panel_close_button_shape_color' => [
									'label' => __( 'Background Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx-component' ),
											'id' => 'default',
											'inherit' => 'rgba(0, 0, 0, 0.5)'
										],

										[
											'title' => __( 'Hover', 'noorgfx-component' ),
											'id' => 'hover',
											'inherit' => 'rgba(0, 0, 0, 0.5)'
										],
									],
								],

							],
						],

						'filter_panel_close_button_icon_size' => [
							'label' => __( 'Icon Size', 'noorgfx-component' ),
							'type' => 'ct-number',
							'design' => 'inline',
							'value' => 12,
							'min' => 5,
							'max' => 50,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'filter_panel_close_button_type' => '!type-1' ],
							'options' => [

								'filter_panel_close_button_border_radius' => [
									'label' => __( 'Border Radius', 'noorgfx-component' ),
									'type' => 'ct-number',
									'design' => 'inline',
									'value' => 5,
									'min' => 0,
									'max' => 100,
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],
						],

					],
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'any' => [
					'woocommerce_filter_type' => 'type-1',
					'all' => [
						'woocommerce_filter_type' => 'type-2',
						'filter_panel_behaviour' => 'no',
					]
				]
			],
			'options' => [

				'filter_ajax_reveal' => [
					'label' => __('Panel AJAX Reveal', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'sync' => noorgfx_sync_whole_page([
						'loader_selector' => '#woo-filters-panel'
					]),
				],

			]
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'woocommerce_filter_type' => 'type-1' ],
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['woo_filters_ajax' => 'yes'],
					'values_source' => 'global',
					'options' => [

						'filter_panel_close_on_select' => [
							'label' => __('Auto Close Panel', 'noorgfx-component'),
							'desc' => __('Automatically close the panel when a filter option is selected.', 'noorgfx-component'),
							'type' => 'ct-switch',
							'value' => 'no',
							'divider' => 'top',
						],

					]
				]
				
			]
		],

		'filter_source' => [
			'label' => __('Widget Area Source', 'noorgfx-component'),
			'type' => 'ct-select',
			'value' => 'sidebar-woocommerce-offcanvas-filters',
			'view' => 'text',
			'design' => 'block',
			'divider' => 'top:full',
			'choices' => noorgfx_ordered_keys(
				[
					'sidebar-woocommerce' => __( 'WooCommerce Sidebar', 'noorgfx-component' ),
					'sidebar-woocommerce-offcanvas-filters' => __( 'WooCommerce Filters Canvas', 'noorgfx-component' ),
				]
			),
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Filter Widgets', 'noorgfx-component' ),
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Widgets', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'filter_source' => 'sidebar-woocommerce-offcanvas-filters' ],
					'options' => [

						'widget' => [
							'type' => 'ct-widget-area',
							'sidebarId' => 'sidebar-woocommerce-offcanvas-filters'
						]

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'filter_source' => 'sidebar-woocommerce' ],
					'options' => [

						'widget' => [
							'type' => 'ct-widget-area',
							'sidebarId' => 'sidebar-woocommerce'
						]

					],
				],

			]
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'woocommerce_filter_type' => 'type-1' ],
					'options' => [

						'panel_widgets_spacing' => [
							'label' => __( 'Widgets Vertical Spacing', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'min' => 0,
							'max' => 100,
							'value' => 60,
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

					],
				],

				'filter_panel_widgets_font' => [
					'type' => 'ct-typography',
					'label' => __( 'Widgets Font', 'noorgfx-component' ),
					'value' => noorgfx_typography_default_values([
						// 'size' => '16px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'filter_panel_widgets_font_color' => [
					'label' => __( 'Widgets Font Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'block:right',
					'responsive' => true,
					'divider' => 'bottom',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'link_initial' => [
							'color' => 'var(--theme-text-color)',
						],

						'link_hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Text Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],

						[
							'title' => __( 'Link Initial', 'noorgfx-component' ),
							'id' => 'link_initial',
						],

						[
							'title' => __( 'Link Hover', 'noorgfx-component' ),
							'id' => 'link_hover',
							'inherit' => 'var(--theme-link-hover-color)'
						],
					],
				],
			]
		],

	],
];

