<?php

$options = [
	'label' => __('Floating Cart', 'noorgfx-component'),
	'type' => 'ct-panel',
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'floating_bar_position' => [
					'type' => 'ct-radio',
					'label' => __( 'Position', 'noorgfx-component' ),
					'view' => 'text',
					'design' => 'block',
					'value' => 'top',
					'choices' => [
						'top' => __( 'Top', 'noorgfx-component' ),
						'bottom' => __( 'Bottom', 'noorgfx-component' ),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'floatingBarVisibility' => [
					'label' => __('Floating Cart Visibility', 'noorgfx-component'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'setting' => ['transport' => 'postMessage'],
					'divider' => 'bottom',
					'allow_empty' => true,
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

				'floatingBarImageVisibility' => [
					'label' => __('Product Image Visibility', 'noorgfx-component'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'setting' => ['transport' => 'postMessage'],
					'divider' => 'bottom',
					'allow_empty' => true,
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

				'floatingBarTitleVisibility' => [
					'label' => __('Product Title Visibility', 'noorgfx-component'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'setting' => ['transport' => 'postMessage'],
					'divider' => 'bottom',
					'allow_empty' => true,
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

				'floatingBarPriceStockVisibility' => [
					'label' => __('Product Price & Stock Visibility', 'noorgfx-component'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'setting' => ['transport' => 'postMessage'],
					'allow_empty' => true,
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'floatingBarFontColor' => [
					'label' => __( 'Font Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'block:right',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],
					],
				],

				'floatingBarBackground' => [
					'label' => __( 'Background Color', 'noorgfx-component' ),
					'type' => 'ct-background',
					'design' => 'block:right',
					'responsive' => true,
					'divider' => 'top',
					'sync' => 'live',
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)',
							],
						],
					])
				],

				'floatingBarShadow' => [
					'label' => __( 'Shadow', 'noorgfx-component' ),
					'type' => 'ct-box-shadow',
					'responsive' => true,
					'divider' => 'top',
					'value' => noorgfx_box_shadow_value([
						'enable' => true,
						'h_offset' => 0,
						'v_offset' => 10,
						'blur' => 20,
						'spread' => 0,
						'inset' => false,
						'color' => [
							'color' => 'rgba(44,62,80,0.15)',
						],
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

			],
		],

	],
];
