<?php

namespace Noorgfx\Extensions\WoocommerceExtra;

class PriceBlock {
	public function __construct() {
        add_action('init', [$this, 'noorgfx_price_filter_block']);

		add_filter('noorgfx:general:ct-scripts-localizations', function ($data) {
			$data['noorgfx_woo_extra_price_filters'] = [
				'currency' => html_entity_decode(get_woocommerce_currency_symbol()),
				'priceFormat' => html_entity_decode(get_woocommerce_price_format()),
				'delimiter' => wc_get_price_decimal_separator(),
				'thousand' => wc_get_price_thousand_separator(),
			];

			return $data;
		});

        add_filter('noorgfx:frontend:dynamic-js-chunks', function ($chunks) {
			if (!class_exists('WC_AJAX')) {
				return $chunks;
			}

            $chunks[] = [
				'id' => 'noorgfx_ext_woo_extra_price_filters',
				'selector' => '.ct-price-filter',
				'trigger' => [
					[
						'trigger' => 'change',
						'selector' => '.ct-price-filter-slider input[type="range"]',
					],

					[
						'trigger' => 'input',
						'selector' => '.ct-price-filter-slider input[type="range"]',
					],

					[
						'trigger' => 'click',
						'selector' => '.ct-price-filter-range-track',
					]
				],
				'url' => noorgfx_cdn_url(
					NOORGFX_URL .
						'framework/premium/extensions/woocommerce-extra/static/bundle/price-filter-public.js'
				),
			];

            return $chunks;
        });
    }

	public function noorgfx_price_filter_block() {
		register_block_type('noorgfx/woocommerce-price-filter', [
			'render_callback' => function ($attributes, $content, $block) {
				if (
					! is_woocommerce()
					&&
					! wp_doing_ajax()
					||
					is_singular()
				) {
					return '';
				}

				$attributes = wp_parse_args($attributes, [
					'showTooltips' => true,
					'showPrices' => true,
					'showResetButton' => false
				]);

				$filter = Filters::get_filter_instance('price_filter');

				$presenter = new FilterPresenter($filter);
				return $presenter->render($attributes);
			},
		]);
	}
}
