<?php

$initial_conditions = [
	[
		'type' => 'include',
		'rule' => 'everywhere'
	]
];

$layer_settings = [
	'home' => [
		'label' => __('Home', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-home'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Home', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	],

	'phone' => [
		'label' => __('Phone', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-phone'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Phone', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'phone_number' => [
				'type' => 'text',
				'value' => '#',
				'design' => 'inline',
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	],

	'email' => [
		'label' => __('Email', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-email'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Email', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'email' => [
				'type' => 'text',
				'value' => '#',
				'design' => 'inline',
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	],

	'scroll_top' => [
		'label' => __('Scroll Top', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-arrow-up-circle'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Scroll Top', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	],

	'custom_link' => [
		'label' => blc_safe_sprintf('<%%= label || "%s" %%>', __('Custom', 'noorgfx-component')),
		'clone' => 4,
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'far fa-smile'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Custom', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'link' => [
				'type' => 'text',
				'value' => '#',
				'design' => 'inline',
				'sync' => [
					'id' => 'shortcuts_container'
				],
			],

			'link_target' => [
				'type'  => 'ct-switch',
				'label' => __( 'Open link in new tab', 'noorgfx-component' ),
				'value' => 'no',
				'disableRevertButton' => true,
			],

			'link_nofollow' => [
				'type'  => 'ct-switch',
				'label' => __( 'Set link to nofollow', 'noorgfx-component' ),
				'value' => 'no',
			],

			'class' => [
				'type' => 'text',
				'label' => __( 'Custom class', 'noorgfx-component' ),
				'value' => '',
				'design' => 'inline',
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'sync' => [
					'id' => 'shortcuts_container'
				],

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	]
];

if (class_exists('WooCommerce')) {
	$layer_settings['cart'] = [
		'label' => __('Cart', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-cart'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Cart', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	];

	$layer_settings['shop'] = [
		'label' => __('Shop', 'noorgfx-component'),
		'options' => [
			'icon' => [
				'type' => 'icon-picker',
				'design' => 'inline',
				'value' => [
					'icon' => 'blc blc-shop'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'shortcuts_label_visibility/desktop' => true,
						'shortcuts_label_visibility/tablet' => true,
						'shortcuts_label_visibility/mobile' => true,
						'shortcuts_tooltip_visibility/desktop' => true,
						'shortcuts_tooltip_visibility/tablet' => true,
						'shortcuts_tooltip_visibility/mobile' => true,
					]
				],
				'values_source' => 'parent',
				'options' => [
					'label' => [
						'type' => 'text',
						'value' => __('Shop', 'noorgfx-component'),
						'design' => 'inline',
						'sync' => [
							'id' => 'shortcuts_container'
						],
					],
				],
			],

			'item_visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'sync' => [
					'id' => 'shortcuts_container'
				],

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	];

	$storage = new \Noorgfx\Extensions\WoocommerceExtra\Storage();
	$settings = $storage->get_settings();

	if (
		isset($settings['features']['filters']) &&
		$settings['features']['filters'] &&
		\Noorgfx\Plugin::instance()->extensions->get('woocommerce-extra')
	) {
		$layer_settings['filters_canvas'] = [
			'label' => __('Filters Canvas', 'noorgfx-component'),
			'condition' => [
				'has_woo_offcanvas_filter' => 'yes'
			],
			'values_source' => 'global',
			'options' => [
				'icon' => [
					'type' => 'icon-picker',
					'design' => 'inline',
					'value' => [
						'icon' => 'blc blc-filter'
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'shortcuts_label_visibility/desktop' => true,
							'shortcuts_label_visibility/tablet' => true,
							'shortcuts_label_visibility/mobile' => true,
							'shortcuts_tooltip_visibility/desktop' => true,
							'shortcuts_tooltip_visibility/tablet' => true,
							'shortcuts_tooltip_visibility/mobile' => true,
						]
					],
					'values_source' => 'parent',
					'options' => [
						'label' => [
							'type' => 'text',
							'value' => __('Filter', 'noorgfx-component'),
							'design' => 'inline',
							'sync' => [
								'id' => 'shortcuts_container'
							],
						],
					],
				],

				'item_visibility' => [
					'label' => __( 'Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => [
						'id' => 'shortcuts_container'
					],

					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],
			]
		];
	}

	if (
		isset($settings['features']['wishlist']) &&
		$settings['features']['wishlist'] &&
		\Noorgfx\Plugin::instance()->extensions->get('woocommerce-extra')
	) {
		$layer_settings['wishlist'] = [
			'label' => __('Wishlist', 'noorgfx-component'),
			'options' => [
				'icon' => [
					'type' => 'icon-picker',
					'design' => 'inline',
					'value' => [
						'icon' => 'blc blc-heart'
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'shortcuts_label_visibility/desktop' => true,
							'shortcuts_label_visibility/tablet' => true,
							'shortcuts_label_visibility/mobile' => true,
							'shortcuts_tooltip_visibility/desktop' => true,
							'shortcuts_tooltip_visibility/tablet' => true,
							'shortcuts_tooltip_visibility/mobile' => true,
						]
					],
					'values_source' => 'parent',
					'options' => [
						'label' => [
							'type' => 'text',
							'value' => __('Wishlist', 'noorgfx-component'),
							'design' => 'inline',
							'sync' => [
								'id' => 'shortcuts_container'
							],
						],
					],
				],

				'item_visibility' => [
					'label' => __( 'Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => [
						'id' => 'shortcuts_container'
					],

					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],
			]
		];
	}

	if (
		isset($settings['features']['product-waitlist']) &&
		$settings['features']['product-waitlist'] &&
		\Noorgfx\Plugin::instance()->extensions->get('woocommerce-extra')
	) {
		$layer_settings['waitlist'] = [
			'label' => __('Waitlist', 'noorgfx-component'),
			'options' => [
				'icon' => [
					'type' => 'icon-picker',
					'design' => 'inline',
					'value' => [
						'icon' => 'blc blc-file'
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'shortcuts_label_visibility/desktop' => true,
							'shortcuts_label_visibility/tablet' => true,
							'shortcuts_label_visibility/mobile' => true,
							'shortcuts_tooltip_visibility/desktop' => true,
							'shortcuts_tooltip_visibility/tablet' => true,
							'shortcuts_tooltip_visibility/mobile' => true,
						]
					],
					'values_source' => 'parent',
					'options' => [
						'label' => [
							'type' => 'text',
							'value' => __('Waitlist', 'noorgfx-component'),
							'design' => 'inline',
							'sync' => [
								'id' => 'shortcuts_container'
							],
						],
					],
				],

				'item_visibility' => [
					'label' => __( 'Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => [
						'id' => 'shortcuts_container'
					],

					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],
			]
		];
	}

	if (
		isset($settings['features']['compareview']) &&
		$settings['features']['compareview'] &&
		\Noorgfx\Plugin::instance()->extensions->get('woocommerce-extra')
	) {
		$layer_settings['compare'] = [
			'label' => __('Compare', 'noorgfx-component'),
			'options' => [
				'icon' => [
					'type' => 'icon-picker',
					'design' => 'inline',
					'value' => [
						'icon' => 'blc blc-compare'
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'shortcuts_label_visibility/desktop' => true,
							'shortcuts_label_visibility/tablet' => true,
							'shortcuts_label_visibility/mobile' => true,
							'shortcuts_tooltip_visibility/desktop' => true,
							'shortcuts_tooltip_visibility/tablet' => true,
							'shortcuts_tooltip_visibility/mobile' => true,
						]
					],
					'values_source' => 'parent',
					'options' => [
						'label' => [
							'type' => 'text',
							'value' => __('Compare', 'noorgfx-component'),
							'design' => 'inline',
							'sync' => [
								'id' => 'shortcuts_container'
							],
						],
					],
				],

				'item_visibility' => [
					'label' => __( 'Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => [
						'id' => 'shortcuts_container'
					],

					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],
			]
		];
	}

	$initial_conditions[] = [
			'type' => 'exclude',
			'rule' => 'page_ids',
			'payload' => [
				'post_id' => intval(get_option('woocommerce_cart_page_id'))
			]
	];

	$initial_conditions[] = [
		'type' => 'exclude',
		'rule' => 'page_ids',
		'payload' => [
			'post_id' => intval(get_option('woocommerce_checkout_page_id'))
		]
	];
}

$options = [
	//  translators: This is a brand name. Preferably to not be translated
	'title' => _x('Shortcuts Bar', 'Extension Brand Name', 'noorgfx-component'),
	'container' => [ 'priority' => 8 ],
	'options' => [

		'shortcuts_section_options' => [
			'type' => 'ct-options',
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [
						'shortcuts_bar_type' => [
							'label' => __('Type', 'noorgfx-component'),
							'type' => 'ct-image-picker',
							'value' => 'type-1',
							'design' => 'block',
							'sync' => 'live',
							'choices' => [
								'type-1' => [
									'src' => noorgfx_image_picker_url('shortcuts-type-1.svg'),
									'title' => __('Type 1', 'noorgfx-component'),
								],

								'type-2' => [
									'src' => noorgfx_image_picker_url('shortcuts-type-2.svg'),
									'title' => __('Type 2', 'noorgfx-component'),
								],
							],
						],

						'shortcuts_bar_items' => [
							'label' => __('Shortcuts', 'noorgfx-component' ),
							'type' => 'ct-layers',
							'value' => [
								[
									'id' => 'home',
									'enabled' => true,
									'label' => __('Home', 'noorgfx-component'),
									'icon' => [
										'icon' => 'blc blc-home'
									]
								],

								[
									'id' => 'phone',
									'enabled' => true,
									'label' => __('Phone', 'noorgfx-component'),
									'icon' => [
										'icon' => 'blc blc-phone'
									]
								]
							],

							'manageable' => true,
							'sync' => [
								[
									'id' => 'shortcuts_container_layers',
									'selector' => '.ct-shortcuts-bar',
									'render' => function () {
										echo noorgfx_render_view(
											dirname(__FILE__) . '/views/bar.php',
											[]
										);
									}
								],

								[
									'id' => 'shortcuts_container',
									'selector' => '.ct-shortcuts-bar',
									'loader_selector' => 'skip',
									'render' => function () {
										echo noorgfx_render_view(
											dirname(__FILE__) . '/views/bar.php',
											[]
										);
									}
								],
							],
							'settings' => $layer_settings
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						'shortcuts_label_visibility' => [
							'label' => __( 'Label Visibility', 'noorgfx-component' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'allow_empty' => true,
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_default_responsive_value([
								'desktop' => false,
								'tablet' => false,
								'mobile' => false,
							]),

							'sync' => [
								'selector' => '.ct-shortcuts-bar',
								'render' => function () {
									echo noorgfx_render_view(
										dirname(__FILE__) . '/views/bar.php',
										[]
									);
								}
							],

							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx-component' ),
								'tablet' => __( 'Tablet', 'noorgfx-component' ),
								'mobile' => __( 'Mobile', 'noorgfx-component' ),
							]),
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'any' => [
									'shortcuts_label_visibility/desktop' => true,
									'shortcuts_label_visibility/tablet' => true,
									'shortcuts_label_visibility/mobile' => true,
								]
							],
							'options' => [
								'shortcuts_label_position' => [
									'type' => 'ct-radio',
									'label' => __( 'Label Position', 'noorgfx-component' ),
									'value' => 'bottom',
									'view' => 'text',
									'divider' => 'top',
									'design' => 'block',
									'sync' => 'live',
									'choices' => [
										'left' => __( 'Left', 'noorgfx-component' ),
										'right' => __( 'Right', 'noorgfx-component' ),
										'bottom' => __( 'Bottom', 'noorgfx-component' ),
									],
								],
							],
						],

						'shortcuts_tooltip_visibility' => [
							'label' => __( 'Tooltip Visibility', 'noorgfx-component' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'allow_empty' => true,
							'divider' => 'top:full',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_default_responsive_value([
								'desktop' => false,
								'tablet' => false,
								'mobile' => false,
							]),

							'sync' => [
								'selector' => '.ct-shortcuts-bar',
								'render' => function () {
									echo noorgfx_render_view(
										dirname(__FILE__) . '/views/bar.php',
										[]
									);
								}
							],

							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx-component' ),
								'tablet' => __( 'Tablet', 'noorgfx-component' ),
								'mobile' => __( 'Mobile', 'noorgfx-component' ),
							]),
						],

						'shortcuts_icon_size' => [
							'label' => __( 'Icon Size', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'min' => 5,
							'max' => 50,
							'value' => 15,
							'responsive' => true,
							'divider' => 'top:full',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'shortcuts_container_height' => [
							'label' => __( 'Container Height', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'min' => 30,
							'max' => 150,
							'value' => 70,
							'divider' => 'top',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'shortcuts_bar_type' => 'type-2' ],
							'options' => [
								'shortcuts_container_width' => [
									'label' => __( 'Container Max Width', 'noorgfx-component' ),
									'type' => 'ct-slider',
									'value' => '100%',
									'divider' => 'top',
									'responsive' => true,
									'units' => noorgfx_units_config([
										[ 'unit' => '%', 'min' => 0, 'max' => 100 ],
										[ 'unit' => 'px', 'min' => 0, 'max' => 1500 ],
										[ 'unit' => 'pt', 'min' => 0, 'max' => 1500 ],
										[ 'unit' => 'em', 'min' => 0, 'max' => 200 ],
										[ 'unit' => 'rem', 'min' => 0, 'max' => 200 ],
										[ 'unit' => 'vw', 'min' => 0, 'max' => 100 ],
										[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
									]),
									'setting' => [ 'transport' => 'postMessage' ],
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						'shortcuts_interaction' => [
							'label' => __('Scroll Interaction', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'none',
							'view' => 'text',
							'choices' => [
								'none' => __('None', 'noorgfx-component'),
								'scroll' => __('Hide', 'noorgfx-component'),
							],

							'sync' => [
								'selector' => '.ct-shortcuts-bar',
								'render' => function () {
									echo noorgfx_render_view(
										dirname(__FILE__) . '/views/bar.php',
										[]
									);
								}
							],
						],

						'shortcuts_bar_visibility' => [
							'label' => __( 'Visibility', 'noorgfx-component' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'divider' => 'top',
							'sync' => 'live',


							'value' => noorgfx_default_responsive_value([
								'desktop' => true,
								'tablet' => true,
								'mobile' => true,
							]),

							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx-component' ),
								'tablet' => __( 'Tablet', 'noorgfx-component' ),
								'mobile' => __( 'Mobile', 'noorgfx-component' ),
							]),
						],

						'shortcuts_bar_conditions' => [
							'label' => __('Display Conditions', 'noorgfx-component'),
							'type' => 'noorgfx-display-condition',
							'divider' => 'top',
							'value' => $initial_conditions,
							'display' => 'modal',

							'modalTitle' => __('Shortcuts Bar Display Conditions', 'noorgfx-component'),
							'modalDescription' => __('Add one or more conditions to display the shortcuts bar.', 'noorgfx-component'),
							'design' => 'block',
							'sync' => 'live'
						],
					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'any' => [
									'shortcuts_label_visibility/desktop' => true,
									'shortcuts_label_visibility/tablet' => true,
									'shortcuts_label_visibility/mobile' => true,
								]
							],
							'options' => [
								'shortcuts_font' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx-component' ),
									'value' => noorgfx_typography_default_values([
										'size' => '12px',
										'variation' => 'n5',
										'text-transform' => 'uppercase',
									]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'shortcuts_font_color' => [
									'label' => __( 'Font Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'divider' => 'top',
									'responsive' => true,
									'sync' => 'live',
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx-component' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],

										[
											'title' => __( 'Hover', 'noorgfx-component' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-link-hover-color)'
										],
									],
								],
							],
						],

						'shortcuts_icon_color' => [
							'label' => __( 'Icons Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'block:right',
							'divider' => 'top',
							'responsive' => true,
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-palette-color-2)'
								],
							],
						],

						'shortcuts_item_color' => [
							'label' => __( 'Item Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'block:right',
							'divider' => 'top',
							'responsive' => true,
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'rgba(0, 0, 0, 0)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'rgba(0, 0, 0, 0.03)'
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'shortcuts_bar_items:array-ids:cart:enabled' => '!no'
							],
							'options' => class_exists('WooCommerce') ? [

								'shortcuts_cart_badge_color' => [
									'label' => __( 'Cart Badge Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'divider' => 'top',
									'responsive' => true,
									'sync' => 'live',
									'value' => [
										'background' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'text' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Background', 'noorgfx-component' ),
											'id' => 'background',
											'inherit' => 'var(--theme-palette-color-1)',
										],

										[
											'title' => __( 'Text', 'noorgfx-component' ),
											'id' => 'text',
											'inherit' => '#ffffff',
										],
									],
								],

							] : [],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'shortcuts_bar_items:array-ids:wishlist:enabled' => '!no'
							],
							'options' => [

								'shortcuts_wishlist_badge_color' => [
									'label' => __( 'Wishlist Badge Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'divider' => 'top',
									'responsive' => true,
									'sync' => 'live',
									'value' => [
										'background' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'text' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Background', 'noorgfx-component' ),
											'id' => 'background',
											'inherit' => 'var(--theme-palette-color-1)',
										],

										[
											'title' => __( 'Text', 'noorgfx-component' ),
											'id' => 'text',
											'inherit' => '#ffffff',
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'shortcuts_bar_items:array-ids:compare:enabled' => '!no'
							],
							'options' => [

								'shortcuts_compare_badge_color' => [
									'label' => __( 'Compare Badge Color', 'noorgfx-component' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'divider' => 'top',
									'responsive' => true,
									'sync' => 'live',
									'value' => [
										'background' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'text' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Background', 'noorgfx-component' ),
											'id' => 'background',
											'inherit' => 'var(--theme-palette-color-1)',
										],

										[
											'title' => __( 'Text', 'noorgfx-component' ),
											'id' => 'text',
											'inherit' => '#ffffff',
										],
									],
								],

							],
						],

						'shortcuts_divider' => [
							'label' => __( 'Items Divider', 'noorgfx-component' ),
							'type' => 'ct-border',
							'sync' => 'live',
							'design' => 'inline',
							'divider' => 'top',
							'value' => [
								'width' => 1,
								'style' => 'dashed',
								'color' => [
									'color' => 'var(--theme-palette-color-5)',
								],
							]
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'shortcuts_divider/style' => '!none' ],
							'options' => [

								'shortcuts_divider_height' => [
									'label' => __( 'Items Divider Height', 'noorgfx-component' ),
									'type' => 'ct-slider',
									'value' => 40,
									'min' => 10,
									'max' => 100,
									'defaultUnit' => '%',
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],
						],

						'shortcuts_container_shadow' => [
							'label' => __( 'Shadow', 'noorgfx-component' ),
							'type' => 'ct-box-shadow',
							'responsive' => true,
							'divider' => 'top',
							'value' => noorgfx_box_shadow_value([
								'enable' => true,
								'h_offset' => 0,
								'v_offset' => -10,
								'blur' => 20,
								'spread' => 0,
								'inset' => false,
								'color' => [
									'color' => 'rgba(44,62,80,0.04)',
								],
							]),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'shortcuts_container_background' => [
							'label' => __( 'Container Background', 'noorgfx-component' ),
							'type' => 'ct-background',
							'design' => 'block:right',
							'responsive' => true,
							'divider' => 'top',
							'sync' => 'live',
							'value' => noorgfx_background_default_value([
								'backgroundColor' => [
									'default' => [
										'color' => 'var(--theme-palette-color-8)',
									],
								],
							])
						],

						'shortcuts_container_blur' => [
							'label' => __( 'Container Backdrop Blur', 'noorgfx-component' ),
							'type' => 'ct-number',
							'design' => 'block:right',
							'value' => 0,
							'min' => 0,
							'max' => 100,
							'responsive' => true,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'shortcuts_bar_type' => 'type-2' ],
							'options' => [

								'shortcuts_container_border_radius' => [
									'label' => __( 'Container Border Radius', 'noorgfx-component' ),
									'type' => 'ct-spacing',
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => noorgfx_spacing_value(),
									'inputAttr' => [
										'placeholder' => '7'
									],
									'min' => 0,
									'responsive' => true
								],

							],
						],
					],
				],
			]
		]
	]
];
