<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

$has_mega_menu = noorgfx_akg('has_mega_menu', $atts, 'no' );
$mega_menu_width = noorgfx_akg('mega_menu_width', $atts, 'content' );

noorgfx_output_colors([
	'value' => noorgfx_akg('menu_items_text', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'important' => true,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'container-suffix',
					'to_add' => '[class*="ct-mega-menu"] .sub-menu'
				])
			),
			'variable' => 'theme-text-color'
		],
	],
]);

// column
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'prefix',
			'to_add' => '.sub-menu'
		])
	),
	'property' => 'columns-padding',
	'value' => noorgfx_default_akg(
		'menu_column_padding',
		$atts,
		noorgfx_spacing_value()
	)
]);

$parent_mega_menu_width = noorgfx_akg(
	'mega_menu_width',
	$parent_atts,
	'content'
);
if ($parent_mega_menu_width !== 'full_width') {
	noorgfx_output_background_css([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'prefix',
				'to_add' => '.sub-menu'
			])
		),
		'value' => noorgfx_akg(
			'mega_menu_column_background',
			$atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
					],
				],
			])
		)
	]);
}

noorgfx_output_colors([
	'value' => noorgfx_akg('menu_items_links', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'bg_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	// 'important' => true,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'container-suffix',
						'to_add' => '[class*="ct-mega-menu"] .sub-menu .ct-menu-link'
					]),
					'operation' => 'prefix',
					'to_add' => '.menu'
				])
			),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'container-suffix',
						'to_add' => '[class*="ct-mega-menu"] .sub-menu .ct-menu-link'
					]),
					'operation' => 'prefix',
					'to_add' => '.menu'
				])
			),
			'variable' => 'theme-link-hover-color'
		],

		'bg_hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'container-suffix',
						'to_add' => '[class*="ct-mega-menu"] .sub-menu .ct-menu-link'
					]),
					'operation' => 'prefix',
					'to_add' => '.menu'
				])
			),
			'variable' => 'dropdown-background-hover-color'
		],
	],
]);

// heading
if($has_heading_childs) {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg(
			'menu_items_heading_font',
			$atts,
			noorgfx_typography_default_values([
				'size' => '15px',
				'variation' => 'n7',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'container-suffix',
					'to_add' => '[class*="ct-mega-menu"] .sub-menu .ct-column-heading'
				]),
				'operation' => 'prefix',
				'to_add' => '.menu'
			])
		),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('menu_items_heading', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		// 'important' => true,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'container-suffix',
							'to_add' => '[class*="ct-mega-menu"] .sub-menu .ct-column-heading'
						]),
						'operation' => 'prefix',
						'to_add' => '.menu'
					])
				),
				'variable' => 'theme-link-initial-color'
			],
		],
	]);
}

if (isset($parent) && $parent) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('menu_item_heading', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'important' => true,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '> .ct-column-heading'
					])
				),
				'variable' => 'theme-link-initial-color'
			],
		],
	]);
}

$mega_menu_background_selector = '[class*="ct-mega-menu"] > .sub-menu';

if ($mega_menu_width === 'full_width') {
	$mega_menu_background_selector = '[class*="ct-mega-menu"] > .sub-menu:after';
}

noorgfx_output_background_css([
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'container-suffix',
			'to_add' => $mega_menu_background_selector
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_akg('mega_menu_background', $atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
				],
			],
		])
	)
]);

// shadow

noorgfx_output_box_shadow([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'container-suffix',
			'to_add' => '[class*="ct-mega-menu"] > .sub-menu'
		])
	),
	'should_skip_output' => false,
	'important' => true,
	'value' => noorgfx_akg(
		'mega_menu_shadow',
		$atts,
		noorgfx_box_shadow_value([
			'inherit' => true,
			'enable' => false,
			'h_offset' => 0,
			'v_offset' => 10,
			'blur' => 20,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(41, 51, 61, 0.1)',
			],
		])
	)
]);

// divider
$mega_menu_columns_divider_default = [
	'inherit' => true,
	'width' => 1,
	'style' => 'dashed',
	'color' => [
		'color' => 'rgba(255, 255, 255, 0.1)',
	]
];

$mega_menu_items_divider = noorgfx_akg(
	'mega_menu_items_divider',
	$atts,
	$mega_menu_columns_divider_default
);

noorgfx_output_border([
	'css' => $css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'container-suffix',
				'to_add' => '[class*="ct-mega-menu"] .sub-menu'
			]),
			'operation' => 'prefix',
			'to_add' => 'nav > ul >'
		])
	),
	'variableName' => 'dropdown-divider',
	'important' => true,
	'value' => $mega_menu_items_divider,
	'default' => $mega_menu_columns_divider_default
]);

if ($mega_menu_items_divider['style'] === 'none') {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'container-suffix',
					'to_add' => '[class*="ct-mega-menu"] .sub-menu'
				]),
				'operation' => 'prefix',
				'to_add' => 'nav > ul >'
			])
		),
		'--dropdown-divider-margin: 0px'
	);
} else {
	if (! $mega_menu_items_divider['inherit']) {
		$css->put(
			noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'container-suffix',
						'to_add' => '[class*="ct-mega-menu"] .sub-menu'
					]),
					'operation' => 'prefix',
					'to_add' => 'nav > ul >'
				])
			),
			'--dropdown-divider-margin: calc(var(--dropdown-items-spacing, 13px) - 3px)'
		);
	}
}


if ($has_mega_menu !== 'no') {
	noorgfx_output_border([
		'css' => $css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'container-suffix',
					'to_add' => '[class*="ct-mega-menu"] > .sub-menu'
				]),
				'operation' => 'prefix',
				'to_add' => 'nav > ul >'
			])
		),
		'variableName' => 'dropdown-columns-divider',
		'value' => noorgfx_akg('mega_menu_columns_divider', $atts),
		'default' => [
			// 'inherit' => true,
			'width' => 1,
			'style' => 'solid',
			'color' => [
				'color' => 'rgba(255, 255, 255, 0.1)',
			],
		]
	]);
}

// icon
$menu_item_icon_size = noorgfx_akg( 'menu_item_icon_size', $atts, 15 );

if ($menu_item_icon_size !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-menu-link .ct-icon-container'
			])
		),
		'variableName' => 'theme-icon-size',
		'value' => $menu_item_icon_size,
	]);
}

noorgfx_output_colors([
	'value' => noorgfx_akg('menu_item_icon_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> .ct-menu-link .ct-icon-container'
				])
			),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> .ct-menu-link .ct-icon-container'
				])
			),
			'variable' => 'theme-icon-hover-color'
		],

		'active' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> .ct-menu-link .ct-icon-container'
				])
			),
			'variable' => 'theme-icon-active-color'
		],
	],
	// 'important' => true,
]);


// badge
$menu_badge_vertical_alignment = noorgfx_akg( 'menu_badge_vertical_alignment', $atts, 0 );

if ($menu_badge_vertical_alignment !== 0) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-menu-badge'
			])
		),
		'--margin-top: ' . $menu_badge_vertical_alignment . 'px'
	);
}

$has_menu_badge = noorgfx_akg( 'has_menu_badge', $atts, 'no' );

if ($has_menu_badge !== 'no' ) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('menu_badge_font_color', $atts),
		'default' => [
			'default' => [ 'color' => '#ffffff' ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '> *:first-child .ct-menu-badge'
					])
				),
				'variable' => 'theme-text-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('menu_badge_background', $atts),
		'default' => [
			'default' => [ 'color' => 'var(--theme-palette-color-1)' ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '> *:first-child .ct-menu-badge'
					])
				),
				'variable' => 'background-color'
			],
		],
	]);
}


$mega_menu_columns = noorgfx_akg('mega_menu_columns', $atts, '4');

if (
	$has_mega_menu === 'yes'
	&&
	intval($mega_menu_columns) !== 1
) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'container-suffix',
					'to_add' => '[class*="ct-mega-menu"] > .sub-menu'
				]),
				'operation' => 'prefix',
				'to_add' => 'nav > ul >'
			])
		),
		'--grid-template-columns: ' . noorgfx_akg(
			$mega_menu_columns . '_columns_layout',
			$atts,
			'repeat(' . $mega_menu_columns . ', 1fr)'
		)
	);
}


// custom width
if ($has_mega_menu !== 'no' && $mega_menu_width === 'custom') {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'container-suffix',
				'to_add' => '.ct-mega-menu-custom-width .sub-menu'
			])
		),
		'--mega-menu-max-width: ' . noorgfx_akg( 'mega_menu_custom_width', $atts, '400px' )
	);
}
