<?php

class NoorgfxExtensionCustomFontsPreBoot {
	public function __construct() {
		add_action('admin_enqueue_scripts', function () {
			if (! function_exists('get_plugin_data')) {
				require_once(ABSPATH . 'wp-admin/includes/plugin.php');
			}

			$data = get_plugin_data(NOORGFX__FILE__);

			if (! function_exists('noorgfx_is_dashboard_page')) return;
			if (! noorgfx_is_dashboard_page()) return;

			wp_enqueue_script(
				'noorgfx-ext-custom-fonts-admin-dashboard-scripts',
				NOORGFX_URL . 'framework/premium/extensions/custom-fonts/dashboard-static/bundle/main.js',
				['ct-options-scripts', 'ct-dashboard-scripts'],
				$data['Version']
			);
		});
	}

	public function ext_action($payload) {
		$storage = new \Noorgfx\Extensions\CustomFonts\Storage();

		if (
			! isset($payload['type'])
			||
			! isset($payload['settings'])
			||
			$payload['type'] !== 'update-settings'
		) {
			return null;
		}

		if (isset($payload['settings']['urls'])) {
			$performance_storage = new \Noorgfx\PerformanceTypography();

			$performance_storage->set_settings([
				'custom' => noorgfx_akg('urls', $payload['settings'], [])
			]);

			unset($payload['settings']['urls']);
		}

		$storage->set_settings($payload['settings']);

		do_action('noorgfx:dynamic-css:refresh-caches');

		return [
			'settings' => $payload['settings'],
			'font_stacks' => $storage->get_font_stacks()
		];
	}

	public function ext_data() {
		$storage = new \Noorgfx\Extensions\CustomFonts\Storage();

		$settings = $storage->get_settings();

		$settings['fonts'] = $storage->get_normalized_fonts_list();

		return [
			'settings' => $settings,
			'font_stacks' => $storage->get_font_stacks()
		];
	}
}

