<?php

$options = [

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			'color_switch_icon_type' => [
				'label' => false,
				'type' => 'ct-image-picker',
				'value' => 'type-1',
				'attr' => [
					'data-type' => 'background',
					'data-columns' => '3',
				],
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'type-1' => [
						'src'   => noorgfx_image_picker_file( 'color-switch-1' ),
						'title' => __( 'Type 1', 'noorgfx-component' ),
					],

					'type-2' => [
						'src'   => noorgfx_image_picker_file( 'color-switch-2' ),
						'title' => __( 'Type 2', 'noorgfx-component' ),
					],

					'type-3' => [
						'src'   => noorgfx_image_picker_file( 'color-switch-3' ),
						'title' => __( 'Type 3', 'noorgfx-component' ),
					],
				],
			],

			'color_switch_icon_state' => [
				'label' => __( 'Reverse Icon State', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'icon_size' => [
				'label' => __( 'Icon Size', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'min' => 5,
				'max' => 50,
				'value' => 15,
				'responsive' => true,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'color_switch_label_visibility' => [
				'label' => __( 'Label Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => false,
					'tablet' => false,
					'mobile' => false,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'color_switch_label_visibility/desktop' => true,
						'color_switch_label_visibility/tablet' => true,
						'color_switch_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'color_switch_label_position' => [
						'type' => 'ct-radio',
						'label' => __( 'Label Position', 'noorgfx-component' ),
						'value' => 'left',
						'view' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'responsive' => [ 'tablet' => 'skip' ],
						'choices' => [
							'left' => __( 'Left', 'noorgfx-component' ),
							'right' => __( 'Right', 'noorgfx-component' ),
							'bottom' => __( 'Bottom', 'noorgfx-component' ),
						],
					],

					'dark_mode_label' => [
						'label' => __( 'Dark Mode Label', 'noorgfx-component' ),
						'type' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'value' => __( 'Dark Mode', 'noorgfx-component' ),
						'sync' => 'live',
						'responsive' => [
							'tablet' => 'skip'
						],
					],

					'light_mode_label' => [
						'label' => __( 'Light Mode Label', 'noorgfx-component' ),
						'type' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'value' => __( 'Light Mode', 'noorgfx-component' ),
						'sync' => 'live',
						'responsive' => [
							'tablet' => 'skip'
						],
					],
				],
			],

			'default_color_mode' => [
				'label' => __('Default Color Mode', 'noorgfx-component'),
				'type' => 'ct-radio',
				'value' => 'light',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'light' => __( 'Light', 'noorgfx-component' ),
					'dark' => __( 'Dark', 'noorgfx-component' ),
					'system' => __( 'OS Aware', 'noorgfx-component' ),
				],
				'desc' => __('Choose the default color mode that a user will see when it visits your site.', 'noorgfx-component'),
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'color_switch_label_visibility/desktop' => true,
						'color_switch_label_visibility/tablet' => true,
						'color_switch_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'color_switch_label_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Label Font', 'noorgfx-component' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Label Font Color', 'noorgfx-component' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'header_color_switch_font_color',
								'label' => __('Default State', 'noorgfx-component')
							],

							[
								'id' => 'transparent_header_color_switch_font_color',
								'label' => __('Transparent State', 'noorgfx-component'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_header_color_switch_font_color',
								'label' => __('Sticky State', 'noorgfx-component'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'header_color_switch_font_color' => [
								'label' => __( 'Font Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx-component' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'transparent_header_color_switch_font_color' => [
								'label' => __( 'Font Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx-component' ),
										'id' => 'hover',
									],
								],
							],

							'sticky_header_color_switch_font_color' => [
								'label' => __( 'Font Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx-component' ),
										'id' => 'hover',
									],
								],
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icon Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'header_color_switch_icon_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_header_color_switch_icon_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_header_color_switch_icon_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [
					'header_color_switch_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)',
							],
						],
					],

					'transparent_header_color_switch_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

					'sticky_header_color_switch_icon_color' => [
						'label' => __( 'Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],
				],
			],


			'container_margin' => [
				'label' => __( 'Margin', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'header_color_switch_visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

		],
	],

];
