<?php
if (!defined("ABSPATH")) {
    exit();
}

// Woocommerce Settings
function sab_woocommerce_settings_page()
{
    $fields = [
        "billing_first_name" => "نام",
        "billing_last_name" => "نام خانوادگی",
        "billing_company" => "نام شرکت (اختیاری)",
        "billing_country" => "کشور / منطقه",
        "billing_state" => "استان",
        "billing_city" => "شهر",
        "billing_address_1" => "آدرس خیابان",
        "billing_address_2" => "آدرس خیابان 2",
        "billing_postcode" => "کدپستی",
        "billing_phone" => "تلفن",
        "billing_email" => "آدرس ایمیل",
        "order_comments" => "توضیحات تکمیلی",
    ];

    $enabled_fields = get_option("sab_enabled_checkout_fields", []);
    $product_label = get_option("sab_product_label", "محصول");
    $order_button_text = get_option("sab_order_button_text", "ثبت سفارش");
    $hide_customer_details = get_option("sab_hide_customer_details", false);

    if (!is_array($enabled_fields)) {
        $enabled_fields = [];
    }
    ?>
    <div class="nobat-page">
        <div class="nobat-head">تنظیمات ووکامرس</div>
        <form method="post" action="options.php">
            <?php settings_fields("sab-woocommerce-settings-group"); ?>
            <h2>تنظیمات فیلدهای تسویه حساب</h2>
            <table class="form-table">
                <?php foreach ($fields as $field_key => $field_label): ?>
                    <tr valign="top">
                        <th scope="row"><?php echo $field_label; ?></th>
                        <td>
                            <div class="switch-wrapper">
                                <label class="switch">
                                    <input type="checkbox" name="sab_enabled_checkout_fields[]" value="<?php echo $field_key; ?>" <?php checked(in_array($field_key, $enabled_fields)); ?>>
                                    <span class="slider"></span>
                                </label>
                                <span class="switch-label">پنهان کردن این فیلد</span>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">پنهان کردن جزئیات مشتری</th>
                    <td>
                        <div class="switch-wrapper">
                            <label class="switch">
                                <input type="checkbox" name="sab_hide_customer_details" value="1" <?php checked($hide_customer_details, 1); ?>>
                                <span class="slider"></span>
                            </label>
                            <span class="switch-label">پنهان کردن این فیلد</span>
                        </div>
                    </td>
                </tr>	
            </table>	
            <h2>تنظیمات اضافی</h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">تغییر واژه محصول</th>
                    <td><input type="text" name="sab_product_label" value="<?php echo esc_attr($product_label); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">متن دکمه ثبت سفارش</th>
                    <td><input type="text" name="sab_order_button_text" value="<?php echo esc_attr($order_button_text); ?>" /></td>
                </tr>		
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Register Woocommerce Settings
function sab_register_woocommerce_settings()
{
    register_setting(
        "sab-woocommerce-settings-group",
        "sab_enabled_checkout_fields"
    );
    register_setting("sab-woocommerce-settings-group", "sab_product_label");
    register_setting("sab-woocommerce-settings-group", "sab_order_button_text");
    register_setting(
        "sab-woocommerce-settings-group",
        "sab_hide_customer_details"
    );
}
add_action("admin_init", "sab_register_woocommerce_settings");

// Customize Checkout Labels
function sab_customize_checkout_labels($translated_text, $text, $domain)
{
    $product_label = get_option("sab_product_label", "محصول");

    if ($domain === "woocommerce") {
        if ($text === "Product") {
            $translated_text = $product_label;
        }
    }

    return $translated_text;
}
add_filter("gettext", "sab_customize_checkout_labels", 10, 3);

// Change Order Button Text
function sab_change_order_button_text($button_text)
{
    $order_button_text = get_option("sab_order_button_text", "ثبت سفارش");
    return $order_button_text;
}
add_filter("woocommerce_order_button_text", "sab_change_order_button_text");

// Manage Checkout Fields
function sab_manage_checkout_fields($fields) {
    if (is_appointment_product_in_cart()) {
        $enabled_fields = get_option("sab_enabled_checkout_fields", []);

        if (!is_array($enabled_fields)) {
            $enabled_fields = [];
        }

        $all_fields = [
            "billing_first_name",
            "billing_last_name",
            "billing_company",
            "billing_country",
            "billing_state",
            "billing_city",
            "billing_address_1",
            "billing_address_2",
            "billing_postcode",
            "billing_phone",
            "billing_email",
            "order_comments",
        ];

        foreach ($all_fields as $field) {
            if (in_array($field, $enabled_fields)) {
                if (isset($fields["billing"][$field])) {
                    unset($fields["billing"][$field]);
                }
                if (isset($fields["order"][$field])) {
                    unset($fields["order"][$field]);
                }
            }
        }
    }
    return $fields;
}
add_filter("woocommerce_checkout_fields", "sab_manage_checkout_fields");

// Hide Order Comments CSS
function sab_hide_order_comments_css() {
    if (is_appointment_product_in_cart()) {
        $enabled_fields = get_option("sab_enabled_checkout_fields", []);
        $hide_customer_details = get_option("sab_hide_customer_details", false);

        if (!is_array($enabled_fields)) {
            $enabled_fields = [];
        }
        if (in_array("order_comments", $enabled_fields)) {
            echo '<style>
                .woocommerce-additional-fields {
                    display: none !important;
                }
            </style>';
        }
        if (in_array("billing_address_1", $enabled_fields)) {
            echo '<style>
                #billing_address_1 {
                    display: none !important;
                }
            </style>';
        }
        if ($hide_customer_details) {
            echo '<style>
                #customer_details, #order_review_heading {
                    display: none !important;
                }
                #order_review {width:100%;padding: 0;}
            </style>';
        }
    }
}
add_action("wp_head", "sab_hide_order_comments_css");