<?php
if (!defined("ABSPATH")) {
    exit();
}

//Services
function sab_get_services()
{
    global $wpdb;
    $table_name = $wpdb->prefix . "sab_services";
    $services = $wpdb->get_results("SELECT * FROM $table_name");
    if ($services) {
        wp_send_json_success($services);
    } else {
        wp_send_json_error("No services found");
    }
}
add_action("wp_ajax_sab_get_services", "sab_get_services");
add_action("wp_ajax_nopriv_sab_get_services", "sab_get_services");

//Service Price
function sab_get_service_price()
{
    global $wpdb;
    $service_id = intval($_POST["service_id"]);
    $table_name = $wpdb->prefix . "sab_services";
    $price = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT price FROM $table_name WHERE id = %d",
            $service_id
        )
    );
    if ($price !== null) {
        wp_send_json_success(["price" => $price]);
    } else {
        wp_send_json_error("Service not found");
    }
}
add_action("wp_ajax_sab_get_service_price", "sab_get_service_price");
add_action("wp_ajax_nopriv_sab_get_service_price", "sab_get_service_price");

//Doctors
function sab_get_doctors()
{
    global $wpdb;
    $service_id = intval($_POST["service_id"]);
    $table_name = $wpdb->prefix . "sab_doctors";
    $doctors = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT * FROM $table_name WHERE service_id = %d",
            $service_id
        )
    );

    if ($doctors) {
        wp_send_json_success($doctors);
    } else {
        wp_send_json_error("No doctors found");
    }
}
add_action("wp_ajax_sab_get_doctors", "sab_get_doctors");
add_action("wp_ajax_nopriv_sab_get_doctors", "sab_get_doctors");

//Availability
function sab_get_availability() {
    global $wpdb;
    $doctor_id = intval($_POST['doctor_id']);
    $table_name = $wpdb->prefix . 'sab_availability';
    $availability = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE doctor_id = %d", $doctor_id));

    if ($availability) {
        $dates = array();
        $times = array();

        foreach ($availability as $slot) {
            $start_date = new DateTime($slot->date);
            $end_date = new DateTime($slot->end_date ?: $slot->date);

            $interval = new DateInterval('P1D');
            $date_range = new DatePeriod($start_date, $interval, $end_date->modify('+1 day'));

            foreach ($date_range as $date) {
                $formatted_date = $date->format('Y-m-d');
                $dates[] = $formatted_date;
                $times[$formatted_date] = explode(',', $slot->times);
            }
        }
        $dates = array_unique($dates);
        wp_send_json_success(array('dates' => $dates, 'times' => $times));
    } else {
        wp_send_json_error('No availability found');
    }
}
add_action('wp_ajax_sab_get_availability', 'sab_get_availability');
add_action('wp_ajax_nopriv_sab_get_availability', 'sab_get_availability');

//Conver to Jalali
function convert_to_jalali($date)
{
    if (class_exists("IntlDateFormatter")) {
        $formatter = new IntlDateFormatter(
            "fa_IR@calendar=persian",
            IntlDateFormatter::FULL,
            IntlDateFormatter::NONE,
            "Asia/Tehran",
            IntlDateFormatter::TRADITIONAL
        );
        return $formatter->format(strtotime($date));
    } else {
        return $date;
    }
}

//Send Email
function sab_send_emails($appointment)
{
    $admin_email = get_option("sab_admin_email", get_option("admin_email"));
    $admin_email_subject = get_option(
        "sab_admin_email_subject",
        "رزرو نوبت جدید"
    );
    $admin_email_body = get_option(
        "sab_admin_email_body",
        "یک رزرو نوبت جدید ثبت شده است."
    );
    $user_email_subject = get_option(
        "sab_user_email_subject",
        "تایید رزرو نوبت"
    );
    $user_email_body = get_option(
        "sab_user_email_body",
        "با تشکر از شما برای رزرو نوبت."
    );

    $day_name = jdate("l", strtotime($appointment["day"]));
    $day_number = jdate("j", strtotime($appointment["day"]));
    $month_name = jdate("F", strtotime($appointment["day"]));
    $year = jdate("Y", strtotime($appointment["day"]));

    $formatted_date = "{$day_name} {$day_number} {$month_name} {$year}";

    $replacements = [
        "{name}" => esc_html($appointment["patient_name"]),
        "{phone}" => esc_html($appointment["patient_phone"]),
        "{mobile}" => esc_html($appointment["patient_mobile"]),
        "{email}" => esc_html($appointment["patient_email"]),
        "{service}" => esc_html($appointment["service_name"]),
        "{doctor}" => esc_html($appointment["doctor_name"]),
        "{date}" => esc_html($formatted_date),
        "{time}" => esc_html($appointment["time"]),
        "{custom-1}" => esc_html($appointment["custom_text_1"]),
        "{custom-2}" => esc_html($appointment["custom_text_2"]),
        "{custom-3}" => esc_html($appointment["custom_text_3"]),		
        "{custom-4}" => esc_html($appointment["custom_text_4"]),		
    ];

    $admin_email_body = str_replace(
        array_keys($replacements),
        array_values($replacements),
        $admin_email_body
    );
    $user_email_body = str_replace(
        array_keys($replacements),
        array_values($replacements),
        $user_email_body
    );

    $admin_email_body = wpautop($admin_email_body);
    $user_email_body = wpautop($user_email_body);

    $headers = ["Content-Type: text/html; charset=UTF-8"];

    // Split admin emails by comma and validate
    $admin_emails = array_map('trim', explode(',', $admin_email));
    $valid_admin_emails = array_filter($admin_emails, 'is_email');

    if (!empty($valid_admin_emails)) {
        wp_mail($valid_admin_emails, $admin_email_subject, $admin_email_body, $headers);
    } else {
        error_log('No valid admin emails provided for sending notification.');
    }

    if (is_email($appointment["patient_email"])) {
        wp_mail($appointment["patient_email"], $user_email_subject, $user_email_body, $headers);
    } else {
        error_log('Invalid user email provided: ' . $appointment["patient_email"]);
    }
}
add_filter("wp_mail_content_type", "sab_set_html_mail_content_type");
function sab_set_html_mail_content_type()
{
    return "text/html";
}
add_action("wp_mail_failed", "sab_reset_mail_content_type");
function sab_reset_mail_content_type($wp_error)
{
    remove_filter("wp_mail_content_type", "sab_set_html_mail_content_type");
}

//Booking Appointment
function sab_book_appointment()
{
    global $wpdb;

	if (isset($_POST['radio_field'])) {
		$radio_field = sanitize_text_field($_POST['radio_field']);
	} else {
		$radio_field = '';
	}

	if (isset($_POST['select_field'])) {
		$select_field = sanitize_text_field($_POST['select_field']);
	} else {
		$select_field = '';
	}

	$checkbox_field = '';
	if (isset($_POST['checkbox_field']) && is_array($_POST['checkbox_field'])) {
		$checkbox_field = implode(', ', array_map('sanitize_text_field', $_POST['checkbox_field']));
	}

	//Upload Files
	$file_urls = [];
	for ($i = 0; $i < 10; $i++) { 
		if (!empty($_FILES["file_upload_$i"]["name"])) {
			$allowed_file_types = ["image/png", "image/jpeg", "image/jpg", "application/pdf"];
			$max_file_size = 2 * 1024 * 1024;

			$file_type = $_FILES["file_upload_$i"]["type"];
			$file_size = $_FILES["file_upload_$i"]["size"];

			if (!in_array($file_type, $allowed_file_types)) {
				wp_send_json_error("فرمت فایل مجاز نیست. لطفاً فایل با فرمت PNG, JPEG, JPG یا PDF آپلود کنید.");
			}

			if ($file_size > $max_file_size) {
				wp_send_json_error("حجم فایل بیش از حد مجاز است. لطفاً فایل کمتر از 2 مگابایت آپلود کنید.");
			}

			$upload_dir = wp_upload_dir();
			$target_dir = $upload_dir["basedir"] . "/uploads/";
			if (!file_exists($target_dir)) {
				mkdir($target_dir, 0755, true);
			}

			$file_name = basename($_FILES["file_upload_$i"]["name"]);
			$target_file = $target_dir . time() . '-' . $i . '-' . $file_name;

			if (move_uploaded_file($_FILES["file_upload_$i"]["tmp_name"], $target_file)) {
				$file_urls[] = $upload_dir["baseurl"] . "/uploads/" . time() . '-' . $i . '-' . $file_name;
			} else {
				wp_send_json_error("خطا در آپلود فایل شماره " . $i . ".");
			}
		}
	}

    $table_name = $wpdb->prefix . "sab_appointments";
    $service_id = intval($_POST["service_id"]);
    $doctor_id = intval($_POST["doctor_id"]);
    $day = sanitize_text_field($_POST["date"]);
    $time = sanitize_text_field($_POST["time"]);
    $name = sanitize_text_field($_POST["name"]);
    $phone = sanitize_text_field($_POST["phone"]);
    $mobile = sanitize_text_field($_POST["mobile"]);
    $email = sanitize_email($_POST["email"]);
    $custom_text_1 = isset($_POST["custom_text_1"])   ? sanitize_text_field($_POST["custom_text_1"])   : "";
    $custom_text_2 = isset($_POST["custom_text_2"])   ? sanitize_text_field($_POST["custom_text_2"])   : "";
    $custom_text_3 = isset($_POST["custom_text_3"])   ? sanitize_text_field($_POST["custom_text_3"])   : "";	
    $custom_text_4 = isset($_POST["custom_text_4"])   ? sanitize_text_field($_POST["custom_text_4"])   : "";	

    $existing = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT COUNT(*) FROM $table_name WHERE doctor_id = %d AND day = %s AND time = %s",
            $doctor_id,
            $day,
            $time
        )
    );
    if ($existing > 0) {
        wp_send_json_error("این زمان قبلاً رزرو شده است.");
        return;
    }
    $enable_wc_integration = get_option(
        "enable_woocommerce_integration",
        "yes"
    );

	if ($enable_wc_integration === "yes") {
		$service = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}sab_services WHERE id = %d",
				$service_id
			)
		);
		$doctor = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}sab_doctors WHERE id = %d",
				$doctor_id
			)
		);
		$product_id = sab_create_woocommerce_product(
			$service->name,
			$service->price,
			$doctor->name,
			$day,
			$time,
		);

		$added_to_cart = sab_add_to_cart($product_id);

		if ($added_to_cart) {
			$appointment_data = [
				"service_id" => $service_id,
				"doctor_id" => $doctor_id,
				"day" => $day,
				"time" => $time,
				"patient_name" => $name,
				"patient_phone" => $phone,
				"patient_mobile" => $mobile,
				"patient_email" => $email,
				'radio_field' => $radio_field,
				'checkbox_field' => $checkbox_field,
				'select_field' => $select_field,				
				"custom_text_1" => $custom_text_1,
				"custom_text_2" => $custom_text_2,		
				"custom_text_3" => $custom_text_3,		
				"custom_text_4" => $custom_text_4,					
				"file_path" => json_encode($file_urls),
				"created_at" => current_time('mysql')
			];

			$transient_key = "sab_appointment_" . time() . "_" . mt_rand(1000, 9999);
			set_transient($transient_key, $appointment_data, 60 * 60);

			WC()->session->set("sab_appointment_transient_key", $transient_key);
			$checkout_url = wc_get_checkout_url();
			wp_send_json_success(["redirect" => $checkout_url]);
		} else {
			wp_send_json_error([
				"message" => "خطا در افزودن محصول به سبد خرید",
			]);
		}
	} else {
		$appointment_data = [
			"service_id" => $service_id,
			"doctor_id" => $doctor_id,
			"day" => $day,
			"time" => $time,
			"patient_name" => $name,
			"patient_phone" => $phone,
			"patient_mobile" => $mobile,
			"patient_email" => $email,
			'radio_field' => $radio_field,
			'checkbox_field' => $checkbox_field,
			'select_field' => $select_field,			
			"custom_text_1" => $custom_text_1,
			"custom_text_2" => $custom_text_2,		
			"custom_text_3" => $custom_text_3,		
			"custom_text_4" => $custom_text_4,							
			"file_path" => json_encode($file_urls),
			"created_at" => current_time('mysql') 
		];

		$result = $wpdb->insert($table_name, $appointment_data);

		if ($result) {
			sab_send_emails($appointment_data);
			sab_send_sms($appointment_data);

			$appointment_time = strtotime($day . ' ' . $time);
			$reminder_24h_time = $appointment_time - 24 * 3600; // 24 ساعت قبل
			$reminder_2h_time = $appointment_time - 2 * 3600;   // 2 ساعت قبل

			wp_schedule_single_event($reminder_24h_time, 'sab_send_reminder_24h', [$wpdb->insert_id]);
			wp_schedule_single_event($reminder_2h_time, 'sab_send_reminder_2h', [$wpdb->insert_id]);

			wp_send_json_success(["message" => "رزرو شما با موفقیت ثبت شد."]);
		} else {
			wp_send_json_error(["message" => "خطا در ثبت رزرو."]);
		}
    }
}
add_action("wp_ajax_sab_book_appointment", "sab_book_appointment");
add_action("wp_ajax_nopriv_sab_book_appointment", "sab_book_appointment");

//Change Order Status
function sab_process_appointment_on_order_status_change(
    $order_id,
    $old_status,
    $new_status
) {
    if (
        $new_status == "processing" ||
        $new_status == "completed" ||
        $new_status == "pending" ||
        $new_status == "on-hold"
    ) {
        $order = wc_get_order($order_id);
        if (!WC()->session) {
            WC()->initialize_session();
        }

        $transient_key = WC()->session->get("sab_appointment_transient_key");

        if ($transient_key) {
            $appointment_data = get_transient($transient_key);

            if ($appointment_data) {
                global $wpdb;
                $table_name = $wpdb->prefix . "sab_appointments";

                $result = $wpdb->insert($table_name, $appointment_data);

		if ($result) {
			delete_transient($transient_key);
			WC()->session->__unset("sab_appointment_transient_key");

			sab_send_emails($appointment_data);
			sab_send_sms($appointment_data);

			$appointment_time = strtotime($appointment_data['day'] . ' ' . $appointment_data['time']);
			$reminder_24h_time = $appointment_time - 24 * 3600;
			$reminder_2h_time = $appointment_time - 2 * 3600;

			wp_schedule_single_event($reminder_24h_time, 'sab_send_reminder_24h', [$wpdb->insert_id]);
			wp_schedule_single_event($reminder_2h_time, 'sab_send_reminder_2h', [$wpdb->insert_id]);
		} else {
			error_log("Error inserting appointment into database");
		}
            }
        }
    }
}
add_action("woocommerce_order_status_changed", "sab_process_appointment_on_order_status_change", 10, 3);

// Send SMS
function sab_send_sms($appointment) {
    global $wpdb;

    $service_name = $wpdb->get_var($wpdb->prepare(
        "SELECT name FROM {$wpdb->prefix}sab_services WHERE id = %d",
        $appointment['service_id']
    ));
    $doctor_name = $wpdb->get_var($wpdb->prepare(
        "SELECT name FROM {$wpdb->prefix}sab_doctors WHERE id = %d",
        $appointment['doctor_id']
    ));

    $appointment['service_name'] = $service_name ? $service_name : 'نامشخص';
    $appointment['doctor_name'] = $doctor_name ? $doctor_name : 'نامشخص';

    $day_name = jdate("l", strtotime($appointment["day"]));
    $day_number = jdate("j", strtotime($appointment["day"]));
    $month_name = jdate("F", strtotime($appointment["day"]));
    $year = jdate("Y", strtotime($appointment["day"]));
    $formatted_date = "{$day_name} {$day_number} {$month_name} {$year}";

    $replacements = [
        "{name}" => $appointment["patient_name"] ?? "نامشخص",
        "{service}" => $appointment["service_name"],
        "{doctor}" => $appointment["doctor_name"],
        "{date}" => $formatted_date,
        "{time}" => $appointment["time"] ?? "نامشخص",
        "{mobile}" => $appointment["patient_mobile"] ?? "نامشخص",
        "{phone}" => $appointment["patient_phone"] ?? "نامشخص",
        "{custom-1}" => $appointment["custom_text_1"] ?? "نامشخص",
        "{custom-2}" => $appointment["custom_text_2"] ?? "نامشخص",
        "{custom-3}" => $appointment["custom_text_3"] ?? "نامشخص",
        "{custom-4}" => $appointment["custom_text_4"] ?? "نامشخص",
    ];

    // Send Faraz SMS
    $ippanel_username = get_option("sab_ippanel_username");
    $ippanel_password = get_option("sab_ippanel_password");
    $ippanel_from = get_option("sab_ippanel_from");

    if (!empty($ippanel_username) && !empty($ippanel_password) && !empty($ippanel_from)) {
        $url = "https://ippanel.com/services.jspd";

        // Send to user
        if (!empty($appointment["patient_mobile"])) {
            $message = get_option("sab_ippanel_message_user");
            send_faraz_sms($url, $ippanel_username, $ippanel_password, $ippanel_from, 
                          $appointment["patient_mobile"], $message, $replacements);
        }

        // Send to doctor
        $doctor_mobile = get_option('sab_doctor_faraz_mobile');
        if (!empty($doctor_mobile)) {
            $message = get_option("sab_ippanel_message_doctor");
            send_faraz_sms($url, $ippanel_username, $ippanel_password, $ippanel_from, 
                          $doctor_mobile, $message, $replacements);
        }

        // Send to admin
        $admin_mobile = get_option("sab_ippanel_admin_mobile");
        if (!empty($admin_mobile)) {
            $message = get_option("sab_ippanel_message_admin");
            send_faraz_sms($url, $ippanel_username, $ippanel_password, $ippanel_from, 
                          $admin_mobile, $message, $replacements);
        }
    }

    // Send Melli Payamak SMS
    $sms_username = get_option("sab_sms_username");
    $sms_password = get_option("sab_sms_password");
    $sms_from = get_option("sab_sms_from");

    if (!empty($sms_username) && !empty($sms_password)) {
        // Send to User
        if (!empty($appointment["patient_mobile"])) {
            $message = get_option("sab_sms_message_user");
            $use_template = get_option("sab_sms_use_template_user", 0);
            $template_id = get_option("sab_sms_template_id_user");
            if ($use_template && !empty($template_id)) {
                send_sms_with_template($sms_username, $sms_password, $appointment["patient_mobile"], $template_id, $message, $replacements);
            } else {
                send_sms_regular($sms_username, $sms_password, $sms_from, $appointment["patient_mobile"], $message, $replacements);
            }
        }

        // Send to Admin
        $admin_mobile = get_option("sab_sms_admin_mobile");
        if (!empty($admin_mobile)) {
            $message = get_option("sab_sms_message_admin");
            $use_template = get_option("sab_sms_use_template_admin", 0);
            $template_id = get_option("sab_sms_template_id_admin");
            if ($use_template && !empty($template_id)) {
                send_sms_with_template($sms_username, $sms_password, $admin_mobile, $template_id, $message, $replacements);
            } else {
                send_sms_regular($sms_username, $sms_password, $sms_from, $admin_mobile, $message, $replacements);
            }
        }

        // Send to Doctor
        $doctor_mobile = get_option("sab_doctor_sms_mobile");
        if (!empty($doctor_mobile)) {
            $message = get_option("sab_sms_message_doctor");
            $use_template = get_option("sab_sms_use_template_doctor", 0);
            $template_id = get_option("sab_sms_template_id_doctor");
            if ($use_template && !empty($template_id)) {
                send_sms_with_template($sms_username, $sms_password, $doctor_mobile, $template_id, $message, $replacements);
            } else {
                send_sms_regular($sms_username, $sms_password, $sms_from, $doctor_mobile, $message, $replacements);
            }
        }
    }
}

// Helper Faraz SMS
function send_faraz_sms($url, $username, $password, $from, $to, $message, $replacements) {
    foreach ($replacements as $key => $value) {
        $message = str_replace($key, $value, $message);
    }
    
    $rcpt_nm = [$to];
    $param = [
        "uname" => $username,
        "pass" => $password,
        "from" => $from,
        "message" => $message,
        "to" => json_encode($rcpt_nm),
        "op" => "send",
    ];
    
    $handler = curl_init($url);
    curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($handler, CURLOPT_POSTFIELDS, $param);
    curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($handler);
    $response = json_decode($response);
    $res_code = $response[0];
    $res_data = $response[1];
    error_log("SMS Send Response Code: " . $res_code);
    error_log("SMS Send Response Data: " . $res_data);
}

//Send Regular Meli Payamak
function send_sms_regular($username, $password, $from, $to, $message, $replacements) {
    $message = str_replace(array_keys($replacements), array_values($replacements), $message);
    $data = [
        "username" => $username,
        "password" => $password,
        "to" => $to,
        "from" => $from,
        "text" => $message,
    ];
    $post_data = http_build_query($data);

    $handle = curl_init("https://rest.payamak-panel.com/api/SendSMS/SendSMS");
    curl_setopt($handle, CURLOPT_HTTPHEADER, ["content-type: application/x-www-form-urlencoded"]);
    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($handle, CURLOPT_POST, true);
    curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
    $response = curl_exec($handle);

    error_log("Regular SMS Response: " . print_r($response, true));
}

//Send Pattern Meli Payamak
function send_sms_with_template($username, $password, $to, $bodyId, $message, $replacements) {
    $message = str_replace(array_keys($replacements), array_values($replacements), $message);
    $data = [
        "username" => $username,
        "password" => $password,
        "to" => $to,
        "text" => $message,
        "bodyId" => $bodyId,
    ];
    $post_data = http_build_query($data);

    $handle = curl_init("https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber");
    curl_setopt($handle, CURLOPT_HTTPHEADER, ["content-type: application/x-www-form-urlencoded"]);
    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($handle, CURLOPT_POST, true);
    curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
    $response = curl_exec($handle);

    error_log("Template SMS Response: " . print_r($response, true));
}

//Create Product
function sab_create_woocommerce_product($service_name, $service_price, $doctor_name, $appointment_date, $appointment_time) {
    list($gy, $gm, $gd) = explode("-", $appointment_date);
    list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);
    $jalali_date = sprintf("%04d/%02d/%02d", $jy, $jm, $jd);

    $product_name = sprintf("%s | %s | %s | %s", $service_name, $doctor_name, $jalali_date, $appointment_time);

    $product = new WC_Product_Simple();
    $product->set_name($product_name);
    $product->set_status("publish");
    $product->set_catalog_visibility("hidden");
    $product->set_price($service_price);
    $product->set_regular_price($service_price);
    $product->set_virtual(true);
    $product->set_downloadable(true);
    $product->set_manage_stock(false);
    $product->set_stock_status("instock");
    $product->set_sold_individually(true);

    $product->update_meta_data('is_appointment_product', 'true');

    $product->save();

    $product_id = $product->get_id();
    set_transient('sab_product_expiry_' . $product_id, time() + (5 * 60), 6 * 60);

    return $product_id;
}
function is_appointment_product_in_cart() {
    if (!WC()->cart) {
        return false; 
    }
    foreach (WC()->cart->get_cart() as $cart_item) {
        $product = $cart_item['data'];
        if ($product->get_meta('is_appointment_product') === 'true') {
            return true; 
        }
    }
    return false; 
}
function sab_check_expired_products() {
    global $wpdb;
    
    $transients = $wpdb->get_results(
        "SELECT option_name, option_value 
        FROM {$wpdb->options} 
        WHERE option_name LIKE '_transient_sab_product_expiry_%'"
    );
    
    foreach ($transients as $transient) {
        $product_id = str_replace('_transient_sab_product_expiry_', '', $transient->option_name);
        $expiry_time = $transient->option_value;
        
        if (time() > $expiry_time) {
            wp_delete_post($product_id, true);
            delete_transient('sab_product_expiry_' . $product_id);
            error_log('Deleted expired product: ' . $product_id);
        }
    }
}

add_action('init', 'sab_check_expired_products');
add_action('woocommerce_before_cart', 'sab_check_expired_products');
add_action('woocommerce_before_checkout_form', 'sab_check_expired_products');

function sab_ajax_check_expired_products() {
    sab_check_expired_products();
}
add_action('wp_ajax_sab_check_expired', 'sab_ajax_check_expired_products');
add_action('wp_ajax_nopriv_sab_check_expired', 'sab_ajax_check_expired_products');

function sab_add_expiry_check_script() {
    if (is_cart() || is_checkout()) {
        ?>
        <script type="text/javascript">
        jQuery(function($) {
            function checkExpired() {
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'sab_check_expired'
                    },
                    success: function(response) {
                        setTimeout(checkExpired, 30000); 
                    }
                });
            }
            checkExpired();
        });
        </script>
        <?php
    }
}
add_action('wp_footer', 'sab_add_expiry_check_script');

//Add to Cart
function sab_add_to_cart($product_id)
{
    $added = WC()->cart->add_to_cart($product_id);
    return $added !== false;
}

//Create Remove Button to Checkout
function sab_add_remove_button_to_checkout(
    $product_name,
    $cart_item,
    $cart_item_key
) {
    $product_id = $cart_item["product_id"];
    $remove_link = sprintf(
        '<a href="#" class="remove-cart-item" aria-label="%s" data-product_id="%s" data-cart_item_key="%s">×</a>',
        esc_attr__("Remove this item", "woocommerce"),
        esc_attr($product_id),
        esc_attr($cart_item_key)
    );
    return $remove_link . " " . $product_name;
}
add_filter(
    "woocommerce_cart_item_name",
    "sab_add_remove_button_to_checkout",
    10,
    3
);

//Remove Cart Items
function sab_remove_cart_item()
{
    $cart_item_key = sanitize_text_field($_POST["cart_item_key"]);

    if (WC()->cart->remove_cart_item($cart_item_key)) {
        $fragments = [];

        ob_start();
        woocommerce_order_review();
        $fragments[".woocommerce-checkout-review-order-table"] = ob_get_clean();

        $cart_totals = [
            "subtotal" => WC()->cart->get_subtotal(),
            "total" => WC()->cart->get_total(),
        ];

        wp_send_json_success([
            "fragments" => $fragments,
            "cart_totals" => $cart_totals,
            "is_empty" => WC()->cart->is_empty(),
            "home_url" => home_url("/"),
        ]);
    } else {
        wp_send_json_error("خطا در حذف آیتم از سبد خرید.");
    }
}
add_action("wp_ajax_sab_remove_cart_item", "sab_remove_cart_item");
add_action("wp_ajax_nopriv_sab_remove_cart_item", "sab_remove_cart_item");

//Checkout Scripts
function sab_checkout_scripts()
{
    if (is_checkout()) { ?>
        <script type="text/javascript">
        jQuery(function($) {
            function blockUI(element) {
                $(element).block({
                    message: null,
                    overlayCSS: {
                        background: '#fff',
                        opacity: 0.6
                    }
                });
            }

            function unblockUI(element) {
                $(element).unblock();
            }

            $('body').on('click', '.remove-cart-item', function(e) {
                e.preventDefault();
                e.stopPropagation();

                var $thisbutton = $(this);
                var cart_item_key = $thisbutton.data('cart_item_key');
                var $form = $('form.checkout');

                blockUI($form);

                $.ajax({
                    type: 'POST',
                    url: wc_checkout_params.ajax_url,
                    data: {
                        action: 'sab_remove_cart_item',
                        cart_item_key: cart_item_key,
                    },
                    success: function(response) {
                        if (response.success) {
                            if (response.data.fragments) {
                                $.each(response.data.fragments, function(key, value) {
                                    $(key).replaceWith(value);
                                });
                            }

                            $(document.body).trigger('update_checkout');

                            if (response.data.is_empty) {
                                window.location.href = response.data.home_url;
                            }

                            unblockUI($form);
                        }
                    },
                    error: function() {
                        unblockUI($form);
                        console.log('Error removing item');
                    }
                });
            });
        });
        </script>
        <?php }
}
add_action("wp_footer", "sab_checkout_scripts");

//Booked Appointments
function sab_get_booked_appointments()
{
    if (isset($_POST["doctor_id"])) {
        $doctor_id = intval($_POST["doctor_id"]);

        global $wpdb;
        $appointments_table = $wpdb->prefix . "sab_appointments";
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT day, time FROM $appointments_table WHERE doctor_id = %d",
                $doctor_id
            )
        );
        if (!empty($results)) {
            $booked_appointments = [];
            foreach ($results as $appointment) {
                $booked_appointments[] = [
                    "day" => $appointment->day,
                    "time" => $appointment->time,
                ];
            }
            wp_send_json_success($booked_appointments);
        } else {
            wp_send_json_success([]);
        }
    } else {
        wp_send_json_error("doctor_id is missing");
    }
}
add_action(
    "wp_ajax_sab_get_booked_appointments",
    "sab_get_booked_appointments"
);
add_action(
    "wp_ajax_nopriv_sab_get_booked_appointments",
    "sab_get_booked_appointments"
);

/** Delete Product After Order **/
add_action(
    "woocommerce_order_status_processing",
    "delete_virtual_product_after_payment"
);
add_action(
    "woocommerce_order_status_on-hold",
    "delete_virtual_product_after_payment"
);
add_action(
    "woocommerce_order_status_pending",
    "delete_virtual_product_after_payment"
);
add_action(
    "woocommerce_order_status_completed",
    "delete_virtual_product_after_payment"
);

function delete_virtual_product_after_payment($order_id) {
    $order = wc_get_order($order_id);
    foreach ($order->get_items() as $item_id => $item) {
        $product = $item->get_product();
        if ($product && $product->is_virtual() && $product->get_meta('is_appointment_product') === 'true') {
            $product_id = $product->get_id();
            wp_delete_post($product_id, true);
        }
    }
}

// send for 24 hours
function sab_send_reminder_24h($appointment_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_appointments';
    $appointment = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $appointment_id));

    if (!$appointment) return;

    $service_name = $wpdb->get_var($wpdb->prepare("SELECT name FROM {$wpdb->prefix}sab_services WHERE id = %d", $appointment->service_id));
    $doctor_name = $wpdb->get_var($wpdb->prepare("SELECT name FROM {$wpdb->prefix}sab_doctors WHERE id = %d", $appointment->doctor_id));

    $day_name = jdate("l", strtotime($appointment->day));
    $day_number = jdate("j", strtotime($appointment->day));
    $month_name = jdate("F", strtotime($appointment->day));
    $year = jdate("Y", strtotime($appointment->day));
    $formatted_date = "{$day_name} {$day_number} {$month_name} {$year}";

    $replacements = [
        "{name}" => $appointment->patient_name,
        "{service}" => $service_name ?: 'نامشخص',
        "{doctor}" => $doctor_name ?: 'نامشخص',
        "{date}" => $formatted_date,
        "{time}" => $appointment->time,
        "{mobile}" => $appointment->patient_mobile,
        "{phone}" => $appointment->patient_phone,
    ];

    $sms_username = get_option("sab_sms_username");
    $sms_password = get_option("sab_sms_password");
    $sms_from = get_option("sab_sms_from");
    if (!empty($sms_username) && !empty($sms_password) && !empty($appointment->patient_mobile)) {
        $message = get_option("sab_sms_message_user_24h");
        $use_template = get_option("sab_sms_use_template_user_24h", 0);
        $template_id = get_option("sab_sms_template_id_user_24h");
        if ($use_template && !empty($template_id)) {
            send_sms_with_template($sms_username, $sms_password, $appointment->patient_mobile, $template_id, $message, $replacements);
        } else {
            send_sms_regular($sms_username, $sms_password, $sms_from, $appointment->patient_mobile, $message, $replacements);
        }
    }

    $ippanel_username = get_option("sab_ippanel_username");
    $ippanel_password = get_option("sab_ippanel_password");
    $ippanel_from = get_option("sab_ippanel_from");
    if (!empty($ippanel_username) && !empty($ippanel_password) && !empty($ippanel_from) && !empty($appointment->patient_mobile)) {
        $message = get_option("sab_ippanel_message_user_24h");
        send_faraz_sms("https://ippanel.com/services.jspd", $ippanel_username, $ippanel_password, $ippanel_from, $appointment->patient_mobile, $message, $replacements);
    }
}
add_action('sab_send_reminder_24h', 'sab_send_reminder_24h');

// send for 2 hours
function sab_send_reminder_2h($appointment_id) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_appointments';
    $appointment = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $appointment_id));

    if (!$appointment) return;

    $service_name = $wpdb->get_var($wpdb->prepare("SELECT name FROM {$wpdb->prefix}sab_services WHERE id = %d", $appointment->service_id));
    $doctor_name = $wpdb->get_var($wpdb->prepare("SELECT name FROM {$wpdb->prefix}sab_doctors WHERE id = %d", $appointment->doctor_id));

    $day_name = jdate("l", strtotime($appointment->day));
    $day_number = jdate("j", strtotime($appointment->day));
    $month_name = jdate("F", strtotime($appointment->day));
    $year = jdate("Y", strtotime($appointment->day));
    $formatted_date = "{$day_name} {$day_number} {$month_name} {$year}";

    $replacements = [
        "{name}" => $appointment->patient_name,
        "{service}" => $service_name ?: 'نامشخص',
        "{doctor}" => $doctor_name ?: 'نامشخص',
        "{date}" => $formatted_date,
        "{time}" => $appointment->time,
        "{mobile}" => $appointment->patient_mobile,
        "{phone}" => $appointment->patient_phone,
    ];

    $sms_username = get_option("sab_sms_username");
    $sms_password = get_option("sab_sms_password");
    $sms_from = get_option("sab_sms_from");
    if (!empty($sms_username) && !empty($sms_password) && !empty($appointment->patient_mobile)) {
        $message = get_option("sab_sms_message_user_2h");
        $use_template = get_option("sab_sms_use_template_user_2h", 0);
        $template_id = get_option("sab_sms_template_id_user_2h");
        if ($use_template && !empty($template_id)) {
            send_sms_with_template($sms_username, $sms_password, $appointment->patient_mobile, $template_id, $message, $replacements);
        } else {
            send_sms_regular($sms_username, $sms_password, $sms_from, $appointment->patient_mobile, $message, $replacements);
        }
    }

    $ippanel_username = get_option("sab_ippanel_username");
    $ippanel_password = get_option("sab_ippanel_password");
    $ippanel_from = get_option("sab_ippanel_from");
    if (!empty($ippanel_username) && !empty($ippanel_password) && !empty($ippanel_from) && !empty($appointment->patient_mobile)) {
        $message = get_option("sab_ippanel_message_user_2h");
        send_faraz_sms("https://ippanel.com/services.jspd", $ippanel_username, $ippanel_password, $ippanel_from, $appointment->patient_mobile, $message, $replacements);
    }
}
add_action('sab_send_reminder_2h', 'sab_send_reminder_2h');
?>