<?php

$options = [];

$has_woo = class_exists('WooCommerce');
$woo_rules = [];

$brands_enabled = taxonomy_exists('product_brand');

if ($filter === 'all') {
	$woo_rules = array_merge(
		[
			[
				'id' => 'woo_shop',
				'title' => __('Shop Home', 'noorgfx-component')
			],
	
			[
				'id' => 'single_product',
				'title' => __('Single Product', 'noorgfx-component')
			],
	
			[
				'id' => 'all_product_archives',
				'title' => __('Product Archives', 'noorgfx-component')
			],
	
			[
				'id' => 'all_product_categories',
				'title' => __('Product Categories', 'noorgfx-component')
			],
	
			[
				'id' => 'all_product_attributes',
				'title' => __('Product Attributes', 'noorgfx-component')
			],
		],
		(
			$brands_enabled ? [
				[
					'id' => 'all_product_brands',
					'title' => __('Product Brands', 'noorgfx-component')
				]
			] : []
		),
		[
			[
				'id' => 'all_product_tags',
				'title' => __('Product Tags', 'noorgfx-component')
			],
	
			[
				'id' => 'product_ids',
				'title' => __('Single Product ID', 'noorgfx-component')
			],
	
			[
				'id' => 'product_with_taxonomy_ids',
				'title' => __('Single Product with Taxonomy ID', 'noorgfx-component'),
				'post_type' => 'product'
			],
	
			[
				'id' => 'product_taxonomy_ids',
				'title' => __('Taxonomy ID', 'noorgfx-component')
			],
		]
	);
}

if ($filter === 'product_tabs') {
	$woo_rules = [
		[
			'id' => 'product_ids',
			'title' => __('Product ID', 'noorgfx-component')
		],

		[
			'id' => 'product_with_taxonomy_ids',
			'title' => __('Product with Taxonomy ID', 'noorgfx-component'),
			'post_type' => 'product'
		]
	];
}

if ($filter === 'product_waitlist') {
	$woo_rules = [
		[
			'id' => 'product_ids',
			'title' => __('Product ID', 'noorgfx-component')
		],

		[
			'id' => 'product_with_taxonomy_ids',
			'title' => __('Product with Taxonomy ID', 'noorgfx-component'),
			'post_type' => 'product'
		]
	];
}

if ($has_woo) {
	$options = [
		[
			'title' => __('WooCommerce', 'noorgfx-component'),
			'rules' => $woo_rules
		]
	];
}
