<?php
/**
 * Options for socials widget.
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package Noorgfx
 */

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$options = [
	'title' => [
		'type' => 'hidden',
		'label' => __('Title', 'noorgfx-component'),
		'value' => __('Social Icons', 'noorgfx-component'),
	],

	'socials' => [
		'label' => __('Social Channels', 'noorgfx-component'),
		'type' => 'ct-layers',
		'manageable' => true,
		'desc' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual URL.
			__(
				'Configure the social links in Customizer ➝ General ➝ %sSocial Network Accounts%s.',
				'noorgfx-component'
			),
			noorgfx_safe_sprintf(
				'<a href="%s" data-trigger-section="general:social_section_options" target="_blank">',
				admin_url(
					'/customize.php?autofocus[section]=general&ct_autofocus=general:social_section_options'
				)
			),
			'</a>'
		),

		'value' => [
			[
				'id' => 'facebook',
				'enabled' => true,
			],

			[
				'id' => 'twitter',
				'enabled' => true,
			],

			[
				'id' => 'instagram',
				'enabled' => true,
			],
		],

		'settings' => apply_filters(
			'noorgfx:socials:options:icon',
			noorgfx_get_social_networks_list()
		),
	],

	'link_target' => [
		'type' => 'ct-switch',
		'label' => __('Open links in new tab', 'noorgfx-component'),
		'value' => 'no',
		'divider' => 'top:full',
	],

	'link_nofollow' => [
		'type' => 'ct-switch',
		'label' => __('Set links to nofollow', 'noorgfx-component'),
		'value' => 'no',
	],

	'social_icons_size' => [
		'label' => __( 'Icons Size', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => '',
		'responsive' => false,
		'divider' => 'top:full',
	],

	'items_spacing' => [
		'label' => __( 'Icons Spacing', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => '',
		'responsive' => false,
	],

	'social_icons_color' => [
		'label' => __('Icons Color', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'default',
		'view' => 'text',
		'divider' => 'top:full',
		'setting' => ['transport' => 'postMessage'],
		'choices' => [
			'default' => __('Custom', 'noorgfx-component'),
			'official' => __('Official', 'noorgfx-component'),
		],
	],

	'social_type' => [
		'label' => __('Icons Shape Type', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'simple',
		'view' => 'text',
		'setting' => ['transport' => 'postMessage'],
		'choices' => [
			'simple' => __('None', 'noorgfx-component'),
			'rounded' => __('Rounded', 'noorgfx-component'),
			'square' => __('Square', 'noorgfx-component'),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['social_type' => '!simple'],
		'options' => [
			'social_icons_fill' => [
				'label' => __('Shape Fill Type', 'noorgfx-component'),
				'type' => 'ct-radio',
				'value' => 'outline',
				'view' => 'text',
				'setting' => ['transport' => 'postMessage'],
				'choices' => [
					'outline' => __('Outline', 'noorgfx-component'),
					'solid' => __('Solid', 'noorgfx-component'),
				],
			],
		],
	],
];
