<?php

$is_pro = function_exists('blc_fs') && blc_fs()->can_use_premium_code();

$cpt_choices = [
	'post' => __('Posts', 'noorgfx-component'),
	'page' => __('Pages', 'noorgfx-component'),
];

$cpt_options = [
	'post' => true,
	'page' => true
];

if (class_exists('WooCommerce')) {
	$cpt_choices['product'] = __('Products', 'noorgfx-component');
	$cpt_options['product'] = true;
}

$all_cpts = [];

if (blc_theme_functions()->noorgfx_manager()) {
	$all_cpts = blc_theme_functions()->noorgfx_manager()->post_types->get_supported_post_types();
}

if (function_exists('is_bbpress')) {
	$all_cpts[] = 'forum';
	$all_cpts[] = 'topic';
	$all_cpts[] = 'reply';
}

if (class_exists('Tribe__Events__Main')) {
	$all_cpts[] = 'tribe_events';
}

foreach ($all_cpts as $single_cpt) {
	if (get_post_type_object($single_cpt)) {
		$cpt_choices[$single_cpt] = get_post_type_labels(
			get_post_type_object($single_cpt)
		)->singular_name;
	} else {
		$cpt_choices[$single_cpt] = ucfirst($single_cpt);
	}

	$cpt_options[$single_cpt] = false;
}

foreach ($cpt_choices as $cpt => $value) {
	$post_type_object = get_post_type_object($cpt);

	if ($post_type_object && isset($post_type_object->show_in_rest) && $post_type_object->show_in_rest) {
		continue;
	}

	unset($cpt_choices[$cpt]);
	unset($cpt_options[$cpt]);
}

$options = [

	[
		'buttonUseText' => [
			'label' => __( 'Placeholder Text', 'noorgfx-component' ),
			'type' => 'hidden',
			'value' => 'no',
		],

		'buttonPosition' => [
			'label' => __( 'Placeholder Text', 'noorgfx-component' ),
			'type' => 'hidden',
			'value' => 'inside',
		],

		'search_box_button_text' => [
			'label' => __( 'Button Text', 'noorgfx-component' ),
			'type' => 'hidden',
			'value' => __( 'Search', 'noorgfx-component' ),
		],

		'search_box_placeholder' => [
			'label' => __( 'Placeholder Text', 'noorgfx-component' ),
			'type' => 'hidden',
			'value' => __( 'Search', 'noorgfx-component' ),
		],

		'searchBoxHeight' => [
			'label' => __( 'Input Height', 'noorgfx-component' ),
			'type' => 'ct-slider',
			'min' => 40,
			'max' => 80,
			'value' => '',
			'responsive' => false,
			'divider' => 'top:full',
			'setting' => [ 'transport' => 'postMessage' ],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'buttonUseText' => 'no' ],
			'options' => $is_pro ? [
				'icon' => [
					'type' => 'icon-picker',
					'label' => __('Icon', 'noorgfx-component'),
					'design' => 'inline',
					'divider' => 'top:full',
					'value' => [
						'icon' => 'blc blc-search'
					]
				],
			] : []
		],

		'enable_live_results' => [
			'label' => __( 'Live Results', 'noorgfx-component' ),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'enable_live_results' => 'yes' ],
			'options' => [

				'live_results_images' => [
					'label' => __( 'Live Results Images', 'noorgfx-component' ),
					'type' => 'ct-switch',
					'value' => 'yes',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'search_through/product' => true ],
					'options' => [
						'searchProductPrice' => [
							'label' => __( 'Live Results Product Price', 'noorgfx-component' ),
							'type' => 'ct-switch',
							'value' => 'no',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'searchProductStatus' => [
							'label' => __( 'Live Results Product Status', 'noorgfx-component' ),
							'type' => 'ct-switch',
							'value' => 'no',
							'setting' => [ 'transport' => 'postMessage' ],
						],
					]
				],

			],
		],

		'has_taxonomy_filter' => [
			'label' => __( 'Taxonomy Filter', 'noorgfx-component' ),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
		],

		'taxonomy_filter_label' => [
			'label' => __( 'Placeholder Text', 'noorgfx-component' ),
			'type' => 'hidden',
			'value' => __('Select Category', 'noorgfx-component')
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'has_taxonomy_filter' => 'yes' ],
			'options' => [

				'taxonomy_filter_visibility' => [
					'label' => __( 'Filter Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					// 'allow_empty' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => false,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

				'has_taxonomy_children' => [
					'label' => __( 'Taxonomy Children', 'noorgfx-component' ),
					'type' => 'ct-switch',
					'value' => 'no',
					// 'divider' => 'top',
				],
			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __('Search Through Criteria', 'noorgfx-component'),
			'attr' => ['class' => 'components-base-control ct-title'],
			'desc' => __(
				'Chose in which post types do you want to perform searches.',
				'noorgfx-component'
			)
		],

		'search_through' => [
			'label' => false,
			'type' => 'ct-checkboxes',
			'attr' => ['data-columns' => '2'],
			'disableRevertButton' => true,
			'choices' => noorgfx_ordered_keys($cpt_choices),
			'value' => $cpt_options
		],
	],

	$is_pro ? [
		'search_through_taxonomy' => [
			'label' => __('Search Through Taxonomies', 'noorgfx-component'),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
			'desc' => __('Search through taxonomies from selected custom post types.', 'noorgfx-component'),
		]
	] : []

];
