<?php
/**
 * Contact Info widget
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */
$is_pro = function_exists('blc_fs') && blc_fs()->can_use_premium_code();

$visibility_option = [
	'visibility' => [
		'label' => __( 'Element Visibility', 'noorgfx-component' ),
		'type' => 'ct-visibility',
		'design' => 'block',
		// 'allow_empty' => true,
		'value' => noorgfx_default_responsive_value([
			'desktop' => true,
			'tablet' => true,
			'mobile' => true,
		]),

		'choices' => noorgfx_ordered_keys([
			'desktop' => __( 'Desktop', 'noorgfx-component' ),
			'tablet' => __( 'Tablet', 'noorgfx-component' ),
			'mobile' => __( 'Mobile', 'noorgfx-component' ),
		]),
	],
];

$options = [
	'title' => [
		'type' => 'hidden',
		'label' => __('Title', 'noorgfx-component'),
		'value' => __('Contact Info', 'noorgfx-component'),
	],

	'contact_text' => [
		'label' => __('Text', 'noorgfx-component'),
		'type' => 'hidden',
	],

	'contact_information' => [
		'label' => __('Contact Information', 'noorgfx-component'),
		'type' => 'ct-layers',
		'manageable' => true,
		'value' => [
			[
				'id' => 'address',
				'enabled' => true,
				'title' => __('Address:', 'noorgfx-component'),
				'content' => 'خیابان یکم پلاک دوم',
				'link' => '',
			],

			[
				'id' => 'phone',
				'enabled' => true,
				'title' => __('Phone:', 'noorgfx-component'),
				'content' => '021-12345678',
				'link' => 'tel:021-12345678',
			],

			[
				'id' => 'mobile',
				'enabled' => true,
				'title' => __('Mobile:', 'noorgfx-component'),
				'content' => '021-12345678',
				'link' => 'tel:021-12345678',
			],
		],

		'settings' => [
			'address' => [
				'label' => __('Address', 'noorgfx-component'),
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Address:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => 'خیابان یکم پلاک دوم',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => '',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-map-pin',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],

				'clone' => true,
			],

			'phone' => [
				'label' => __('Phone', 'noorgfx-component'),
				'clone' => true,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Phone:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => '021-12345678',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => 'tel:021-12345678',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-phone',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],

			'mobile' => [
				'label' => __('Mobile', 'noorgfx-component'),
				'clone' => true,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Mobile:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => '021-12345678',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => 'tel:021-12345678',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-mobile-phone',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],

			'hours' => [
				'label' => __('Work Hours', 'noorgfx-component'),
				'clone' => true,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Opening hours:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => '9AM - 5PM',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => '',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-clock',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],

			'fax' => [
				'label' => __('Fax', 'noorgfx-component'),
				'clone' => true,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Fax:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => '021-12345678',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => 'tel:021-12345678',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-fax',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],

			'email' => [
				'label' => __('Email', 'noorgfx-component'),
				'clone' => 2,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Email:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => 'contact@yourwebsite.com',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => 'mailto:contact@yourwebsite.com',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-email',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],

			'website' => [
				'label' => __('Website', 'noorgfx-component'),
				'clone' => true,
				'options' => [
					[
						'title' => [
							'type' => 'text',
							'label' => __('Title', 'noorgfx-component'),
							'value' => __('Website:', 'noorgfx-component'),
							'design' => 'block',
						],

						'content' => [
							'type' => 'text',
							'label' => __('Content', 'noorgfx-component'),
							'value' => '#',
							'design' => 'block',
						],

						'link' => [
							'type' => 'text',
							'label' => __('Link (optional)', 'noorgfx-component'),
							'value' => 'https://#',
							'design' => 'block',
						],
					],

					$is_pro
						? [
							'icon_source' => [
								'label' => __('Icon Source', 'noorgfx-component'),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'setting' => ['transport' => 'postMessage'],
								'choices' => [
									'default' => __('Default', 'noorgfx-component'),
									'custom' => __('Custom', 'noorgfx-component'),
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['icon_source' => 'custom'],
								'options' => [
									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'block',
										'value' => [
											'icon' => 'blc blc-globe',
										],
									],
								],
							],
						]
						: [],

					$visibility_option
				],
			],
		],
	],

	'contact_link_target' => [
		'type' => 'ct-switch',
		'label' => __('Open link in new tab', 'noorgfx-component'),
		'value' => 'no',
		'divider' => 'top:full'
	],

	'link_nofollow' => [
		'type'  => 'ct-switch',
		'label' => __( 'Set links to nofollow', 'noorgfx-component' ),
		'value' => 'no',
	],

	'link_icons' => [
		'type'  => 'ct-switch',
		'label' => __( 'Link Icons', 'noorgfx-component' ),
		'value' => 'no',
	],

	'contacts_icons_size' => [
		'label' => __( 'Icons Size', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => 20,
		'responsive' => false,
		'divider' => 'top:full',
	],

	'contacts_items_spacing' => [
		'label' => __( 'Items Spacing', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => '',
		'responsive' => false,
	],

	'contacts_icon_shape' => [
		'label' => __('Icons Shape Type', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'rounded',
		'view' => 'text',
		'divider' => 'top:full',
		'setting' => ['transport' => 'postMessage'],
		'choices' => [
			'simple' => __('None', 'noorgfx-component'),
			'rounded' => __('Rounded', 'noorgfx-component'),
			'square' => __('Square', 'noorgfx-component'),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['contacts_icon_shape' => '!simple'],
		'options' => [
			'contacts_icon_fill_type' => [
				'label' => __('Shape Fill Type', 'noorgfx-component'),
				'type' => 'ct-radio',
				'value' => 'outline',
				'view' => 'text',
				'setting' => ['transport' => 'postMessage'],
				'choices' => [
					'outline' => __('Outline', 'noorgfx-component'),
					'solid' => __('Solid', 'noorgfx-component'),
				],
			],
		],
	],

	'contacts_items_direction' => [
		'type' => 'ct-radio',
		'label' => __( 'Items Direction', 'noorgfx-component' ),
		'view' => 'text',
		'design' => 'block',
		'divider' => 'top:full',
		'value' => 'column',
		'choices' => [
			'column' => __( 'Vertical', 'noorgfx-component' ),
			'row' => __( 'Horizontal', 'noorgfx-component' ),
		],
		'setting' => [ 'transport' => 'postMessage' ],
	],
];
