<?php
/**
 * About me widget
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$default_wp_user = '';

if (blc_theme_functions()->noorgfx_manager() !== \Noorgfx\ThemeFunctions::$NON_EXISTING_FUNCTION) {
	$default_wp_user = blc_theme_functions()->noorgfx_manager()
		->entity_id_picker
		->get_default_value([
			'entity' => 'users'
		]);
}


$options = [
	'title' => [
		'type' => 'hidden',
		'label' => __('Title', 'noorgfx-component'),
		'value' => __('About me', 'noorgfx-component'),
		'disableRevertButton' => true,
	],

	'about_source' => [
		'label' => __('User Source', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'from_wp',
		'inline' => true,
		'choices' => [
			'from_wp' => __('Dynamic', 'noorgfx-component'),
			'custom' => __('Custom', 'noorgfx-component'),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['about_source' => 'from_wp'],
		'options' => [
			'wp_user' => [
				'type' => 'ct-entity-picker',
				'label' => __('User', 'noorgfx-component'),
				'entity' => 'users',
				'purpose' => 'default',
				'value' => $default_wp_user,
			],
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['about_source' => 'custom'],
		'options' => [
			'about_avatar' => [
				'label' => __('Image', 'noorgfx-component'),
				'type' => 'ct-image-uploader',
				'value' => ['attachment_id' => null],
				'attr' => ['data-type' => 'no-frame'],
				'emptyLabel' => __('Select Image', 'noorgfx-component'),
				'filledLabel' => __('Change Image', 'noorgfx-component'),
			],

			'about_name' => [
				'label' => __('Name', 'noorgfx-component'),
				'type' => 'hidden',
				'value' => 'John Doe',
			],

			'about_text' => [
				'label' => __('Description', 'noorgfx-component'),
				'type' => 'hidden',
				'value' => 'Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliqua tincidunt tortor aliquam.',
				'desc' => __(
					'You can add here some arbitrary HTML code.',
					'noorgfx-component'
				),

				'mediaButtons' => false,
				'tinymce' => [
					'toolbar1' => 'bold,italic,link,undo,redo',
				],
			],
		],
	],

	'about_avatar_size' => [
		'label' => __('Image Size', 'noorgfx-component'),
		'type' => 'ct-select',
		'value' => 'small',
		'purpose' => 'default',
		'choices' => [
			'small' => __('Small', 'noorgfx-component'),
			'medium' => __('Medium', 'noorgfx-component'),
			'large' => __('Large', 'noorgfx-component'),
		],
	],

	'avatar_shape' => [
		'label' => __('Image Shape', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'rounded',
		'inline' => true,
		'choices' => [
			'rounded' => __('Rounded', 'noorgfx-component'),
			'square' => __('Square', 'noorgfx-component'),
		],
	],

	'about_alignment' => [
		'type' => 'ct-radio',
		'label' => __('Alignment', 'noorgfx-component'),
		'value' => 'center',
		'divider' => 'top:full',
		'attr' => ['data-type' => 'alignment'],
		'choices' => [
			'left' =>
				'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M4 19.8h8.9v-1.5H4v1.5zm8.9-15.6H4v1.5h8.9V4.2zm-8.9 7v1.5h16v-1.5H4z"></path></svg>',
			'center' =>
				'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M16.4 4.2H7.6v1.5h8.9V4.2zM4 11.2v1.5h16v-1.5H4zm3.6 8.6h8.9v-1.5H7.6v1.5z"></path></svg>',
			'right' =>
				'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M11.1 19.8H20v-1.5h-8.9v1.5zm0-15.6v1.5H20V4.2h-8.9zM4 12.8h16v-1.5H4v1.5z"></path></svg>',
		],
	],

	'about_socials' => [
		'label' => __('Social Channels', 'noorgfx-component'),
		'type' => 'ct-layers',
		'divider' => 'top:full',
		'manageable' => true,
		'desc' => noorgfx_safe_sprintf(
			__('You can configure social URLs in %s.', 'noorgfx-component'),
			noorgfx_safe_sprintf(
				'<a href="%s" target="_blank">%s</a>',
				admin_url('/customize.php?autofocus[section]=social_accounts'),
				__('Customizer', 'noorgfx-component')
			)
		),
		'value' => [
			[
				'id' => 'facebook',
				'enabled' => true,
			],

			[
				'id' => 'twitter',
				'enabled' => true,
			],

			[
				'id' => 'instagram',
				'enabled' => true,
			],
		],

		'settings' => apply_filters(
			'noorgfx:socials:options:icon',
			noorgfx_get_social_networks_list()
		),
	],

	'link_target' => [
		'type' => 'ct-switch',
		'label' => __('Open links in new tab', 'noorgfx-component'),
		'value' => 'no',
		'divider' => 'top:full',
	],

	'link_nofollow' => [
		'type' => 'ct-switch',
		'label' => __('Set links to nofollow', 'noorgfx-component'),
		'value' => 'no',
	],

	'about_social_icons_size' => [
		'label' => __( 'Icons Size', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => '',
		'responsive' => false,
		'divider' => 'top:full',
	],

	'about_items_spacing' => [
		'label' => __( 'Items Spacing', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 5,
		'max' => 50,
		'value' => '',
		'responsive' => false,
	],

	'about_social_icons_color' => [
		'label' => __('Icons Color', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'default',
		'view' => 'text',
		'divider' => 'top:full',
		'setting' => ['transport' => 'postMessage'],
		'choices' => [
			'default' => __('Custom', 'noorgfx-component'),
			'official' => __('Official', 'noorgfx-component'),
		],
	],

	'about_social_type' => [
		'label' => __('Icons Shape Type', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'rounded',
		'choices' => [
			'simple' => __('None', 'noorgfx-component'),
			'rounded' => __('Rounded', 'noorgfx-component'),
			'square' => __('Square', 'noorgfx-component'),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['about_social_type' => '!simple'],
		'options' => [
			'about_social_icons_fill' => [
				'label' => __('Shape Fill Type', 'noorgfx-component'),
				'type' => 'ct-radio',
				'value' => 'outline',
				'choices' => [
					'outline' => __('Outline', 'noorgfx-component'),
					'solid' => __('Solid', 'noorgfx-component'),
				],
			],
		],
	],
];
