<?php

$options = [
	//  translators: This is a brand name. Preferably to not be translated
	'title' => _x('Cookies Consent', 'Extension Brand Name', 'noorgfx-component'),
	'container' => [ 'priority' => 8 ],
	'options' => [

		'cookie_consent_section_options' => [
			'type' => 'ct-options',
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'cookie_consent_type' => [
							'label' => false,
							'type' => 'ct-image-picker',
							'value' => 'type-1',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [

								'type-1' => [
									'src'   => NOORGFX_URL . 'framework/extensions/cookies-consent/static/images/type-1.svg',
									'title' => __( 'Type 1', 'noorgfx-component' ),
								],

								'type-2' => [
									'src'   => NOORGFX_URL . 'framework/extensions/cookies-consent/static/images/type-2.svg',
									'title' => __( 'Type 2', 'noorgfx-component' ),
								],

							],
						],

						'cookie_consent_period' => [
							'label' => __('Cookie period', 'noorgfx-component'),
							'type' => 'ct-select',
							'value' => 'forever',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => noorgfx_ordered_keys(

								[
									'onehour' => __( 'One hour', 'noorgfx-component' ),
									'oneday' => __( 'One day', 'noorgfx-component' ),
									'oneweek' => __( 'One week', 'noorgfx-component' ),
									'onemonth' => __( 'One month', 'noorgfx-component' ),
									'threemonths' => __( 'Three months', 'noorgfx-component' ),
									'sixmonths' => __( 'Six months', 'noorgfx-component' ),
									'oneyear' => __( 'One year', 'noorgfx-component' ),
									'forever' => __('Forever', 'noorgfx-component')
								]

							),
						],

						'cookie_consent_content' => [
							'label' => __( 'Content', 'noorgfx-component' ),
							'type' => 'wp-editor',
							'value' => __('We use cookies to ensure that we give you the best experience on our website.', 'noorgfx-component'),
							'disableRevertButton' => true,
							'setting' => [ 'transport' => 'postMessage' ],

							'quicktags' => false,
							'mediaButtons' => false,
							'tinymce' => [
								'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
							],
						],

						'cookie_consent_button_text' => [
							'label' => __( 'Accept Button text', 'noorgfx-component' ),
							'type' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'value' => __('Accept', 'noorgfx-component'),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'cookie_consent_decline_button_text' => [
							'label' => __( 'Decline Button text', 'noorgfx-component' ),
							'type' => 'text',
							'design' => 'block',
							'value' => __('Decline', 'noorgfx-component'),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'cookie_consent_type' => 'type-1' ],
							'options' => [

								'cookieMaxWidth' => [
									'label' => __( 'Maximum Width', 'noorgfx-component' ),
									'type' => 'ct-slider',
									'value' => 400,
									'min' => 200,
									'max' => 500,
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Forms Cookies Content', 'noorgfx-component' ),
						],

						'forms_cookie_consent_content' => [
							'label' => false,
							'type' => 'wp-editor',
							'value' => blc_safe_sprintf(
								__('I accept the %sPrivacy Policy%s*', 'noorgfx-component'),
								'<a href="' . get_privacy_policy_url() . '">',
								'</a>'
							),
							'desc' => __( 'This text will appear under each comment form and subscribe form.', 'noorgfx-component' ),
							// 'attr' => [ 'data-height' => 'heading-label' ],
							'disableRevertButton' => true,
							'setting' => [ 'transport' => 'postMessage' ],

							'quicktags' => false,
							'mediaButtons' => false,
							'tinymce' => [
								'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
								'forced_root_block' => '',
								'force_br_newlines' => true,
								'force_p_newlines' => false
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'cookieContentColor' => [
							'label' => __( 'Text Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-link-hover-color)'
								],
							],
						],

						'cookieBackground' => [
							'label' => __( 'Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => 'var(--theme-palette-color-8)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Accept Button', 'noorgfx-component' ),
						],

						'cookieButtonText' => [
							'label' => __( 'Font Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							// 'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-text-initial-color)',
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-text-hover-color)',
								],
							],
						],

						'cookieButtonBackground' => [
							'label' => __( 'Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							// 'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-background-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-background-hover-color)'
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Decline Button', 'noorgfx-component' ),
						],

						'cookieDeclineButtonText' => [
							'label' => __( 'Font Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							// 'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'var(--theme-palette-color-3)',
								],

								'hover' => [
									'color' => 'var(--theme-palette-color-3)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],
							],
						],

						'cookieDeclineButtonBackground' => [
							'label' => __( 'Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							// 'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'rgba(224, 229, 235, 0.6)',
								],

								'hover' => [
									'color' => 'rgba(224, 229, 235, 1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],
							],
						],

					],
				],

			],
		],
	],
];
