<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {	exit;}
class Step_Flow extends Widget_Base {
	public function get_name() {
		return 'nour-step-flow';
	}
	public function get_title() {
		return __( 'مراحل توسعه', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-step-flow nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'step', 'steps', 'flow', 'flows' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_news_ticker',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'step_flow_icon',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => array(
					'value'   => 'fas fa-check',
					'library' => 'fa-solid',
				),
			)
		);

		$this->add_control(
			'step_flow_title',
			array(
				'label'       => __( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'عنوان مرحله', 'nour-elementor-addons' ),
				'placeholder' => __( 'یک عنوان برای این مرحله بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'step_flow_description',
			array(
				'label'       => esc_html__( 'توضیحات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::WYSIWYG,
				'rows'        => 5,
				'placeholder' => esc_html__( 'توضیحات در مورد این مرحله را بنویسید', 'nour-elementor-addons' ),
				'default'     => __( 'شما در زندگی آنچه را که میخواهید بدست نمی آورید شما فقط آنچه که هستید را بدست می آورید.', 'nour-elementor-addons' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'step_flow_badge_text',
			array(
				'label'       => __( 'برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'یک متن بنویسید', 'nour-elementor-addons' ),
				'default'     => __( '01', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'step_flow_separator',
			array(
				'label'        => __( 'اتصال دهنده', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => __( 'yes', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->add_responsive_control(
			'general_align',
			array(
				'label'        => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::CHOOSE,
				'separator'    => 'before',
				'options'      => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'prefix_class' => 'nour-content-align%s',
				'default'      => __( 'center', 'nour-elementor-addons' ),
				'selectors'    => array(
					'{{WRAPPER}} .nour-step-flow-wrapper' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'step_flow_icon_style',
			array(
				'label' => __( 'رسانه', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'icon_size',
			array(
				'label'      => __( 'اندازه رسانه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 30,

				),
				'selectors'  => array(
					'{{WRAPPER}}'                          => '--nour-step-flow-icon-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-icon > i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-icon > svg' => 'width: {{SIZE}}{{UNIT}}; height:auto;',
				),
			)
		);

		$this->add_responsive_control(
			'icon_box_icon',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 200,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 50,

				),
				'selectors'  => array(
					'{{WRAPPER}}'                      => '--nour-step-flow-icon-padding: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-icon' => 'padding: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'icon_margin_bottom',
			array(
				'label'      => __( 'فاصله پایینی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 20,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-icon ' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-icon > i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-step-flow-icon > svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'icon_content_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-icon',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'icon_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-icon',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'icon_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-icon',
			)
		);

		$this->add_responsive_control(
			'icon_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_step_flow_title_style',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'step_flow_title!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-title',
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'title_text_shadow',
				'label'    => __( 'سایه متن', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-title',
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_step_flow_description_style',
			array(
				'label'     => __( 'توضیحات', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'step_flow_description!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'description_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-description, {{WRAPPER}} .nour-step-flow-description > *',
			)
		);

		$this->add_control(
			'description_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-description, {{WRAPPER}} .nour-step-flow-description > *' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'description_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_step_flow_separator_style',
			array(
				'label'     => __( 'اتصال دهنده', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'step_flow_separator' => 'yes',
				),
			)
		);

		$this->add_control(
			'separator_layout_style',
			array(
				'label'   => __( 'طرح', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'line',
				'options' => array(
					'line'       => __( 'خط', 'nour-elementor-addons' ),
					'line-arrow' => __( 'خط و پیکان', 'nour-elementor-addons' ),
					'arrow'      => __( 'پیکان', 'nour-elementor-addons' ),
					'circle'     => __( 'دایره ای', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'separator_border_type',
			array(
				'label'     => __( 'نوع لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'solid',
				'options'   => array(
					'solid'  => __( 'جامد', 'nour-elementor-addons' ),
					'dotted' => __( 'نقطه چین', 'nour-elementor-addons' ),
					'dashed' => __( 'خط چین', 'nour-elementor-addons' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-line,
					{{WRAPPER}} .nour-step-flow-line-arrow,
					{{WRAPPER}} .nour-step-flow-circle,
					{{WRAPPER}} .nour-step-flow-arrow' => 'border-top-style: {{VALUE}}',
					'{{WRAPPER}} .nour-step-flow-line-arrow::after,
					{{WRAPPER}} .nour-step-flow-arrow::after' => 'border-top-style: {{VALUE}};border-right-style: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'separator_transform_toggle',
			array(
				'label'        => __( 'مقیاس', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_responsive_control(
			'separator_offset_y',
			array(
				'label'      => __( 'فاصله بالا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'condition'  => array(
					'separator_transform_toggle' => 'yes',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-line-arrow,
					{{WRAPPER}} .nour-step-flow-arrow,
					{{WRAPPER}} .nour-step-flow-circle,
					{{WRAPPER}} .nour-step-flow-line' => 'top:{{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'separator_offset_x',
			array(
				'label'      => __( 'فاصله چپ', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 20,
				),
				'condition'  => array(
					'separator_transform_toggle' => 'yes',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-line-arrow,
					{{WRAPPER}} .nour-step-flow-arrow,
					{{WRAPPER}} .nour-step-flow-circle,
					{{WRAPPER}} .nour-step-flow-line' => 'left: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}}'                     => '--nour-step-flow-direction-offset-x: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'separator_rotate',
			array(
				'label'          => __( 'چرخش', 'nour-elementor-addons' ),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => array( 'deg' ),
				'default'        => array(
					'unit' => 'deg',
				),
				'tablet_default' => array(
					'unit' => 'deg',
				),
				'mobile_default' => array(
					'unit' => 'deg',
				),
				'range'          => array(
					'deg' => array(
						'min' => 0,
						'max' => 360,
					),
				),
				'condition'      => array(
					'separator_transform_toggle' => 'yes',
				),
				'selectors'      => array(
					'{{WRAPPER}}' => '--nour-step-flow-direction-angle: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_popover();

		$this->add_responsive_control(
			'separator_width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 500,
						'step' => 1,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 100,

				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-line, 
					 {{WRAPPER}} .nour-step-flow-circle,
					 {{WRAPPER}} .nour-step-flow-line-arrow' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'separator_layout_style' => array( 'line', 'line-arrow', 'circle' ),
				),
			)
		);

		$this->add_responsive_control(
			'separator_size',
			array(
				'label'      => __( 'ضخامت', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 2,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-line'   => 'border-top-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-line-arrow' => 'border-top-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-line-arrow:after' => 'border-width: {{SIZE}}{{UNIT}}; width:calc(15px * {{SIZE}} / 2); height:calc(15px * {{SIZE}} / 2); top:calc(-17px * {{SIZE}} / 4); right:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-arrow:after' => 'border-width: {{SIZE}}{{UNIT}}; width:calc(15px * {{SIZE}} / 2); height:calc(15px * {{SIZE}} / 2); top: calc(-15px * {{SIZE}} / 4);',
					'{{WRAPPER}} .nour-step-flow-circle' => 'border-top-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-step-flow-circle:after' => 'border-width: {{SIZE}}{{UNIT}}; width:calc(15px * {{SIZE}} / 2); height:calc(15px * {{SIZE}} / 2); top:calc(-2px * {{SIZE}} / 4);',
				),
			)
		);

		$this->add_responsive_control(
			'separator_margin-left',
			array(
				'label'      => __( 'فاصله', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-line,
					 {{WRAPPER}} .nour-step-flow-line-arrow,
					 {{WRAPPER}} .nour-step-flow-arrow' => 'margin-left: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'separator_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-line,
					 {{WRAPPER}} .nour-step-flow-line-arrow,
					 {{WRAPPER}} .nour-step-flow-line-arrow::after,
					 {{WRAPPER}} .nour-step-flow-circle,
					 {{WRAPPER}} .nour-step-flow-arrow::after' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'separator_circle_color',
			array(
				'label'     => __( 'رنگ دایره', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-circle::after' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'separator_layout_style' => 'circle',
				),
			)
		);

		$this->add_control(
			'separator_hide_on',
			array(
				'label'   => __( 'مخفی در', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => array(
					'none'   => __( 'هیچ', 'nour-elementor-addons' ),
					'tablet' => __( 'موبایل و تبلت', 'nour-elementor-addons' ),
					'mobile' => __( 'فقط موبایل', 'nour-elementor-addons' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_step_flow_badge_style',
			array(
				'label'     => __( 'برچسب', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'step_flow_badge_text!' => '',
				),
			)
		);

		$this->add_control(
			'badge_position',
			array(
				'label'   => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'top-left',
				'options' => array(
					'top-left'      => __( 'بالا چپ', 'nour-elementor-addons' ),
					'top-center'    => __( 'بالا وسط', 'nour-elementor-addons' ),
					'top-right'     => __( 'بالا راست', 'nour-elementor-addons' ),
					'middle-left'   => __( 'مرکز چپ', 'nour-elementor-addons' ),
					'middle-center' => __( 'مراحل وسط', 'nour-elementor-addons' ),
					'middle-right'  => __( 'مرکز راست', 'nour-elementor-addons' ),
					'bottom-left'   => __( 'پایین چپ', 'nour-elementor-addons' ),
					'bottom-center' => __( 'پایین وسط', 'nour-elementor-addons' ),
					'bottom-right'  => __( 'پایین راست', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'badge_offset_toggle',
			array(
				'label'        => __( 'فاصله', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_responsive_control(
			'badge_offset_x',
			array(
				'label'      => __( 'فاصله از چپ', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'default'    => array(
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => - 100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-badge.nour-badge' => '--nour-badge-translate-x: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'badge_offset_toggle' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'badge_offset_y',
			array(
				'label'      => __( 'فاصله بالا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'default'    => array(
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => - 100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-badge.nour-badge' => '--nour-badge-translate-y: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'badge_offset_toggle' => 'yes',
				),
			)
		);
		$this->end_popover();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'badge_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-badge',
			)
		);

		$this->add_control(
			'badge_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-step-flow-badge' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'badge_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-badge',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'badge_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-step-flow-badge',
			)
		);

		$this->add_responsive_control(
			'badge_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'badge_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-step-flow-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'step-flow/layout/frontend.php';
	}
}
