<?php

use Elementor\Icons_Manager;

$layout = ( 'none' !== $settings['separator_layout_style'] ) ? ' nour-step-' . $settings['separator_layout_style'] : '';
?>

<!-- Step Flow -->
<div class="nour-step-flow-wrapper <?php echo esc_attr( $layout ); ?> nour-step-flow-separator-disable-<?php echo esc_attr( $settings['separator_hide_on'] ); ?>">
	<div class="nour-step-flow-icon">

		<?php
		if ( $settings['step_flow_icon'] ) {
			Icons_Manager::render_icon( $settings['step_flow_icon'], array( 'aria-hidden' => 'true' ) );
		}
		?>

		<!-- Separator -->
		<?php if ( 'yes' === $settings['step_flow_separator'] ) { ?>
			<span class="nour-step-flow-<?php echo esc_attr( $settings['separator_layout_style'] ); ?>"></span>
		<?php } ?>

		<!-- Badge -->
		<?php if ( $settings['step_flow_badge_text'] ) { ?>
			<span class="nour-step-flow-badge nour-badge nour-badge-<?php echo esc_attr( $settings['badge_position'] ); ?>">
				<?php echo esc_html( $settings['step_flow_badge_text'] ); ?>
			</span>
		<?php } ?>

	</div>
	<div class="nour-step-flow-content">
		<!-- Title -->
		<?php if ( $settings['step_flow_title'] ) { ?>
			<h2 class="nour-step-flow-title"><?php echo esc_html( $settings['step_flow_title'] ); ?></h2>
		<?php } ?>

		<!-- Description -->
		<?php if ( $settings['step_flow_description'] ) { ?>
			<div class="nour-step-flow-description"><?php nour_elementor_kses( $settings['step_flow_description'] ); ?></div>
		<?php } ?>

	</div>
</div>
