<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use WP_Query;
use NourElementorAddons\Control\Nour_Elementor_Group_Control_Foreground;
if ( ! defined( 'ABSPATH' ) ) {	exit; }
class Post_Grid extends Widget_Base {
	public function get_name() {
		return 'nour-post-grid';
	}
	public function get_title() {
		return __( 'شبکه پست', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-post-grid nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'post', 'grid', 'blog', 'posts', 'query' );
	}
	public function get_style_depends() {

		return array( 'cubeportfolio' );
	}
	public function get_script_depends() {
		return array( 'cubeportfolio' );
	}
	protected function register_controls() {
		$post_types                   = nour_elementor_get_post_types();
		$post_types['by_id']          = __( 'انتخاب دستی', 'nour-elementor-addons' );
		$post_types['source_dynamic'] = __( 'پویا', 'nour-elementor-addons' );
		$taxonomies = get_taxonomies( array(), 'objects' );
		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'layout',
			array(
				'label'   => __( 'طرح بندی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1'  => __( 'طرح بندی 1', 'nour-elementor-addons' ),
					'2'  => __( 'طرح بندی 2', 'nour-elementor-addons' ),
					'3'  => __( 'طرح بندی 3', 'nour-elementor-addons' ),
					'4'  => __( 'طرح بندی 4', 'nour-elementor-addons' ),
					'5'  => __( 'طرح بندی 5', 'nour-elementor-addons' ),
					'6'  => __( 'طرح بندی 6', 'nour-elementor-addons' ),
					'7'  => __( 'طرح بندی 7', 'nour-elementor-addons' ),
					'8'  => __( 'طرح بندی 8', 'nour-elementor-addons' ),
					'9'  => __( 'طرح بندی 9', 'nour-elementor-addons' ),
					'10' => __( 'طرح بندی 10', 'nour-elementor-addons' ),
				),
			)
		);
		$this->add_responsive_control(
			'column_grid',
			array(
				'label'              => __( 'ستون ها', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'desktop_default'    => '3',
				'tablet_default'     => '2',
				'mobile_default'     => '1',
				'options'            => array(
					'1' => __( '1', 'nour-elementor-addons' ),
					'2' => __( '2', 'nour-elementor-addons' ),
					'3' => __( '3', 'nour-elementor-addons' ),
					'4' => __( '4', 'nour-elementor-addons' ),
					'5' => __( '5', 'nour-elementor-addons' ),
					'6' => __( '6', 'nour-elementor-addons' ),
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);
		$this->add_control(
			'show_image',
			array(
				'label'        => __( 'نمایش تصویر', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'    => 'before',
			)
		);
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'thumbnail',
				'exclude'   => array( 'custom' ),
				'default'   => 'medium',
				'condition' => array(
					'show_image' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_content',
			array(
				'label'        => __( 'نمایش خلاصه', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'content_length',
			array(
				'label'     => __( 'محدودیت کلمه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 500,
				'step'      => 5,
				'default'   => 10,
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_readmore',
			array(
				'label'        => __( 'نمایش دکمه', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);
		$this->add_control(
			'readmore_text',
			array(
				'label'     => __( 'متن دکمه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'جزئیات بیشتر', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_readmore' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_author',
			array(
				'label'        => __( 'نمایش نویسنده', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'    => 'before',
			)
		);
		$this->add_control(
			'author_title',
			array(
				'label'     => __( 'عنوان نویسنده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'نوشته شده توسط', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_author' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_author_avatar',
			array(
				'label'        => __( 'نمایش آواتار', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'show_author' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_meta',
			array(
				'label'     => __( 'نمایش متا', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT2,
				'multiple'  => true,
				'separator' => 'before',
				'options'   => array(
					'date'     => __( 'تاریخ', 'nour-elementor-addons' ),
					'category' => __( 'دسته بندی', 'nour-elementor-addons' ),
					'comments' => __( 'دیدگاه', 'nour-elementor-addons' ),
				),
				'default'   => array( 'date' ),
			)
		);
		$this->add_control(
			'date_icon',
			array(
				'label'     => __( 'نماد تاریخ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'far fa-calendar',
					'library' => 'regular',
				),
				'condition' => array(
					'show_meta' => 'date',
				),
			)
		);
		$this->add_control(
			'category_icon',
			array(
				'label'     => __( 'نماد دسته', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'far fa-folder',
					'library' => 'regular',
				),
				'condition' => array(
					'show_meta' => 'category',
				),
			)
		);
		$this->add_control(
			'comments_icon',
			array(
				'label'     => __( 'نماد دیدگاه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'far fa-comment-alt',
					'library' => 'regular',
				),
				'condition' => array(
					'show_meta' => 'comments',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_query',
			array(
				'label' => __( 'پرس و جو', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'post_type',
			array(
				'label'   => __( 'منبع', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => $post_types,
				'default' => key( $post_types ),
			)
		);
		$this->add_control(
			'posts_ids',
			array(
				'label'       => __( 'جستجو و انتخاب', 'nour-elementor-addons' ),
				'type'        => 'nour-select',
				'options'     => nour_elementor_get_query_post_list(),
				'label_block' => true,
				'multiple'    => true,
				'source_name' => 'post_type',
				'source_type' => 'any',
				'condition'   => array(
					'post_type' => 'by_id',
				),
			)
		);
		$this->add_control(
			'authors',
			array(
				'label'       => __( 'نویسنده', 'nour-elementor-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'default'     => array(),
				'options'     => nour_elementor_get_authors_list(),
				'condition'   => array(
					'post_type!' => array( 'by_id', 'source_dynamic' ),
				),
			)
		);
		$this->add_control(
			'terms',
			array(
				'label'     => __( 'شروط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->get_taxonomies(),
				'default'   => '',
				'condition' => array(
					'post_type' => array( 'source_dynamic' ),
				),
			)
		);
		foreach ( $taxonomies as $taxonomy => $object ) {
			if ( ! isset( $object->object_type[0] ) || ! in_array( $object->object_type[0], array_keys( $post_types ), true ) ) {
				continue;
			}
			$this->add_control(
				$taxonomy . '_ids',
				array(
					'label'       => $object->label,
					'type'        => 'nour-select',
					'label_block' => true,
					'multiple'    => true,
					'source_name' => 'taxonomy',
					'source_type' => $taxonomy,
					'condition'   => array(
						'post_type' => $object->object_type,
					),
				)
			);
		}
		$this->add_control(
			'post__not_in',
			array(
				'label'       => __( 'مستثنی کردن', 'nour-elementor-addons' ),
				'type'        => 'nour-select',
				'label_block' => true,
				'multiple'    => true,
				'source_name' => 'post_type',
				'source_type' => 'any',
				'condition'   => array(
					'post_type!' => array( 'by_id', 'source_dynamic' ),
				),
			)
		);
		$this->add_control(
			'posts_per_page',
			array(
				'label'     => __( 'تعداد در برگه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
				'condition' => array(
					'post_type!' => array( 'source_dynamic' ),
				),
			)
		);
		$this->add_control(
			'offset',
			array(
				'label'     => __( 'فاصله', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'condition' => array(
					'orderby!'         => 'rand',
					'show_pagination!' => 'yes',
				),
			)
		);
		$this->add_control(
			'orderby',
			array(
				'label'   => __( 'مرتب سازی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => nour_elementor_get_post_orderby_options(),
				'default' => 'date',

			)
		);
		$this->add_control(
			'order',
			array(
				'label'   => __( 'چیدمان', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'asc'  => 'نزولی',
					'desc' => 'سعودی',
				),
				'default' => 'desc',

			)
		);
		$this->add_control(
			'post_only_image',
			array(
				'label'        => __( 'عرض تصویر', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);
		if ( Plugin::$instance->editor->is_edit_mode() ) {
			$this->add_control(
				'_source_dynamic_notice',
				array(
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => sprintf(
						__( 'این گزینه %1$s را به صورت پویا بر اساس حلقه نشان می دهد.', 'nour-elementor-addons' ),
						'<strong>نوشته ها</strong>'
					),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
					'condition'       => array(
						'post_type' => array( 'source_dynamic' ),
					),
				)
			);
		}
		$this->end_controls_section();
		$this->start_controls_section(
			'section_pagination',
			array(
				'label'     => __( 'صفحه بندی', 'nour-elementor-addons' ),
				'condition' => array(
					'terms' => '',
				),
			)
		);
		$this->add_control(
			'show_pagination',
			array(
				'label'        => __( 'نمایش صفحه بندی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);
		$this->add_control(
			'prev_label',
			array(
				'label'     => __( 'برچسب قبلی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'قبلی', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);
		$this->add_control(
			'next_label',
			array(
				'label'     => __( 'برچسب بعدی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'بعدی', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);
		$this->add_control(
			'arrow',
			array(
				'label'     => __( 'نوع پیکان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'fas fa-arrow-left'          => __( 'پیکان', 'nour-elementor-addons' ),
					'fas fa-angle-left'          => __( 'زاویه', 'nour-elementor-addons' ),
					'fas fa-angle-double-left'   => __( 'دوتایی', 'nour-elementor-addons' ),
					'fas fa-chevron-left'        => __( 'شورون', 'nour-elementor-addons' ),
					'fas fa-chevron-circle-left' => __( 'شورون دایره', 'nour-elementor-addons' ),
					'fas fa-caret-left'          => __( 'جعبه', 'nour-elementor-addons' ),
					'xi xi-long-arrow-left'      => __( 'پیکان بلند', 'nour-elementor-addons' ),
					'fas fa-arrow-circle-left'   => __( 'پیکان دایره', 'nour-elementor-addons' ),
				),
				'default'   => 'fas fa-arrow-left',
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_general_style',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'alignment',
			array(
				'label'        => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'prefix_class' => 'nour-post-grid-align%s-',
			)
		);
		$this->add_responsive_control(
			'item_height',
			array(
				'label'              => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px', 'vh' ),
				'default'            => array(
					'unit' => 'px',
					'size' => 400,
				),
				'range'              => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item' => 'height: {{SIZE}}{{UNIT}}',
				),
				'condition'          => array(
					'layout' => array( '2', '6', '8', '9', '10' ),
				),
			)
		);
		$this->add_responsive_control(
			'image_height',
			array(
				'label'              => __( 'ارتفاع تصویر', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px', 'vh' ),
				'range'              => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-image' => 'height: {{SIZE}}{{UNIT}}',
				),
				'condition'          => array(
					'layout!'    => array( '2', '6' ),
					'show_image' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'space_between',
			array(
				'label'              => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'default'            => array(
					'size' => 15,
				),
				'tablet_default'     => array(
					'size' => 15,
				),
				'mobile_default'     => array(
					'size' => 15,
				),
				'range'              => array(
					'px' => array(
						'min' => 0,
						'max' => 500,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'item_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .cbp-item-wrapper',
			)
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'item_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item',
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'item_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .cbp-item-wrapper',
			)
		);
		$this->add_responsive_control(
			'item_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item' => 'overflow:hidden; border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->start_controls_tabs(
			'overlay_style_tabs',
			array(
				'condition' => array(
					'layout!' => array( '8', '10' ),
				),
			)
		);
		$this->start_controls_tab(
			'overlay_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'overlay_color',
			array(
				'label'     => __( 'رنگ همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item .nour-post-grid-image::after' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'overlay_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'overlay_hover_color',
			array(
				'label'     => __( 'رنگ همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-item:hover .nour-post-grid-image::after' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_style',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'content_height',
			array(
				'label'              => __( 'حداقل ارتفاع', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px', 'vh' ),
				'range'              => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-post-grid-content' => 'min-height: {{SIZE}}{{UNIT}}',
				),
				'condition'          => array(
					'layout!' => array( '6', '2', '8', '10' ),
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'content_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-content',
				'condition' => array(
					'layout!' => array( '6', '2' ),
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'content_border',
				'selector'  => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-content',
				'condition' => array(
					'layout!' => array( '6', '2' ),
				),
			)
		);
		$this->add_responsive_control(
			'content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout!' => array( '6', '2' ),
				),
			)
		);
		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'heading_title',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-title',
			)
		);
		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-title' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'title_hover_color',
			array(
				'label'     => __( 'رنگ شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-title:hover' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'heading_excerpt',
			array(
				'label'     => __( 'محتوا', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->add_control(
			'excerpt_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-excerpt' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'description_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-excerpt',
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'excerpt_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_meta_style',
			array(
				'label' => __( 'متا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'meta_icon_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 5,
						'max' => 300,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 14,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-meta-date > svg,{{WRAPPER}} .nour-post-grid-meta-date > img' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'meta_font_size',
			array(
				'label'      => __( 'اندازه فونت', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 5,
						'max' => 300,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 14,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-meta-date' => 'font-size: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'meta_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li',
			)
		);
		$this->add_responsive_control(
			'meta_space_between',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-meta-date' => 'grid-gap: {{SIZE}}{{UNIT}}',
				),
			)
		);
		$this->add_control(
			'meta_icon_color',
			array(
				'label'     => __( 'رنگ نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li > i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li > svg' => 'fill: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'meta_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li,{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li a' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'meta_bg_color',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'meta_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li',
			)
		);
		$this->add_responsive_control(
			'meta_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li' => 'overflow:hidden; border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'meta_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'meta_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-meta-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'heading_meta_wrapper',
			array(
				'label'     => __( 'نگهدارنده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => '7',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'meta_wrapper_border',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-layout-7 .nour-post-grid-meta-list',
				'condition' => array(
					'layout' => '7',
				),
			)
		);
		$this->add_responsive_control(
			'meta_wrapper_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-layout-7 .nour-post-grid-meta-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '7',
				),
			)
		);
		$this->add_responsive_control(
			'meta_wrapper_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-layout-7 .nour-post-grid-meta-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '7',
				),
			)
		);
		$this->add_responsive_control(
			'meta_wrapper_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-layout-7 .nour-post-grid-meta-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '7',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_button_style',
			array(
				'label'     => __( 'دکمه', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_readmore' => 'yes',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'button_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-btn',
			)
		);
		$this->start_controls_tabs(
			'button_style_tabs'
		);
		$this->start_controls_tab(
			'button_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'button_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-btn' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'button_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-btn',
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'button_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-btn',
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'button_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'button_hcolor',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-btn:hover,{{WRAPPER}} .nour-post-grid-btn:focus' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'button_hbg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-btn:hover,{{WRAPPER}} .nour-post-grid-btn:focus',
			)
		);
		$this->add_control(
			'button_hborder',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-btn:hover,{{WRAPPER}} .nour-post-grid-btn:focus' => 'border-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'button_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'button_item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'button_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_author_style',
			array(
				'label'     => __( 'نویسنده', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_author' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'avatar_size',
			array(
				'label'       => __( 'اندازه آواتار', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => array( 'px' ),
				'selectors'   => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-author img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-post-grid-layout-4 .nour-post-grid-content'   => 'margin-top: calc({{SIZE}}{{UNIT}} / 2);',
				),
				'condition'   => array(
					'show_author_avatar' => 'yes',
				),
				'render_type' => 'template',
			)
		);
		$this->add_responsive_control(
			'author_space_between',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-author' => 'grid-gap: {{SIZE}}{{UNIT}}',
				),
				'condition'  => array(
					'show_author_avatar' => 'yes',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'author_border',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-author img',
				'condition' => array(
					'show_author_avatar' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'author_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-author img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_author_avatar' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'author_wrapper_margin',
			array(
				'label'      => __( 'فاصله خارجی نگهدارنده', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-wrapper .nour-post-grid-author' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'author_heading_title',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'author_title!' => '',
				),
			)
		);
		$this->add_group_control(
			Nour_Elementor_Group_Control_Foreground::get_type(),
			array(
				'name'      => 'author_title_color',
				'label'     => __( 'رنگ عنوان', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-author-title',
				'condition' => array(
					'author_title!' => '',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'author_title_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-post-grid-author-title',
				'condition' => array(
					'author_title!' => '',
				),
			)
		);
		$this->add_responsive_control(
			'author_title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-author-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'author_title!' => '',
				),
			)
		);
		$this->add_control(
			'author_heading_name',
			array(
				'label'     => __( 'نام', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_control(
			'author_name_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-post-grid-author-name' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'author_name_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-post-grid-author-name',
			)
		);
		$this->add_responsive_control(
			'author_name_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-post-grid-author-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_pagination_style',
			array(
				'label'     => __( 'صفحه بندی', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_pagination' => 'yes',
					'terms'           => '',
				),
			)
		);
		$this->add_responsive_control(
			'pagination_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'justify-content: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'pagination_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-elementor-post-pagination .page-numbers',
			)
		);
		$this->add_responsive_control(
			'pagination_space_between',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'grid-gap: {{SIZE}}{{UNIT}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'pagination_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-elementor-post-pagination .page-numbers',
			)
		);
		$this->add_responsive_control(
			'pagination_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'pagination_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'pagination_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->start_controls_tabs(
			'pagination_style_tabs'
		);
		$this->start_controls_tab(
			'pagination_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'pagination_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'pagination_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'pagination_hover_tab',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'pagination_hover_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers:hover' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'pagination_bg_hover_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers:hover' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'pagination_active_tab',
			array(
				'label' => __( 'فعال', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'pagination_active_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers.current' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'pagination_bg_arctive_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	public static function get_taxonomies() {
		$list     = nour_elementor_get_taxonomies( array( 'public' => true ), 'object', true );
		$list[''] = __( 'هیچ', 'nour-elementor-addons' );
		return $list;
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="nour-post-grid-wrapper nour-post-grid-layout-<?php echo esc_attr( $settings['layout'] ); ?>">
			<?php
			$args = nour_elementor_get_query_args( $settings );
			$args = nour_elementor_get_dynamic_args( $settings, $args );
			if ( 'source_dynamic' === $settings['post_type'] && ( 'nour-themer' === get_post_type() || 'nour_content' === get_post_type() ) ) {
				$document     = Plugin::instance()->documents->get_doc_or_auto_save( get_the_ID() );
				$dynamic_args = $document->get_document_query_args();
				if ( empty( $dynamic_args ) ) {
					$dynamic_args['post_type']      = 'post';
					$dynamic_args['posts_per_page'] = get_option( 'posts_per_page' );
				}
				$args = array_merge( $args, $dynamic_args );
			}
			$found_posts = 0;
			$paged       = 1;
			if ( '' === $settings['terms'] || 'yes' === $settings['show_pagination'] ) {
				$args['offset'] = '';
				if ( get_query_var( 'paged' ) ) {
					$paged = get_query_var( 'paged' );
				} elseif ( get_query_var( 'page' ) ) {
					$paged = get_query_var( 'page' );
				}
			}
			$args['paged'] = $paged;
			$query = new WP_Query( $args );
			if ( $query->have_posts() ) {
				$found_posts      = $query->found_posts;
				$max_page         = ceil( $found_posts / absint( $args['posts_per_page'] ) );
				$args['max_page'] = $max_page;
				?>
				<div class="nour-post-grid-main cbp">
					<?php
					while ( $query->have_posts() ) {
						$query->the_post();
						require NOUR_ELEMENTOR_ADDONS_WIDGET . 'post-grid/layout/frontend.php';
					}
					?>
				</div>
				<?php
				if ( $found_posts > $args['posts_per_page'] && 'yes' === $settings['show_pagination'] ) {
					$prev_icon_class = $settings['arrow'];
					$next_icon_class = str_replace( 'left', 'right', $settings['arrow'] );

					$prev_text = '<i class="' . $next_icon_class . '"></i><span class="nour-elementor-post-pagination-prev-text">' . $settings['prev_label'] . '</span>';
					$next_text = '<span class="nour-elementor-post-pagination-next-text">' . $settings['next_label'] . '</span><i class="' . $prev_icon_class . '"></i>';

					$paginate_args = array(
						'type'      => 'array',
						'current'   => max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) ),
						'total'     => $query->max_num_pages,
						'prev_next' => true,
						'prev_text' => $prev_text,
						'next_text' => $next_text,
					);

					if ( is_singular() && ! is_front_page() ) {
						global $wp_rewrite;
						if ( $wp_rewrite->using_permalinks() ) {
							$paginate_args['format'] = user_trailingslashit( 'page%#%', 'single_paged' ); 
							} else {
							$paginate_args['format'] = '?page=%#%';
						}
					}

					$links = paginate_links( $paginate_args );

					?>

					<nav class="nour-elementor-post-pagination" role="navigation"
						 aria-label="<?php esc_attr_e( 'صفحه بندی', 'nour-elementor-addons' ); ?>">
						<?php echo implode( PHP_EOL, $links ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</nav>

					<?php
				}

				wp_reset_postdata();
			} else {
				?>
				<p class="nour-alert nour-alert-warning">
					<span class="nour-alert-title"><?php esc_html_e( 'هیچ نوشته ای پیدا نشد!', 'nour-elementor-addons' ); ?></span>
					<span class="nour-alert-description"><?php esc_html_e( 'متأسفیم، اما هیچ چیزی با انتخاب شما مطابقت نداشت. لطفاً با چند کلمه کلیدی مختلف دوباره امتحان کنید.', 'nour-elementor-addons' ); ?></span>
				</p>
				<?php
			}

			?>

		</div>

		<?php
	}
}
