<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {exit;} 
class News_Ticker extends Widget_Base {
	public function get_name() {
		return 'nour-news-ticker';
	}
	public function get_title() {
		return __( 'سرخط خبرها', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-news-ticker nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'news', 'headlines', 'ticker', 'tickers' );
	}
	public function get_style_depends() {
		return array( 'owl-carousel' );
	}
	public function get_script_depends() {
		return array( 'owl-carousel' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_news_ticker_heading_settings',
			array(
				'label' => __( 'سرفصل', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'news_ticker_heading_separator_style',
			array(
				'label'   => __( 'طرح بندی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default' => __( 'پیشفرض', 'nour-elementor-addons' ),
					'shape-1' => __( 'طرح بندی 1', 'nour-elementor-addons' ),
					'shape-2' => __( 'طرح بندی 2', 'nour-elementor-addons' ),
					'shape-3' => __( 'طرح بندی 3', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'   => __( 'عنوان', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'سرخط خبرها',
				'dynamic' => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'heading_media_type',
			array(
				'label'       => __( 'نوع رسانه', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'none'  => array(
						'title' => __( 'هیچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'icon'  => array(
						'title' => __( 'نماد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-star-o',
					),
					'image' => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'     => 'none',
				'toggle'      => false,
			)
		);

		$this->add_control(
			'heading_icon',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => array(
					'value'   => 'fas fa-newspaper',
					'library' => 'fa-solid',
				),
				'condition'   => array(
					'heading_media_type' => 'icon',
				),
			)
		);

		$this->add_control(
			'heading_image',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'heading_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'heading_media_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
				'condition' => array(
					'heading_media_type' => 'image',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_news_ticker',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'content_media_type',
			array(
				'label'       => __( 'نوع رسانه', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'none'  => array(
						'title' => __( 'هیچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'icon'  => array(
						'title' => __( 'نماد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-star-o',
					),
					'image' => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'     => 'none',
				'toggle'      => false,
			)
		);

		$repeater->add_control(
			'content_icon',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => array(
					'value'   => 'fas fa-check-circle',
					'library' => 'fa-solid',
				),
				'condition'   => array(
					'content_media_type' => 'icon',
				),
			)
		);

		$repeater->add_control(
			'content_image',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'content_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'content_media_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
				'condition' => array(
					'content_media_type' => 'image',
				),
			)
		);

		$repeater->add_control(
			'description',
			array(
				'label'       => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'توضیحات را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'item',
			array(
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'description' => __( 'بهترین ها در راست چین', 'nour-elementor-addons' ),
					),
					array(
						'description' => __( 'پشتیبانی سریع و رایگان', 'nour-elementor-addons' ),
					),
					array(
						'description' => __( 'ضمانت بازگشت وجه', 'nour-elementor-addons' ),
					),
				),
			)
		); 

		$this->end_controls_section();
		$this->start_controls_section(
			'section_news_ticker_carousel_settings',
			array(
				'label' => __( 'تنظیمات', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'effect',
			array(
				'label'              => __( 'جلوه', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => 'اسلاید',
				'options'            => array(
					'fade'  => __( 'محو شدن', 'nour-elementor-addons' ),
					'slide' => __( 'اسلایدشو', 'nour-elementor-addons' ),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'direction',
			array(
				'label'              => __( 'جهت', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => 'rtl',
				'options'            => array(
					'ltr' => __( 'چپ', 'nour-elementor-addons' ),
					'rtl' => __( 'راست', 'nour-elementor-addons' ),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'condition'          => array(
					'effect' => 'slide',
				),
			)
		);

		$this->add_control(
			'autoplay',
			array(
				'label'              => __( 'پخش خوکار', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'autoplay_timeout',
			array(
				'label'              => __( 'مدت زمان پخش', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'default'            => array(
					'size' => 3,
				),
				'range'              => array(
					'px' => array(
						'min' => 1,
						'max' => 10,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'condition'          => array(
					'autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'custom_nav',
			array(
				'label'              => __( 'ناوبری', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'custom_close_nav',
			array(
				'label'              => __( 'دکمه بستن', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'news_ticker_separator_switch',
			array(
				'label'        => __( 'جداکننده', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_news_ticker_sticky_style',
			array(
				'label' => __( 'سرفصل', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'sticky_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-sticky-title',
			)
		);

		$this->add_control(
			'sticky_color',
			array(
				'label'     => __( 'رنگ ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-sticky-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'sticky_title_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-sticky-title,
				{{WRAPPER}} .nour-news-ticker-separator-shape-1:before,
				{{WRAPPER}} .nour-news-ticker-separator-shape-2:before,
				{{WRAPPER}} .nour-news-ticker-separator-shape-3:before',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'sticky_title_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-sticky-title',
			)
		);

		$this->add_responsive_control(
			'sticky_title_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-sticky-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'sticky_title_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-sticky-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'heading_media_text_line',
			array(
				'label'     => __( 'رسانه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'heading_media_type!' => 'none',
				),
			)
		);

		$this->add_control(
			'heading_media_icon_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-heading-box > i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-news-ticker-heading-box > svg' => 'fill: {{VALUE}}',
				),
				'condition' => array(
					'heading_media_type' => 'icon',
				),
			)
		);

		$this->add_responsive_control(
			'heading_media_size',
			array(
				'label'      => __( 'اندازه رسانه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-heading-box > img' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-news-ticker-heading-box > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-news-ticker-heading-box > svg' => 'width: {{SIZE}}{{UNIT}}; height:auto',
				),
				'condition'  => array(
					'heading_media_type!' => 'none',
				),
			)
		);

		$this->add_responsive_control(
			'heading_media_margin_right',
			array(
				'label'      => __( 'فاصله ما بین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-heading-box > img,
					{{WRAPPER}} .nour-news-ticker-heading-box > svg,
					{{WRAPPER}} .nour-news-ticker-heading-box > i' => 'margin-right: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'heading_media_type!' => 'none',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_news_ticker_content_style',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-description',
			)
		);

		$this->add_control(
			'content_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-description' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'sticky_content_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .elementor-widget-container',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'sticky_content_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .elementor-widget-container',
			)
		);

		$this->add_responsive_control(
			'content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .elementor-widget-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'content_image_width_line',
			array(
				'label'     => __( 'رسانه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'content_media_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-box > i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-news-ticker-box > svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'content_media_width',
			array(
				'label'      => __( 'اندازه رسانه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-box > img' => 'height: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-news-ticker-box > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-news-ticker-box > svg' => 'width: {{SIZE}}{{UNIT}}; height:auto;',
				),
			)
		);

		$this->add_responsive_control(
			'content_media_margin_right',
			array(
				'label'      => __( 'فاصله ما بین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-box > img,
					{{WRAPPER}} .nour-news-ticker-box > i,
					{{WRAPPER}} .nour-news-ticker-box > svg' => 'margin-right: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_news_ticker_separator_style',
			array(
				'label'     => __( 'جداکننده', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'news_ticker_separator_switch' => 'yes',
				),
			)
		);

		$this->add_control(
			'separator_bg_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-separator' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'separator_width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 1,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-separator' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'separator_height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 30,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-separator' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'separator_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-separator' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_news_ticker_nav_style',
			array(
				'label'     => __( 'ناوبری', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'custom_nav' => 'yes',
				),
			)
		);

		$this->add_control(
			'news_ticker_heading_nav_style',
			array(
				'label'   => __( 'طرح', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'arrow',
				'options' => array(
					'arrow'        => __( 'پیکان', 'nour-elementor-addons' ),
					'long-angle'   => __( 'زاویه', 'nour-elementor-addons' ),
					'circle-angle' => __( 'زاویه دایره', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_responsive_control(
			'nav_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => '16',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-prev,
					 {{WRAPPER}} .nour-news-ticker-next' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'nav_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 30,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-prev,
					 {{WRAPPER}} .nour-news-ticker-next' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'nav_margin_left',
			array(
				'label'      => __( 'فاصله ما بین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'unit' => 'px',
					'size' => '1',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-next' => 'margin-left: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'news_ticker_nav_style_tabs'
		);

		$this->start_controls_tab(
			'news_ticker_nav_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'nav_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-prev > i,
					{{WRAPPER}} .nour-news-ticker-next > i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_bg_color',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-prev,
					{{WRAPPER}} .nour-news-ticker-next' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'news_ticker_nav_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'nav_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-prev:hover > i,
					{{WRAPPER}} .nour-news-ticker-next:hover > i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_hover_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-prev:hover,
					 {{WRAPPER}} .nour-news-ticker-next:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_hover_border',
			array(
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-prev:hover,
					{{WRAPPER}} .nour-news-ticker-next:hover' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'nav_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-prev ,
				{{WRAPPER}} .nour-news-ticker-next ',
			)
		);

		$this->add_responsive_control(
			'nav_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-prev, 
					{{WRAPPER}} .nour-news-ticker-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_news_ticker_close_style',
			array(
				'label'     => __( 'دکمه بستن', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'custom_close_nav' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'close_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => '16',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-close' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'close_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 30,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-close ' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'news_ticker_close_style_tabs'
		);

		$this->start_controls_tab(
			'close_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'close_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-close > i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'close_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-close' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'news_ticker_close_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'close_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-close:hover > i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'close_hover_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-close:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'close_hover_border',
			array(
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-news-ticker-close:hover' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'close_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-news-ticker-close ',
			)
		);

		$this->add_responsive_control(
			'close_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'close_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-news-ticker-close' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();
		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'news-ticker/layout/frontend.php';
	}
}
