<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {exit;}
class Logo_Grid extends Widget_Base {
	public function get_name() {
		return 'nour-logo-grid';
	}
	public function get_title() {
		return __( 'شبکه لوگو', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-logo-grid nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'nour', 'logo', 'grid' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'_section_logo',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			array(
				'label'   => __( 'لوگو', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'dynamic' => array(
					'active' => true,
				),
			)
		);

		$repeater->add_control(
			'link',
			array(
				'label'       => __( 'آدرس سایت', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => array(
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		$repeater->add_control(
			'name',
			array(
				'label'       => __( 'نام برند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'نام برند', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'logo_list',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
				'default'     => array(
					array(
						'name' => 'آیتم #1',
					),
					array(
						'name' => 'آیتم #2',
					),
					array(
						'name' => 'آیتم #3',
					),
					array(
						'name' => 'آیتم #4',
					),
					array(
						'name' => 'آیتم #5',
					),
					array(
						'name' => 'آیتم #6',
					),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'thumbnail',
				'default'   => 'large',
				'separator' => 'before',
				'exclude'   => array(
					'custom',
				),
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'          => __( 'طرح بندی شبکه', 'nour-elementor-addons' ),
				'type'           => Controls_Manager::SELECT,
				'options'        => array(
					'box'       => __( 'جعبه ای', 'nour-elementor-addons' ),
					'border'    => __( 'لبه دار', 'nour-elementor-addons' ),
					'tictactoe' => __( 'یک دو سه', 'nour-elementor-addons' ),
				),
				'default'        => 'border',
				'prefix_class'   => 'nour-logo-grid--',
				'style_transfer' => true,
			)
		);

		$this->add_responsive_control(
			'columns',
			array(
				'label'           => __( 'ستون ها', 'nour-elementor-addons' ),
				'type'            => Controls_Manager::SELECT,
				'options'         => array(
					1 => __( '1', 'nour-elementor-addons' ),
					2 => __( '2', 'nour-elementor-addons' ),
					3 => __( '3', 'nour-elementor-addons' ),
					4 => __( '4', 'nour-elementor-addons' ),
					5 => __( '5', 'nour-elementor-addons' ),
					6 => __( '6', 'nour-elementor-addons' ),
				),
				'desktop_default' => 3,
				'tablet_default'  => 2,
				'mobile_default'  => 2,
				'prefix_class'    => 'nour-logo-grid--col-%s',
				'style_transfer'  => true,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_grid',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'max' => 500,
						'min' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-logo-grid-item' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'grid_box_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}}.nour-logo-grid--tictactoe .nour-logo-grid-wrapper, {{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-wrapper, {{WRAPPER}}.nour-logo-grid--box .nour-logo-grid-item',
			)
		);

		$this->add_control(
			'grid_border_type',
			array(
				'label'     => __( 'نوع لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'none'   => __( 'هیچ', 'nour-elementor-addons' ),
					'solid'  => __( 'جامد', 'nour-elementor-addons' ),
					'double' => __( 'دوتایی', 'nour-elementor-addons' ),
					'dotted' => __( 'نقطه چین', 'nour-elementor-addons' ),
					'dashed' => __( 'خط فاصله', 'nour-elementor-addons' ),
					'groove' => __( 'سه بعدی', 'nour-elementor-addons' ),
				),
				'default'   => 'solid',
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-item' => 'border-style: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'grid_border_width',
			array(
				'label'      => __( 'عرض لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'(desktop+){{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-item' => 'border-right-width: {{grid_border_width.SIZE}}{{UNIT}}; border-bottom-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-item'   => 'border-right-width: {{grid_border_width_tablet.SIZE}}{{UNIT}}; border-bottom-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-item'   => 'border-right-width: {{grid_border_width_mobile.SIZE}}{{UNIT}}; border-bottom-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',

					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-1 .nour-logo-grid-item:nth-child(n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-2 .nour-logo-grid-item:nth-child(2n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-3 .nour-logo-grid-item:nth-child(3n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-4 .nour-logo-grid-item:nth-child(4n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-5 .nour-logo-grid-item:nth-child(5n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-6 .nour-logo-grid-item:nth-child(6n+1)' => 'border-left-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-1 .nour-logo-grid-item:nth-child(-n+1)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-2 .nour-logo-grid-item:nth-child(-n+2)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-3 .nour-logo-grid-item:nth-child(-n+3)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-4 .nour-logo-grid-item:nth-child(-n+4)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-5 .nour-logo-grid-item:nth-child(-n+5)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-6 .nour-logo-grid-item:nth-child(-n+6)' => 'border-top-width: {{grid_border_width.SIZE}}{{UNIT}};',

					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet1 .nour-logo-grid-item:nth-child(n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-child(2n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-child(3n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-child(4n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-child(5n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-child(6n+1)' => 'border-left-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet1 .nour-logo-grid-item:nth-child(-n+1)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-child(-n+2)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-child(-n+3)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-child(-n+4)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-child(-n+5)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-child(-n+6)' => 'border-top-width: {{grid_border_width_tablet.SIZE}}{{UNIT}};',

					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile1 .nour-logo-grid-item:nth-child(n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-child(2n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-child(3n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-child(4n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-child(5n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-child(6n+1)' => 'border-left-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile1 .nour-logo-grid-item:nth-child(-n+1)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-child(-n+2)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-child(-n+3)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-child(-n+4)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-child(-n+5)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-child(-n+6)' => 'border-top-width: {{grid_border_width_mobile.SIZE}}{{UNIT}};',

					'{{WRAPPER}}.nour-logo-grid--tictactoe .nour-logo-grid-item' => 'border-top-width: {{SIZE}}{{UNIT}}; border-right-width: {{SIZE}}{{UNIT}};',

					'{{WRAPPER}}.nour-logo-grid--box .nour-logo-grid-item' => 'border-width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'grid_border_type!' => 'none',
				),
			)
		);

		$this->add_control(
			'grid_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-item' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'grid_border_type!' => 'none',
				),
			)
		);

		$this->add_control(
			'grid_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-figure' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'grid_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-wrapper, {{WRAPPER}}.nour-logo-grid--box .nour-logo-grid-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-item:first-child'                                              => 'border-top-left-radius: {{TOP}}{{UNIT}};',
					'{{WRAPPER}}.nour-logo-grid--border .nour-logo-grid-item:last-child'                                               => 'border-bottom-right-radius: {{BOTTOM}}{{UNIT}};',

					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col-6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',

					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',

					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--border.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'{{WRAPPER}}.nour-logo-grid--tictactoe .nour-logo-grid-wrapper'                                                  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}}.nour-logo-grid--tictactoe .nour-logo-grid-item:first-child'                                         => 'border-top-left-radius: {{TOP}}{{UNIT}};',
					'{{WRAPPER}}.nour-logo-grid--tictactoe .nour-logo-grid-item:last-child'                                          => 'border-bottom-right-radius: {{BOTTOM}}{{UNIT}};',

					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius.RIGHT}}{{UNIT}};',
					'(desktop+){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col-6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius.LEFT}}{{UNIT}};',

					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius_tablet.RIGHT}}{{UNIT}};',
					'(tablet){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--tablet6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius_tablet.LEFT}}{{UNIT}};',

					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-child(2)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile2 .nour-logo-grid-item:nth-last-child(2)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-child(3)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile3 .nour-logo-grid-item:nth-last-child(3)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-child(4)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile4 .nour-logo-grid-item:nth-last-child(4)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-child(5)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile5 .nour-logo-grid-item:nth-last-child(5)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-child(6)'      => 'border-top-right-radius: {{grid_border_radius_mobile.RIGHT}}{{UNIT}};',
					'(mobile){{WRAPPER}}.nour-logo-grid--tictactoe.nour-logo-grid--col--mobile6 .nour-logo-grid-item:nth-last-child(6)' => 'border-bottom-left-radius: {{grid_border_radius_mobile.LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-logo-grid-figure' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'_tabs_image_effects',
			array(
				'separator' => 'before',
			)
		);

		$this->start_controls_tab(
			'_tab_image_effects_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'image_css_filters',
				'selector' => '{{WRAPPER}} .nour-logo-grid-figure img',
			)
		);

		$this->add_control(
			'image_opacity',
			array(
				'label'     => __( 'شفافیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-figure img' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'image_css_filters_hover',
				'selector' => '{{WRAPPER}} .nour-logo-grid-figure:hover img',
			)
		);

		$this->add_control(
			'image_opacity_hover',
			array(
				'label'     => __( 'شفافیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-figure:hover img' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_control(
			'hover_animation',
			array(
				'label'       => __( 'انیمیشن شناور', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::HOVER_ANIMATION,
				'label_block' => true,
			)
		);

		$this->add_control(
			'image_bg_hover_transition',
			array(
				'label'     => __( 'مدت انیمیشن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 3,
						'step' => 0.1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-logo-grid-figure:hover img' => 'transition-duration: {{SIZE}}s;',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();
		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'logo-grid/layout/frontend.php';
	}
}
