<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;
use NourElementorAddons\Control\Nour_Elementor_Image_Selector;

if ( ! defined( 'ABSPATH' ) ) {	exit; }
class Image_Scroller extends Widget_Base {
	public function get_name() {
		return 'nour-image-scroller';
	}
	public function get_title() {
		return __( 'اسکرول تصویر', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-scroll-image nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'nour', 'image', 'scrolling', 'scroll', 'img' );
	}
	public function get_style_depends() {

		return array( 'animate' );
	}
	public function get_script_depends() {
		return array( 'imagesloaded' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_scroller_image',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'direction_type',
			array(
				'label'              => __( 'جهت', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => 'vertical',
				'options'            => array(
					'vertical'   => __( 'عمودی', 'nour-elementor-addons' ),
					'horizontal' => __( 'افقی', 'nour-elementor-addons' ),
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'trigger_type',
			array(
				'label'              => __( 'نوع عملکرد', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => 'mouse-hover',
				'options'            => array(
					'mouse-hover'  => __( 'در وضعیت شناور', 'nour-elementor-addons' ),
					'mouse-scroll' => __( 'در وضعیت اسکرول', 'nour-elementor-addons' ),
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'reverse',
			array(
				'label'              => __( 'برعکس', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'label_on'           => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'          => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value'       => 'yes',
				'condition'          => array(
					'trigger_type' => 'mouse-hover',
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'duration_speed',
			array(
				'label'     => __( 'مدت زمان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
				'condition' => array(
					'trigger_type' => 'mouse-hover',
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-image-scroll-img > img' => 'transition-duration: {{Value}}s',
				),
			)
		);

		$this->add_control(
			'image',
			array(
				'label'   => __( 'تصویر', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'dynamic' => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'mask_image',
			array(
				'label'        => __( 'ماسک تصویر', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'پیشفرض', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_control(
			'mask_shape',
			array(
				'label'   => __( 'نوع ماسک', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'default',
				'options' => array(
					'default' => array(
						'title' => _x( 'اشکال پیشفرض', 'Mask Image', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image-bold',
					),
					'custom'  => array(
						'title' => _x( 'اشکال سفارشی', 'Mask Image', 'nour-elementor-addons' ),
						'icon'  => 'eicon-upload',
					),
				),
				'toggle'  => false,
			)
		);

		$this->add_control(
			'mask_shape_default',
			array(
				'label'                => _x( 'پیشفرض', 'Mask Image', 'nour-elementor-addons' ),
				'label_block'          => true,
				'show_label'           => false,
				'type'                 => Nour_Elementor_Image_Selector::TYPE,
				'default'              => 'shape1',
				'options'              => nour_elementor_masking_shape_list( 'list' ),
				'selectors'            => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-image: url({{VALUE}}); mask-image: url({{VALUE}});',
				),
				'selectors_dictionary' => nour_elementor_masking_shape_list( 'url' ),
				'condition'            => array(
					'mask_image' => 'yes',
					'mask_shape' => 'default',
				),
			)
		);

		$this->add_control(
			'mask_custom_shape',
			array(
				'label'       => _x( 'اشکال سفارشی', 'تصویر ماسک', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::MEDIA,
				'show_label'  => false,
				'selectors'   => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-image: url({{URL}}); mask-image: url({{URL}});',
				),
				'condition'   => array(
					'mask_image' => 'yes',
					'mask_shape' => 'custom',
				),
			)
		);

		$this->add_control(
			'mask_position',
			array(
				'label'                => _x( 'موقعیت', 'Mask Image', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'default'              => 'center-center',
				'options'              => array(
					'center-center' => _x( 'وسط وسط', 'Mask Image', 'nour-elementor-addons' ),
					'center-left'   => _x( 'وسط چپ', 'Mask Image', 'nour-elementor-addons' ),
					'center-right'  => _x( 'وسط راست', 'Mask Image', 'nour-elementor-addons' ),
					'top-center'    => _x( 'بالا وسط', 'Mask Image', 'nour-elementor-addons' ),
					'top-left'      => _x( 'بالا چپ', 'Mask Image', 'nour-elementor-addons' ),
					'top-right'     => _x( 'بالا راست', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-center' => _x( 'پایین وسط', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-left'   => _x( 'پایین چپ', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-right'  => _x( 'پایین راست', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors_dictionary' => array(
					'center-center' => 'center center',
					'center-left'   => 'center left',
					'center-right'  => 'center right',
					'top-center'    => 'top center',
					'top-left'      => 'top left',
					'top-right'     => 'top right',
					'bottom-center' => 'bottom center',
					'bottom-left'   => 'bottom left',
					'bottom-right'  => 'bottom right',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-position: {{VALUE}}; mask-position: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'mask_size',
			array(
				'label'     => _x( 'اندازه', 'Mask Image', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'contain',
				'options'   => array(
					'auto'    => _x( 'خودکار', 'Mask Image', 'nour-elementor-addons' ),
					'cover'   => _x( 'پوشش', 'Mask Image', 'nour-elementor-addons' ),
					'contain' => _x( 'اصلی', 'Mask Image', 'nour-elementor-addons' ),
					'initial' => _x( 'سفارشی', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-size: {{VALUE}}; mask-size: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'mask_custom_size',
			array(
				'label'      => _x( 'اندازه سفارشی', 'Mask Image', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%', 'vw' ),
				'default'    => array(
					'size' => 100,
					'unit' => '%',
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-size: {{SIZE}}{{UNIT}}; mask-size: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'mask_size' => 'initial',
				),
			)
		);

		$this->add_control(
			'mask_repeat',
			array(
				'label'                => _x( 'تکرار', 'Mask Image', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'default'              => 'repeat',
				'options'              => array(
					'repeat'          => _x( 'تکرار', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-x'        => _x( 'تکرار-x', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-y'        => _x( 'تکرار-y', 'Mask Image', 'nour-elementor-addons' ),
					'space'           => _x( 'فاصله', 'Mask Image', 'nour-elementor-addons' ),
					'round'           => _x( 'گرد', 'Mask Image', 'nour-elementor-addons' ),
					'no-repeat'       => _x( 'بدون تکرار', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-space'    => _x( 'تکرار با فاصله', 'Mask Image', 'nour-elementor-addons' ),
					'round-space'     => _x( 'گرد فاصله دار', 'Mask Image', 'nour-elementor-addons' ),
					'no-repeat-round' => _x( 'بدون تکرار گرد', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors_dictionary' => array(
					'repeat'          => 'repeat',
					'repeat-x'        => 'repeat-x',
					'repeat-y'        => 'repeat-y',
					'space'           => 'space',
					'round'           => 'round',
					'no-repeat'       => 'no-repeat',
					'repeat-space'    => 'repeat space',
					'round-space'     => 'round space',
					'no-repeat-round' => 'no-repeat round',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-image-scroll-img' => '-webkit-mask-repeat: {{VALUE}}; mask-repeat: {{VALUE}};',
				),
			)
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'media_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
			)
		);

		$this->add_control(
			'show_indicator',
			array(
				'label'        => __( 'همپوشانی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'icon_indicator',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => array(
					'value'   => 'xi xi-mouse-2',
					'library' => 'fa-solid',
				),
				'condition'   => array(
					'show_indicator' => 'yes',
				),
			)
		);

		$this->add_control(
			'show_badge',
			array(
				'label'        => __( 'فعالسازی برچسب ویژه', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'badge_text',
			array(
				'label'       => __( 'متن برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'متن برچسب',
				'placeholder' => __( 'متن خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'show_badge' => 'yes',
				),
			)
		);

		$this->add_control(
			'link',
			array(
				'label'       => __( 'پیوند جعبه', 'nour-elementor-addons' ),
				'separator'   => 'before',
				'type'        => Controls_Manager::URL,
				'placeholder' => 'https://example.com',
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_image',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'image_height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,

				'size_units' => array( 'px', 'vh' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'vh' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 300,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-scroll-image-inner' => 'height: {{SIZE}}{{UNIT}};',

				),
			)
		);

		$this->start_controls_tabs( '_image' );

		$this->start_controls_tab(
			'_scroll_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'opacity_normal',
			array(
				'label'     => __( 'شفافیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-image-scroll-img > img' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'css_filters_normal',
				'selector' => '{{WRAPPER}} .nour-image-scroll-img > img',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_image_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'opacity_hover',
			array(
				'label'     => __( 'شفافیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-image-scroll-img:hover > img' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'css_filters_hover',
				'selector' => '{{WRAPPER}} .nour-image-scroll-img:hover > img',
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'blend_mode',
			array(
				'label'     => __( 'حالت ترکیبی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'normal'            => __( 'Normal', 'nour-elementor-addons' ),
					'multiply'    => 'چندگانه',
					'screen'      => 'تصویر',
					'overlay'     => 'همپوشانی',
					'darken'      => 'تاریک',
					'lighten'     => 'روشن',
					'hard-light'     => 'زیاد روشن',
					'color-dodge' => 'دوج رنگی',
					'saturation'  => 'اشباع',
					'color-burn'  => 'سوزاندن',
					'difference'  => 'تفاوت',
					'exclusion'  => 'محرومیت',
					'hue'  => 'طیف رنگ',
					'luminosity'  => 'درخشندگی',
					'color'       => 'رنگ',
				),
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .nour-image-scroll-img img' => 'mix-blend-mode: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_indicator',
			array(
				'label'     => __( 'همپوشانی', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_indicator' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'indicator-font',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 200,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 80,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-scroll-image-wrapper .nour-scroll-image-indicator-icon' => 'font-size: {{SIZE}}{{UNIT}};',

				),
			)
		);

		$this->add_control(
			'indicator_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-scroll-image-wrapper .nour-scroll-image-indicator-icon' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'indicator_bg_color',
			array(
				'label'     => __( 'رنگ همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-scroll-image-wrapper .nour-scroll-image-indicator-icon' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_badge',
			array(
				'label'     => __( 'برچسب ویژه', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_badge!' => '',
				),
			)
		);

		$this->add_control(
			'badge_position',
			array(
				'label'   => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'top-left'      => __( 'بالا چپ', 'nour-elementor-addons' ),
					'top-center'    => __( 'بابا وسط', 'nour-elementor-addons' ),
					'top-right'     => __( 'بالا راست', 'nour-elementor-addons' ),
					'middle-left'   => __( 'مرکز چپ', 'nour-elementor-addons' ),
					'middle-center' => __( 'مرکز وسط', 'nour-elementor-addons' ),
					'middle-right'  => __( 'مرکز راست', 'nour-elementor-addons' ),
					'bottom-left'   => __( 'پایین چپ', 'nour-elementor-addons' ),
					'bottom-center' => __( 'پایین وسط', 'nour-elementor-addons' ),
					'bottom-right'  => __( 'پایین راست', 'nour-elementor-addons' ),
				),
				'default' => 'top-left',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'badge_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-badge',
			)
		);

		$this->add_control(
			'badge_offset_toggle',
			array(
				'label'        => __( 'فاصله', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_responsive_control(
			'badge_offset_x',
			array(
				'label'      => __( 'فاصله چپ', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'condition'  => array(
					'badge_offset_toggle' => 'yes',
				),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => - 100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-badge' => '--nour-badge-translate-x: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'badge_offset_y',
			array(
				'label'      => __( 'فاصله بالا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'condition'  => array(
					'badge_offset_toggle' => 'yes',
				),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => - 100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-badge' => '--nour-badge-translate-y: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->end_popover();

		$this->add_control(
			'badge_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-badge' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'badge_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-badge' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'badge_border',
				'selector' => '{{WRAPPER}} .nour-badge',
			)
		);

		$this->add_responsive_control(
			'badge_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'badge_box_shadow',
				'selector' => '{{WRAPPER}} .nour-badge',
			)
		);

		$this->add_responsive_control(
			'badge_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();
		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'image-scroller/layout/frontend.php';
	}
}
