<div class="nour-elementor-gallery nour-elementor-gallery-layout-grid">

	<?php use Elementor\Icons_Manager;

	if ( 'yes' === $settings['show_filter'] ) : ?>
		<div class="nour-elementor-gallery-filter nour-filter-dropdown-<?php echo esc_attr( $settings['show_dropdown'] ); ?>">

			<!-- select content dropdown -->
			<div class="nour-select-option">
				<span class="nour-select-content"><?php echo esc_html( $settings['filter_all_text'] ? $settings['filter_all_text'] : '' ); ?></span>
				<i class="nour-select-icon fas fa-chevron-down"></i>
			</div>

			<!-- Filters List -->
			<ul class="cbp-l-filters-button" data-default-filter="<?php echo esc_attr( $this->_default_filter ); ?>">

				<?php if ( 'yes' === $settings['filter_all'] ) : ?>
					<li class="cbp-filter-item-active cbp-filter-item" data-filter="*"><?php echo esc_html( $settings['filter_all_text'] ? $settings['filter_all_text'] : '' ); ?></li>
				<?php endif; ?>

				<?php
				foreach ( $image_gallery['menu'] as $key => $val ) {
					echo '<li class="cbp-filter-item" data-filter=".' . esc_attr( $key ) . '">' . esc_html( $val ) . '</li>';
				}
				?>

			</ul>

		</div>
	<?php endif; ?>

	<!-- Main Gallery -->
	<div class="pluginResize nour-elementor-gallery-wrapper cbp">

		<?php

		foreach ( $image_gallery['items'] as $gid => $item ) :

			$attachment = nour_elementor_get_attachment( $gid );

			$caption     = ! empty( $attachment && $attachment['caption'] ) ? $attachment['caption'] : '';
			$description = ! empty( $attachment && $attachment['description'] ) ? $attachment['description'] : '';
			?>

			<!--Item-->
			<div class="cbp-item nour-elementor-gallery-item <?php echo esc_attr( $item ); ?>">
				<div class="cbp-caption">
					<div class="cbp-caption-defaultWrap">
						<?php echo wp_get_attachment_image( $gid, $settings['thumbnail_size'], false ); ?>
					</div>
					<div class="cbp-caption-activeWrap">
						<div class="cbp-l-caption-alignCenter" data-nour-lightbox data-src="<?php echo esc_url( wp_get_attachment_image_url( $gid, 'full', false ) ); ?>">
							<!-- Overlay -->
							<div class="cbp-l-caption-body">
								<?php if ( 'yes' === $settings['icon'] ) { ?>
									<!-- Icon -->
									<span class="nour-overlay-icon">
									<?php Icons_Manager::render_icon( $settings['icon_name'], array( 'aria-hidden' => 'true' ) ); ?>
							</span>
								<?php } ?>

								<?php if ( 'yes' === $settings['description'] || 'yes' === $settings['caption'] ) { ?>
									<!-- Content -->
									<div class="nour-overlay-content">
										<?php if ( ! empty( $caption ) && 'yes' === $settings['caption'] ) { ?>
											<h4 class="nour-title"><?php echo esc_html( $caption ); ?></h4>
										<?php } ?>
										<?php if ( ! empty( $description ) && 'yes' === $settings['description'] ) { ?>
											<p class="nour-desc"><?php echo wp_kses_post( $description ); ?></p>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>

		<?php endforeach; ?>

	</div>

</div>
