<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {exit;}
class Hot_Spot extends Widget_Base {
	public function get_name() {
		return 'nour-hot-spot';
	}
	public function get_title() {
		return __( 'نقاط روی تصویر', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-hot-spot nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'nour', 'hot', 'spot', 'spots' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_hotspot',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'type',
			array(
				'label'   => __( 'نوع', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'hover',
				'options' => array(
					'hover' => __( 'در شناور', 'nour-elementor-addons' ),
					'click' => __( 'با کلیک', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'image',
			array(
				'label'   => __( 'تصویر', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'dynamic' => array(
					'active' => true,
				),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'media_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
			)
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'hot_media_type',
			array(
				'label'       => __( 'نوع رسانه', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'none'  => array(
						'title' => __( 'هیچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'icon'  => array(
						'title' => __( 'نماد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-star-o',
					),
					'image' => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'     => 'icon',
				'toggle'      => false,
			)
		);

		$repeater->add_control(
			'hot_icon',
			array(
				'show_label'  => false,
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => array(
					'value'   => 'fas fa-plus',
					'library' => 'fa-solid',
				),
				'condition'   => array(
					'hot_media_type' => 'icon',
				),
			)
		);

		$repeater->add_control(
			'spots_image',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'hot_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'spots_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
				'condition' => array(
					'hot_media_type' => 'image',
				),
			)
		);

		$repeater->add_control(
			'hot_offset_toggle',
			array(
				'label'        => __( 'فاصله', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$repeater->start_popover();

		$repeater->add_responsive_control(
			'hot_offset_x',
			array(
				'label'      => __( 'فاصله از راست', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => '%',
					'size' => 50,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper {{CURRENT_ITEM}}' => 'right: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'hot_offset_toggle' => 'yes',
				),
			)
		);

		$repeater->add_responsive_control(
			'hot_offset_y',
			array(
				'label'      => __( 'فاصله از بالا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => - 1000,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => '%',
					'size' => 50,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper {{CURRENT_ITEM}}' => ' top: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'hot_offset_toggle' => 'yes',
				),
			)
		);

		$repeater->end_popover();

		$repeater->add_control(
			'show_tooltip',
			array(
				'label'        => __( 'نمایش راهنما', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
				'separator'    => 'before',
				'default'      => 'yes',
			)
		);

		$repeater->add_responsive_control(
			'position',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'default'              => 'top',
				'tablet_default'       => 'bottom',
				'mobile_default'       => 'bottom',
				'options'              => array(
					'top'    => __( 'بالا', 'nour-elementor-addons' ),
					'right'  => __( 'راست', 'nour-elementor-addons' ),
					'bottom' => __( 'پایین', 'nour-elementor-addons' ),
					'left'   => __( 'چپ', 'nour-elementor-addons' ),
				),
				'selectors_dictionary' => array(
					'top'    => '--nour-hotspot-tooltip-top:auto; --nour-hotspot-tooltip-right:auto; --nour-hotspot-tooltip-bottom:100%; --nour-hotspot-tooltip-left:50%; --nour-hotspot-tooltip-transform-x: -50%; --nour-hotspot-tooltip-transform-y: 0; --nour-hotspot-tooltip-margin: 0 0 10px 0;
                    --nour-hotspot-tooltip-before-top:auto; --nour-hotspot-tooltip-before-right:auto; --nour-hotspot-tooltip-before-left: 50%; --nour-hotspot-tooltip-before-bottom: -5px; --nour-hotspot-tooltip-before-transform-x: -50%; --nour-hotspot-tooltip-before-transform-y: 0;',
					'right'  => '--nour-hotspot-tooltip-bottom:auto; --nour-hotspot-tooltip-right:auto; --nour-hotspot-tooltip-left:100%; --nour-hotspot-tooltip-top:50%; --nour-hotspot-tooltip-transform-y: -50%; --nour-hotspot-tooltip-transform-x: 0; --nour-hotspot-tooltip-margin: 0 0 0 10px;
                    --nour-hotspot-tooltip-before-bottom:auto; --nour-hotspot-tooltip-before-right:auto; --nour-hotspot-tooltip-before-top: 50%; --nour-hotspot-tooltip-before-left: -5px; --nour-hotspot-tooltip-before-transform-y: -50%; --nour-hotspot-tooltip-before-transform-x: 0;',
					'bottom' => '--nour-hotspot-tooltip-bottom:auto; --nour-hotspot-tooltip-right:auto; --nour-hotspot-tooltip-top:100%; --nour-hotspot-tooltip-left:50%; --nour-hotspot-tooltip-transform-x: -50%; --nour-hotspot-tooltip-transform-y: 0; --nour-hotspot-tooltip-margin: 10px 0 0 0;
                    --nour-hotspot-tooltip-before-bottom:auto; --nour-hotspot-tooltip-before-right:auto; --nour-hotspot-tooltip-before-left: 50%; --nour-hotspot-tooltip-before-top: -5px; --nour-hotspot-tooltip-before-transform-x: -50%; --nour-hotspot-tooltip-before-transform-y: 0;',
					'left'   => '--nour-hotspot-tooltip-bottom:auto; --nour-hotspot-tooltip-left:auto; --nour-hotspot-tooltip-right:100%; --nour-hotspot-tooltip-top:50%; --nour-hotspot-tooltip-transform-y: -50%; --nour-hotspot-tooltip-transform-x: 0; --nour-hotspot-tooltip-margin: 0 10px 0 0;
                    --nour-hotspot-tooltip-before-bottom:auto; --nour-hotspot-tooltip-before-left:auto; --nour-hotspot-tooltip-before-top: 50%; --nour-hotspot-tooltip-before-right: -5px; --nour-hotspot-tooltip-before-transform-y: -50%; --nour-hotspot-tooltip-before-transform-x: 0;',
				),
				'selectors'            => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-hotspot-tooltip-text,
                    {{WRAPPER}} {{CURRENT_ITEM}} .nour-hotspot-tooltip-text:before' => '{{VALUE}};',
				),
				'condition'            => array(
					'show_tooltip' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'tooltip_text',
			array(
				'label'       => __( 'متن راهنما', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'محتوای راهنما', 'nour-elementor-addons' ),
				'placeholder' => __( 'متن خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'condition'   => array(
					'show_tooltip' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'link',
			array(
				'label'       => __( 'پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'hotspot_items',
			array(
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'show_label'  => false,
				'separator'   => 'before',
				'render_type' => 'template',
				'default'     => array(
					array(
						'hot_icon'     => array(
							'value'   => 'fas fa-plus',
							'library' => 'fa-solid',
						),
						'tooltip_text' => __( 'محتوای راهنما', 'nour-elementor-addons' ),
					),
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_hot_image',
			array(
				'label' => __( 'تصویر', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .elementor-widget-container' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'hot_image_width_size',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%', 'vw' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'hot_image_height_size',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vh' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'_hot_object-fit',
			array(
				'label'     => __( 'کشش تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'cover',
				'options'   => array(
					''        => __( 'پیشفرض', 'nour-elementor-addons' ),
					'fill'    => __( 'پرکردن', 'nour-elementor-addons' ),
					'cover'   => __( 'پوشش', 'nour-elementor-addons' ),
					'contain' => __( 'اصلی', 'nour-elementor-addons' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image > img' => 'object-fit: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'hot_image_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image > img',
			)
		);

		$this->add_responsive_control(
			'hot_image_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'hot_image_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image > img',
			)
		);

		$this->add_responsive_control(
			'hot_image_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-image > img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_spot',
			array(
				'label' => __( 'نقطه', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'spot_font_size',
			array(
				'label'      => __( 'اندازه رسانه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item .nour-hotspot-item-wrap > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item .nour-hotspot-item-wrap > img' => 'width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item .nour-hotspot-item-wrap > svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				),
			)
		);

		$this->add_responsive_control(
			'spot_width_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 500,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'spot_hot' );

		$this->start_controls_tab(
			'spots_hot_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'spot_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item .nour-hotspot-item-wrap > i' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'spot_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'spot_hot_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'spot_hvr_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item:hover .nour-hotspot-item-wrap > i' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'spot_bg_hvr_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'spot_hvr_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item:hover' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'spot_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item',
			)
		);

		$this->add_responsive_control(
			'spot_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item,
					{{WRAPPER}} .nour-hotspot-item-wrap:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'spot_image_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}} .nour-hotspot-wrapper .nour-hotspot-item',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_tooltip',
			array(
				'label' => __( 'راهنما', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'tooltip_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( '=چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tooltip_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-hotspot-tooltip-text, {{WRAPPER}} .nour-hotspot-tooltip-text > *',
			)
		);

		$this->add_responsive_control(
			'tooltip_width_size',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 150,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'tooltip_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text, {{WRAPPER}} .nour-hotspot-tooltip-text > *' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'tooltip_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text,
                    {{WRAPPER}} .nour-hotspot-tooltip-text:before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'tooltip_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'tooltip_box_shadow',
				'selector' => '{{WRAPPER}} .nour-hotspot-tooltip-text',
			)
		);

		$this->add_responsive_control(
			'tooltip_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hotspot-tooltip-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'hot-spot/layout/frontend.php';
	}
}
