<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use NourElementorAddons\Control\Nour_Elementor_Group_Control_Foreground;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Heading extends Widget_Base {
	public function get_name() {
		return 'nour-heading';
	}
	public function get_title() {
		return __( 'سرفصل', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-heading nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'heading', 'gradient', 'masking' );
	}

	public function render_title() {

		$settings = $this->get_settings_for_display();

		$target   = $settings['title_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['title_link']['nofollow'] ? ' rel="nofollow"' : '';

		$title = $settings['title_before'] . ( ( ! empty( $settings['title_center'] ) ) ? ' <span class="nour-title-focus">' . $settings['title_center'] . '</span>' : '' ) . ' ' . $settings['title_after'];

		$html = '';

		if ( ! empty( $settings['title_link']['url'] ) ) {
			$html .= '<a href="' . esc_url( $settings['title_link']['url'] ) . '"' . $target . $nofollow . '>';
		}

		$html .= '<' . esc_attr( $settings['title_tag'] ) . ' class="nour-heading-title">';
		$html .= $title;
		$html .= '</' . esc_attr( $settings['title_tag'] ) . '>';

		if ( ! empty( $settings['title_link']['url'] ) ) {
			$html .= '</a>';
		}

		return $html;
	}
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			array(
				'label' => __( 'عنوان', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'title_before',
			array(
				'label'       => __( 'متن ابتدایی', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'این یک آغاز', 'nour-elementor-addons' ),
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'title_center',
			array(
				'label'       => __( 'متن وسط', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'پر هیجان ', 'nour-elementor-addons' ),
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'title_after',
			array(
				'label'       => __( 'متن پایانی', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'برای سایت شماست', 'nour-elementor-addons' ),
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'title_link',
			array(
				'label'       => __( 'پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'placeholder' => 'https://example.com',
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'title_tag',
			array(
				'label'   => __( 'برچسب عنوان', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'h1' => array(
						'title' => __( 'H1', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h1',
					),
					'h2' => array(
						'title' => __( 'H2', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h2',
					),
					'h3' => array(
						'title' => __( 'H3', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h3',
					),
					'h4' => array(
						'title' => __( 'H4', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h4',
					),
					'h5' => array(
						'title' => __( 'H5', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h5',
					),
					'h6' => array(
						'title' => __( 'H6', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-h6',
					),
				),
				'default' => 'h2',
				'toggle'  => false,
			)
		);

		$this->add_responsive_control(
			'box_align',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .nour-simple-heading-wrapper' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_title',
			array(
				'label' => __( 'عنوان', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-heading-title',
			)
		);
		$this->add_responsive_control(
			'title_gradient',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-heading-title' => 'color: {{VALUE}};',
				),
				'default'   => '#000000',
				'tablet_default' => '',
				'mobile_default' => '',
			)
		);		

		$this->add_control(
			'title_stroke',
			array(
				'label'        => __( 'لبه متن', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_control(
			'stroke_width',
			array(
				'label'      => __( 'عرض لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 1,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-heading-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'title_stroke' => 'yes',
				),
			)
		);

		$this->add_control(
			'stroke_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-heading-title' => '-webkit-text-stroke-color: {{VALUE}};',
				),
				'condition' => array(
					'title_stroke' => 'yes',
				),
			)
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'text_shadow',
				'selector' => '{{WRAPPER}} .nour-heading-title',
			)
		);

		$this->add_control(
			'blend_mode',
			array(
				'label'     => esc_html__( 'همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					''            => esc_html__( 'طبیعی', 'nour-elementor-addons' ),
					'multiply'    => 'چندگانه',
					'screen'      => 'صفحه',
					'overlay'     => 'پوشش',
					'darken'      => 'تاریک',
					'lighten'     => 'روشن',
					'color-dodge' => 'دوج رنگی',
					'saturation'  => 'اشباع',
					'color'       => 'رنگ',
					'difference'  => 'تفاوت',
					'exclusion'   => 'محرومیت',
					'hue'         => 'مقیاس رنگ',
					'luminosity'  => 'درخشندگی',
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-heading-title' => 'mix-blend-mode: {{VALUE}}',
				),
				'separator' => 'none',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_center_title',
			array(
				'label' => __( 'عنوان میانی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'center_title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-title-focus',
			)
		);

		$this->add_responsive_control(
			'center_title_gradient',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-title-focus' => 'color: {{VALUE}};',
				),
				'default'   => '',
				'tablet_default' => '',
				'mobile_default' => '',
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'center_title_background',
				'types'     => array( 'classic', 'gradient' ),
				'selector'  => '{{WRAPPER}} .nour-title-focus',
			)
		);

		$this->add_control(
			'center_title_stroke',
			array(
				'label'        => __( 'لبه متن', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'هیچ', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_control(
			'center_stroke_width',
			array(
				'label'      => __( 'عرض لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', 'rem' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 1,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-title-focus' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'center_title_stroke' => 'yes',
				),
			)
		);

		$this->add_control(
			'center_stroke_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-title-focus' => '-webkit-text-stroke-color: {{VALUE}};',
				),
				'condition' => array(
					'center_title_stroke' => 'yes',
				),
			)
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'center_title_text_shadow',
				'selector' => '{{WRAPPER}} .nour-title-focus',
			)
		);

		$this->add_control(
			'center_title_blend_mode',
			array(
				'label'     => esc_html__( 'همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					''            => esc_html__( 'طبیعی', 'nour-elementor-addons' ),
					'multiply'    => 'چندگانه',
					'screen'      => 'صفحه',
					'overlay'     => 'پوشش',
					'darken'      => 'تاریک',
					'lighten'     => 'روشن',
					'color-dodge' => 'دوج رنگی',
					'saturation'  => 'اشباع',
					'color'       => 'رنگ',
					'difference'  => 'تفاوت',
					'exclusion'   => 'محرومیت',
					'hue'         => 'مقیاس رنگ',
					'luminosity'  => 'درخشندگی',
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-title-focus' => 'mix-blend-mode: {{VALUE}}',
				),
				'separator' => 'none',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'center_title_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-title-focus',
			)
		);

		$this->add_responsive_control(
			'center_title_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-title-focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'center_title_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-title-focus' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'heading/layout/frontend.php';
	}
}
