<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use NourElementorAddons\Control\Nour_Elementor_Widget_Area;

if ( ! defined( 'ABSPATH' ) ) {exit;}

class Content_Toggle extends Widget_Base {
	public function get_name() {
		return 'nour-content-toggle';
	}
	public function get_title() {
		return __( 'مطالب آکاردئونی', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-content-toggle nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'content', 'toggle', 'toggler', 'switch' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_content-primary',
			array(
				'label' => __( 'اصلی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'primary_label',
			array(
				'label'       => __( 'برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => __( 'ماهانه', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'primary_source',
			array(
				'type'    => Controls_Manager::SELECT,
				'label'   => __( 'منبع', 'nour-elementor-addons' ),
				'default' => 'editor',
				'options' => array(
					'editor'   => __( 'ویرایشگر', 'nour-elementor-addons' ),
					'template' => __( 'قالب المنتور', 'nour-elementor-addons' ),
					'dynamic'  => __( 'محتوای پویا', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'primary_editor',
			array(
				'label'      => __( 'ویرایشگر محتوا', 'nour-elementor-addons' ),
				'default'    => __( 'محتوای اصلی خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'show_label' => false,
				'type'       => Controls_Manager::WYSIWYG,
				'condition'  => array(
					'primary_source' => 'editor',
				),
			)
		);

		$this->add_control(
			'primary_content',
			array(
				'label'       => esc_html__( 'محتوا', 'nour-elementor-addons' ),
				'type'        => Nour_Elementor_Widget_Area::TYPE,
				'label_block' => true,
				'condition'   => array(
					'primary_source' => 'dynamic',
				),
			)
		);

		$this->add_control(
			'primary_template',
			array(
				'label'         => __( 'قالب', 'nour-elementor-addons' ),
				'placeholder'   => __( 'یک قالب برای نمایش انتخاب کنید', 'nour-elementor-addons' ),
				'type'          => Controls_Manager::SELECT2,
				'label_block'   => false,
				'show_label' => false,
				'options'       => nour_elementor_get_section_templates(),
				'condition'     => array(
					'primary_source' => 'template',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_content-secondary',
			array(
				'label' => __( 'فرعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'secondary_label',
			array(
				'label'       => __( 'برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => __( 'سالیانه', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'secondary_source',
			array(
				'type'    => Controls_Manager::SELECT,
				'label'   => __( 'منبع', 'nour-elementor-addons' ),
				'default' => 'editor',
				'options' => array(
					'editor'   => __( 'ویرایشگر', 'nour-elementor-addons' ),
					'template' => __( 'قالب المنتور', 'nour-elementor-addons' ),
					'dynamic'  => __( 'محتوای پویا', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'secondary_editor',
			array(
				'label'      => __( 'ویرایشگر محتوا', 'nour-elementor-addons' ),
				'default'    => __( 'محتوای خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'show_label' => false,
				'type'       => Controls_Manager::WYSIWYG,
				'condition'  => array(
					'secondary_source' => 'editor',
				),
			)
		);

		$this->add_control(
			'secondary_content',
			array(
				'label'       => esc_html__( 'محتوا', 'nour-elementor-addons' ),
				'type'        => Nour_Elementor_Widget_Area::TYPE,
				'label_block' => true,
				'condition'   => array(
					'secondary_source' => 'dynamic',
				),
			)
		);

		$this->add_control(
			'secondary_template',
			array(
				'label'         => __( 'قالب', 'nour-elementor-addons' ),
				'placeholder'   => __( 'یک قالب برای نمایش انتخاب کنید', 'nour-elementor-addons' ),
				'type'          => Controls_Manager::SELECT2,
				'label_block'   => false,
				'show_label' => false,
				'options'       => nour_elementor_get_section_templates(),
				'condition'     => array(
					'secondary_source' => 'template',
				),
			)
		);

		$this->add_control(
			'default_active',
			array(
				'label'        => __( 'فعال بودن پیشفرض', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_general',
			array(
				'label' => __( 'تعویض', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'              => esc_html__( 'طرح بندی', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => '1',
				'options'            => array(
					'1' => esc_html__( 'طرح بندی 1', 'nour-elementor-addons' ),
					'2' => esc_html__( 'طرح بندی 2', 'nour-elementor-addons' ),
					'3' => esc_html__( 'طرح بندی 3', 'nour-elementor-addons' ),
					'4' => esc_html__( 'طرح بندی 4', 'nour-elementor-addons' ),
					'5' => esc_html__( 'طرح بندی 5', 'nour-elementor-addons' ),
					'6' => esc_html__( 'طرح بندی 6', 'nour-elementor-addons' ),
				),
				'frontend_available' => true,
			)
		);

		$this->add_responsive_control(
			'tab_horizontal_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'flex-start' => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center'     => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'flex-end'   => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper' => 'justify-content: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 20,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 40,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-content-toggle-button'                                             => 'height: {{SIZE}}{{UNIT}}; width: calc({{SIZE}}{{UNIT}} * 2);',
					'{{WRAPPER}} .nour-content-toggle-button-layout-4 .nour-content-toggle-button'        => 'height: calc({{SIZE}}{{UNIT}} / 2);',
					'{{WRAPPER}} .nour-content-toggle-handle'                                             => 'height: calc({{SIZE}}{{UNIT}} - 10px); width: calc({{SIZE}}{{UNIT}} - 10px);',
					'{{WRAPPER}} .nour-content-toggle-button-layout-2 .nour-content-toggle-button'        => 'height: {{SIZE}}{{UNIT}}; width: calc({{SIZE}}{{UNIT}} * 2);',
					'{{WRAPPER}} .nour-content-toggle-button-layout-2 .nour-content-toggle-handle'        => 'height: calc({{SIZE}}{{UNIT}} - 15px); width: calc({{SIZE}}{{UNIT}} - 15px);',
					'{{WRAPPER}} .nour-content-toggle-button-wrapper.active .nour-content-toggle-handle'  => 'left: calc({{SIZE}}{{UNIT}} + 5px);',
					'{{WRAPPER}} .nour-content-toggle-button-layout-4.active .nour-content-toggle-handle' => 'left: calc({{SIZE}}{{UNIT}} + 10px);',
					'{{WRAPPER}} .nour-content-toggle-button-layout-2.active .nour-content-toggle-handle' => 'left: calc({{SIZE}}{{UNIT}} + 2px);',
				),
				'condition'  => array(
					'layout!' => array( '6' ),
				),
			)
		);

		$this->add_responsive_control(
			'space_between',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 25,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-content-toggle-button' => 'margin: 0 {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'layout!' => array( '6' ),
				),
			)
		);

		$this->add_responsive_control(
			'width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 500,
						'step' => 5,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 250,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '6',
				),
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 60,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '6',
				),
			)
		);

		$this->start_controls_tabs( 'toggle_button_tabs' );

		$this->start_controls_tab(
			'toggle_button_normal',
			array(
				'label' => __( 'اصلی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'toggle_button_color',
			array(
				'label'     => __( 'رنگ کنترل کننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper .nour-content-toggle-handle' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_button_background',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper .nour-content-toggle-button' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_button_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-layout-2 .nour-content-toggle-button' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'toggle_button_active',
			array(
				'label' => __( 'فرعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'toggle_button_active_color',
			array(
				'label'     => __( 'رنگ کنترل کننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper.active .nour-content-toggle-handle' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_button_active_background',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper.active .nour-content-toggle-button' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_button_active_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-layout-2.active .nour-content-toggle-button' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_label',
			array(
				'label' => __( 'برچسب', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_content_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-content-toggle-before,{{WRAPPER}} .nour-content-toggle-after,{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button::before,{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button::after',
			)
		);

		$this->start_controls_tabs( 'toggle_label_tabs' );

		$this->start_controls_tab(
			'toggle_label_primary',
			array(
				'label' => __( 'اصلی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'toggle_label_primary_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper.active .nour-content-toggle-before'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-content-toggle-button-layout-6.active .nour-content-toggle-button::before' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_label_primary_active_color',
			array(
				'label'     => __( 'رنگ فعال', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper .nour-content-toggle-before'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button::before' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'toggle_label_secondary',
			array(
				'label' => __( 'فرعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'toggle_label_secondary_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper .nour-content-toggle-after'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-content-toggle-button-layout-6 .nour-content-toggle-button::after' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'toggle_label_secondary_active_color',
			array(
				'label'     => __( 'رنگ فعال', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-content-toggle-button-wrapper.active .nour-content-toggle-after'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-content-toggle-button-layout-6.active .nour-content-toggle-button::after' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_content',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'tab_content_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-toggle-content-wrapper' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'tab_content_typo',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-toggle-content-wrapper,{{WRAPPER}} .nour-toggle-content-wrapper > *',
			)
		);

		$this->add_control(
			'tab_content_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-toggle-content-wrapper, {{WRAPPER}} .nour-toggle-content-wrapper > *' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'tab_content_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'کلاسیک', 'gradient' ),
				'exclude'  => array( 'تصویر' ),
				'selector' => '{{WRAPPER}} .nour-toggle-content-wrapper',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'tab_content_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-toggle-content-wrapper',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'tab_content_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-toggle-content-wrapper',
			)
		);

		$this->add_responsive_control(
			'tab_content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-toggle-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'tab_content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-toggle-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'tab_content_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-toggle-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'content-toggle/layout/frontend.php';
	}
}
