<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}
class Animated_Link extends Widget_Base {

	public function get_name() {
		return 'nour-animated-link';
	}
	public function get_title() {
		return __( 'پیوند ویژه', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-link nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'animated', 'link', 'cta' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'layouts',
			array(
				'label'   => esc_html__( 'طرح بندی', 'nour-elementor-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style-1',
				'options' => array(
					'style-1'  => esc_html__( 'سبک 1', 'nour-elementor-addons' ),
					'style-2'  => esc_html__( 'سبک 2', 'nour-elementor-addons' ),
					'style-3'  => esc_html__( 'سبک 3', 'nour-elementor-addons' ),
					'style-4'  => esc_html__( 'سبک 4', 'nour-elementor-addons' ),
					'style-5'  => esc_html__( 'سبک 5', 'nour-elementor-addons' ),
					'style-6'  => esc_html__( 'سبک 6', 'nour-elementor-addons' ),
					'style-7'  => esc_html__( 'سبک 7', 'nour-elementor-addons' ),
					'style-8'  => esc_html__( 'سبک 8', 'nour-elementor-addons' ),
					'style-9'  => esc_html__( 'سبک 9', 'nour-elementor-addons' ),
					'style-10' => esc_html__( 'سبک 10', 'nour-elementor-addons' ),
					'style-11' => esc_html__( 'سبک 11', 'nour-elementor-addons' ),
					'style-12' => esc_html__( 'سبک 12', 'nour-elementor-addons' ),
					'style-13' => esc_html__( 'سبک 13', 'nour-elementor-addons' ),
					'style-14' => esc_html__( 'سبک 14', 'nour-elementor-addons' ),
					'style-15' => esc_html__( 'سبک 15', 'nour-elementor-addons' ),
					'style-16' => esc_html__( 'سبک 16', 'nour-elementor-addons' ),
					'style-17' => esc_html__( 'سبک 17', 'nour-elementor-addons' ),
					'style-18' => esc_html__( 'سبک 18', 'nour-elementor-addons' ),
					'style-19' => esc_html__( 'سبک 19', 'nour-elementor-addons' ),
					'style-20' => esc_html__( 'سبک 20', 'nour-elementor-addons' ),
					'style-21' => esc_html__( 'سبک 21', 'nour-elementor-addons' ),
					'style-22' => esc_html__( 'سبک 22', 'nour-elementor-addons' ),
					'style-23' => esc_html__( 'سبک 23', 'nour-elementor-addons' ),
					'style-24' => esc_html__( 'سبک 24', 'nour-elementor-addons' ),
					'style-25' => esc_html__( 'سبک 25', 'nour-elementor-addons' ),
				),
			)
		);
		$this->add_control(
			'text',
			array(
				'label'       => __( 'متن', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => __( 'اینجا کلیک کنید', 'nour-elementor-addons' ),
				'placeholder' => __( 'اینجا کلیک کنید', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'link',
			array(
				'label'       => __( 'پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => array(
					'active' => true,
				),
				'placeholder' => __( 'https://your-link.com', 'nour-elementor-addons' ),
				'default'     => array(
					'url' => '#',
				),
			)
		);
		$this->add_responsive_control(
			'align',
			array(
				'label'        => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => array(
					'left'    => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center'  => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'   => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
					'justify' => array(
						'title' => __( 'تراز شده', 'nour-elementor-addons' ),
						'icon'  => 'eicon-text-align-justify',
					),
				),
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'center',
			)
		);
		$this->add_control(
			'link_css_id',
			array(
				'label'       => __( 'شناسه پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => '',
				'title'       => __( 'شناسه سفارشی خود را ضافه کنید. به عنوان مثال: شناسه من', 'nour-elementor-addons' ),
				'description' => __( 'لطفاً مطمئن شوید که شناسه منحصر به فرد است و در جای دیگری از صفحه نمایش این فرم استفاده نشده است. این فیلد به <code>A-z 0-9</code> و زیرخط بدون فاصله اجازه می دهد.', 'nour-elementor-addons' ),
				'separator'   => 'before',

			)
		);
		$this->add_control(
			'onclick_event',
			array(
				'label'       => esc_html__( 'واکنش در حال کلیک', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => 'myFunction()',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography',
				'selector' => '{{WRAPPER}} .nour-animated-link',
			)
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			array(
				'name'     => 'text_shadow',
				'selector' => '{{WRAPPER}} .animated-link-text',
			)
		);
		$this->start_controls_tabs( 'tabs_link_style' );

		$this->start_controls_tab(
			'tab_link_normal',
			array(
				'label' => __( 'استاندارد', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'link_text_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-animated-link' => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-animated-link-style-25' => 'background-image: linear-gradient(to right, #54b3d6, #54b3d6 50%, {{VALUE}} 50%);',
				),
			)
		);
		$this->add_control(
			'line_color',
			array(
				'label'     => __( 'رنگ خط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-animated-link-style-23 .nour-animated-link-graphic' => 'stroke: {{VALUE}};',
					'{{WRAPPER}} .nour-animated-link-style-18::before' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'layouts' => array( 'style-18', 'style-23' ),
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_link_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'hover_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-animated-link:hover,{{WRAPPER}} .nour-animated-link-style-10:hover span,{{WRAPPER}} .nour-animated-link-style-12::after' => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-animated-link-style-25' => 'background-image: linear-gradient(to right, {{VALUE}}, {{VALUE}} 50%, {{link_text_color.VALUE}} 50%);',
				),
			)
		);
		$this->add_control(
			'line_hover_color',
			array(
				'label'     => __( 'رنگ خط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-animated-link:before,{{WRAPPER}} .nour-animated-link::after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .nour-animated-link-style-20::after' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .nour-animated-link-style-21 .nour-animated-link-graphic,{{WRAPPER}} .nour-animated-link-style-22 .nour-animated-link-graphic,
					{{WRAPPER}} .nour-animated-link-style-23:hover .nour-animated-link-graphic' => 'stroke: {{VALUE}};',
				),
				'condition' => array(
					'layouts!' => array( 'style-10', 'style-14', 'style-15', 'style-17', 'style-18' ),
				),
			)
		);
		$this->add_control(
			'dots_hover_color',
			array(
				'label'     => __( 'رنگ نقطه ها', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-animated-link-style-17:hover::before,{{WRAPPER}} .nour-animated-link-style-17:focus::before' => 'color: {{VALUE}}; text-shadow: 10px 0 {{VALUE}}, -10px 0 {{VALUE}}',
				),
				'condition' => array(
					'layouts' => array( 'style-17' ),
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'animated-link/layout/frontend.php';
	}
}