<?php
namespace NourElementorAddons\Inc;
class Nour_WPML_Compatibility {
	private static $_instance = null;
	private function __construct() {

		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets' ) );
	}
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}
	public function wpml_widgets( $widgets ) {
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/business-hours.php';
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/horizontal-timeline.php';
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/hot-spot.php';
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/news-ticker.php';
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/pricing.php';
		include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/widgets/image-gallery.php';
		$widgets_map = array(
			'nour-animated-link'       => array(
				'conditions' => array( 'widgetType' => 'nour-animated-link' ),
				'fields'     => array(
					array(
						'field'       => 'text',
						'type'        => __( 'پیوند ویژه: متن', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-before-after'        => array(
				'conditions' => array( 'widgetType' => 'nour-before-after' ),
				'fields'     => array(
					array(
						'field'       => 'before_label',
						'type'        => __( 'قبل و بعد: برچسب قبل', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'after_label',
						'type'        => __( 'قبل و بعد: برچسب بعد', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-block-quote'         => array(
				'conditions' => array( 'widgetType' => 'nour-block-quote' ),
				'fields'     => array(
					array(
						'field'       => 'quote_title',
						'type'        => __( 'نقل قول: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'quote_designation',
						'type'        => __( 'نقل قول: سمت', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'quote_description',
						'type'        => __( 'نقل قول: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
				),
			),
			'nour-business-hours'      => array(
				'conditions'        => array( 'widgetType' => 'nour-business-hours' ),
				'fields'            => array(
					array(
						'field'       => 'title',
						'type'        => __( 'ساعات کاری: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'sub_title',
						'type'        => __( 'ساعات کاری: زیرعنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
				'integration-class' => __NAMESPACE__ . '\\WPML_Business_Hours',
			),
			'nour-content-toggle'      => array(
				'conditions' => array( 'widgetType' => 'nour-content-toggle' ),
				'fields'     => array(
					array(
						'field'       => 'primary_label',
						'type'        => __( 'آکاردئون مطالب: برچسب اصلی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'primary_editor',
						'type'        => __( 'آکاردئون مطالب: ویرایشگر اصلی', 'nour-elementor-addons' ),
						'editor_type' => 'VISUAL',
					),
					array(
						'field'       => 'secondary_label',
						'type'        => __( 'آکاردئون مطالب: برچسب فرعی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'secondary_editor',
						'type'        => __( 'آکاردئون مطالب: ویرایشگر فرعی', 'nour-elementor-addons' ),
						'editor_type' => 'VISUAL',
					),
				),
			),
			'nour-counter'             => array(
				'conditions' => array( 'widgetType' => 'nour-counter' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => __( 'شمارنده: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'description',
						'type'        => __( 'شمارنده: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
					array(
						'field'       => 'badge_text',
						'type'        => __( 'شمارنده: متن برچسب', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-heading'             => array(
				'conditions' => array( 'widgetType' => 'nour-heading' ),
				'fields'     => array(
					array(
						'field'       => 'title_before',
						'type'        => __( 'تیتر حرفه ای: متن ابتدایی', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
					array(
						'field'       => 'title_center',
						'type'        => __( 'تیتر حرفه ای: متن مرکزی', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
					array(
						'field'       => 'title_after',
						'type'        => __( 'تیتر حرفه ای: متن انتهایی', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
				),
			),
			'nour-horizontal-timeline' => array(
				'conditions'        => array( 'widgetType' => 'nour-horizontal-timeline' ),
				'fields'            => array(),
				'integration-class' => __NAMESPACE__ . '\\WPML_Horizontal_Timeline',
			),
			'nour-hot-spot'            => array(
				'conditions'        => array( 'widgetType' => 'nour-hot-spot' ),
				'integration-class' => __NAMESPACE__ . '\\WPML_Hot_Spot',
			),
			'nour-news-ticker'         => array(
				'conditions'        => array( 'widgetType' => 'nour-news-ticker' ),
				'fields'            => array(
					array(
						'field'       => 'title',
						'type'        => __( 'سرخط خبرها: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
				'integration-class' => __NAMESPACE__ . '\\WPML_News_Ticker',
			),
			'nour-post-grid'           => array(
				'conditions' => array( 'widgetType' => 'nour-post-grid' ),
				'fields'     => array(
					array(
						'field'       => 'readmore_text',
						'type'        => __( 'شبکه پست: جزئیات بیشتر', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'author_title',
						'type'        => __( 'شبکه پست: عنوان نویسنده', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'prev_label',
						'type'        => __( 'شبکه پست: برچسب قبلی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'next_label',
						'type'        => __( 'شبکه پست: برچسب بعدی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-pricing'             => array(
				'conditions'        => array( 'widgetType' => 'nour-pricing' ),
				'fields'            => array(
					array(
						'field'       => 'title',
						'type'        => __( 'تعرفه ها: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'price',
						'type'        => __( 'تعرفه ها: قیمت', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'period',
						'type'        => __( 'تعرفه ها: دوره', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'features_title',
						'type'        => __( 'تعرفه ها: عنوان ویژگی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'item_description',
						'type'        => __( 'تعرفه ها: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'VISUAL',
					),
					array(
						'field'       => 'button_title',
						'type'        => __( 'تعرفه ها: عنوان دکمه', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'badge_text',
						'type'        => __( 'تعرفه ها: متن برچسب', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
				'integration-class' => __NAMESPACE__ . '\\WPML_Pricing',
			),
			'nour-progress-bar'        => array(
				'conditions' => array( 'widgetType' => 'nour-progress-bar' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => __( 'نوار پیشرفت: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-image-gallery'      => array(
				'conditions'        => array( 'widgetType' => 'nour-image-gallery' ),
				'fields'            => array(),
				'integration-class' => __NAMESPACE__ . '\\WPML_Simple_Gallery',
			),
			'nour-step-flow'           => array(
				'conditions' => array( 'widgetType' => 'nour-step-flow' ),
				'fields'     => array(
					array(
						'field'       => 'step_flow_title',
						'type'        => __( 'مراحل توسعه: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'step_flow_description',
						'type'        => __( 'مراحل توسعه: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'VISUAL',
					),
					array(
						'field'       => 'step_flow_badge_text',
						'type'        => __( 'مراحل توسعه: متن برچسب', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-team'                => array(
				'conditions' => array( 'widgetType' => 'nour-team' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => __( 'اعضای تیم: نام', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'designation',
						'type'        => __( 'اعضای تیم: سمت', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'description',
						'type'        => __( 'اعضای تیم: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
				),
			),
			'nour-woo-product-grid'    => array(
				'conditions' => array( 'widgetType' => 'nour-woo-product-grid' ),
				'fields'     => array(
					array(
						'field'       => 'prev_label',
						'type'        => __( 'شبکه محصولات: برچسب قبلی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'next_label',
						'type'        => __( 'شبکه محصولات: برچسب بعدی', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
				),
			),
			'nour-pie-chart'           => array(
				'conditions' => array( 'widgetType' => 'nour-pie-chart' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => __( 'شمارنده دایره ای: عنوان', 'nour-elementor-addons' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'description',
						'type'        => __( 'شمارنده دایره ای: توضیحات', 'nour-elementor-addons' ),
						'editor_type' => 'AREA',
					),
				),
			),
		);
		foreach ( $widgets_map as $key => $data ) {
			$widget_name = $key;
			$entry = array(
				'conditions' => array(
					'widgetType' => $widget_name,
				),
				'fields'     => isset( $data['fields'] ) ? $data['fields'] : array(),
			);
			if ( isset( $data['integration-class'] ) ) {
				$entry['integration-class'] = $data['integration-class'];
			}
			$widgets[ $widget_name ] = $entry;
		}
		return $widgets;
	}
}
Nour_WPML_Compatibility::instance();
