<?php
namespace NourElementorAddons\Inc;
defined( 'ABSPATH' ) || die();
class WPML_Horizontal_Timeline extends \WPML_Elementor_Module_With_Items {

	public function get_items_field() {
		return 'horizontal_timeline_item';
	}
	public function get_fields() {
		return array( 'title', 'date_custom', 'sub_title', 'description', 'custom' );
	}
	protected function get_title( $field ) {
		switch ( $field ) {
			case 'title':
				return __( 'نوار زمان افقی: عنوان', 'nour-elementor-addons' );
			case 'date_custom':
				return __( 'نوار زمان افقی: تاریخ', 'nour-elementor-addons' );
			case 'sub_title':
				return __( 'نوار زمان افقی: زیرعنوان', 'nour-elementor-addons' );
			case 'description':
				return __( 'نوار زمان افقی: توضیحات', 'nour-elementor-addons' );
			case 'custom':
				return __( 'نوار زمان افقی: سفارشی', 'nour-elementor-addons' );
			default:
				return '';
		}
	}
	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'title':
			case 'date_custom':
			case 'sub_title':
			case 'custom':
				return 'LINE';
			case 'description':
				return 'AREA';
			default:
				return '';
		}
	}
}